/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;

public class SentenceHMMStateArc
implements SearchStateArc {
    private final SentenceHMMState nextState;
    private final float logLanguageProbability;
    private final float logInsertionProbability;
    private final int hashCode;

    public SentenceHMMStateArc(SentenceHMMState nextState, float logLanguageProbability, float logInsertionProbability) {
        this.nextState = nextState;
        this.logLanguageProbability = logLanguageProbability;
        this.logInsertionProbability = logInsertionProbability;
        this.hashCode = 111 + nextState.hashCode() + 17 * Float.floatToIntBits(logLanguageProbability) + 23 * Float.floatToIntBits(logInsertionProbability);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SentenceHMMStateArc) {
            SentenceHMMStateArc other = (SentenceHMMStateArc)o;
            return this.nextState == other.nextState && this.logLanguageProbability == other.logLanguageProbability && this.logInsertionProbability == other.logInsertionProbability;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public SearchState getState() {
        return this.nextState;
    }

    public SentenceHMMState getNextState() {
        return (SentenceHMMState)this.getState();
    }

    @Override
    public float getLanguageProbability() {
        return this.logLanguageProbability;
    }

    @Override
    public float getInsertionProbability() {
        return this.logInsertionProbability;
    }

    @Override
    public float getProbability() {
        return this.logLanguageProbability + this.logInsertionProbability;
    }
}

