/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.dictionary.Pronunciation;

public class Word
implements Comparable<Word> {
    public static final Word UNKNOWN;
    private final String spelling;
    private final Pronunciation[] pronunciations;
    private final boolean isFiller;

    public Word(String spelling, Pronunciation[] pronunciations, boolean isFiller) {
        this.spelling = spelling;
        this.pronunciations = pronunciations;
        this.isFiller = isFiller;
    }

    public String getSpelling() {
        return this.spelling;
    }

    public boolean isFiller() {
        return this.isFiller;
    }

    public boolean isSentenceEndWord() {
        return "</s>".equals(this.spelling);
    }

    public boolean isSentenceStartWord() {
        return "<s>".equals(this.spelling);
    }

    public Pronunciation[] getPronunciations() {
        return this.pronunciations;
    }

    public Pronunciation getMostLikelyPronunciation() {
        float bestScore = Float.NEGATIVE_INFINITY;
        Pronunciation best = null;
        for (Pronunciation pronunciation : this.pronunciations) {
            if (!(pronunciation.getProbability() > bestScore)) continue;
            bestScore = pronunciation.getProbability();
            best = pronunciation;
        }
        return best;
    }

    public int hashCode() {
        return this.spelling.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Word && this.spelling.equals(((Word)obj).spelling);
    }

    public String toString() {
        return this.spelling;
    }

    @Override
    public int compareTo(Word other) {
        return this.getSpelling().compareTo(other.getSpelling());
    }

    static {
        Pronunciation[] pros = new Pronunciation[]{Pronunciation.UNKNOWN};
        UNKNOWN = new Word("<unk>", pros, false);
        Pronunciation.UNKNOWN.setWord(UNKNOWN);
    }
}

