/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.allphone;

import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.allphone.AllphoneLinguist;
import edu.cmu.sphinx.linguist.allphone.PhoneWordSearchState;

public class PhoneNonEmittingSearchState
implements SearchState,
SearchStateArc {
    protected Unit unit;
    protected AllphoneLinguist linguist;
    private float insertionProb;
    private float languageProb;

    public PhoneNonEmittingSearchState(Unit unit, AllphoneLinguist linguist, float insertionProb, float languageProb) {
        this.unit = unit;
        this.linguist = linguist;
        this.insertionProb = insertionProb;
        this.languageProb = languageProb;
    }

    @Override
    public SearchStateArc[] getSuccessors() {
        SearchStateArc[] result = new SearchStateArc[]{new PhoneWordSearchState(this.unit, this.linguist, this.insertionProb, this.languageProb)};
        return result;
    }

    @Override
    public boolean isEmitting() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public String toPrettyString() {
        return "Unit " + this.unit.toString();
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public WordSequence getWordHistory() {
        return null;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public SearchState getState() {
        return this;
    }

    @Override
    public float getProbability() {
        return this.getLanguageProbability() + this.getInsertionProbability();
    }

    @Override
    public float getLanguageProbability() {
        return this.languageProb;
    }

    @Override
    public float getInsertionProbability() {
        return this.insertionProb;
    }

    @Override
    public Object getLexState() {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PhoneNonEmittingSearchState)) {
            return false;
        }
        boolean haveSameBaseId = ((PhoneNonEmittingSearchState)obj).unit.getBaseID() == this.unit.getBaseID();
        boolean haveSameContex = ((PhoneNonEmittingSearchState)obj).unit.getContext().equals(this.unit.getContext());
        return haveSameBaseId && haveSameContex;
    }

    public int hashCode() {
        return this.unit.getContext().hashCode() * 91 + this.unit.getBaseID();
    }
}

