/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.allphone;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.allphone.AllphoneSearchGraph;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class AllphoneLinguist
implements Linguist {
    @S4Component(type=AcousticModel.class)
    public static final String PROP_ACOUSTIC_MODEL = "acousticModel";
    @S4Double(defaultValue=0.05)
    public static final String PROP_PIP = "phoneInsertionProbability";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CD = "useContextDependentPhones";
    private AcousticModel acousticModel;
    private ArrayList<HMM> ciHMMs;
    private ArrayList<HMM> fillerHMMs;
    private ArrayList<HMM> leftContextSilHMMs;
    private HashMap<SenoneSequence, ArrayList<Unit>> senonesToUnits;
    private HashMap<Unit, HashMap<Unit, ArrayList<HMM>>> cdHMMs;
    private float pip;
    private boolean useCD;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.acousticModel = (AcousticModel)ps.getComponent(PROP_ACOUSTIC_MODEL);
        this.pip = LogMath.getLogMath().linearToLog(ps.getFloat(PROP_PIP));
        this.useCD = ps.getBoolean(PROP_CD);
        if (this.useCD) {
            this.createContextDependentSuccessors();
        } else {
            this.createContextIndependentSuccessors();
        }
    }

    @Override
    public SearchGraph getSearchGraph() {
        return new AllphoneSearchGraph(this);
    }

    @Override
    public void startRecognition() {
    }

    @Override
    public void stopRecognition() {
    }

    @Override
    public void allocate() throws IOException {
    }

    @Override
    public void deallocate() throws IOException {
    }

    public AcousticModel getAcousticModel() {
        return this.acousticModel;
    }

    public float getPhoneInsertionProb() {
        return this.pip;
    }

    public boolean useContextDependentPhones() {
        return this.useCD;
    }

    public ArrayList<HMM> getCISuccessors() {
        return this.ciHMMs;
    }

    public ArrayList<HMM> getCDSuccessors(Unit lc, Unit base) {
        if (lc.isFiller()) {
            return this.leftContextSilHMMs;
        }
        if (base == UnitManager.SILENCE) {
            return this.fillerHMMs;
        }
        return this.cdHMMs.get(lc).get(base);
    }

    public ArrayList<Unit> getUnits(SenoneSequence senoneSeq) {
        return this.senonesToUnits.get(senoneSeq);
    }

    private void createContextIndependentSuccessors() {
        Iterator<HMM> hmmIter = this.acousticModel.getHMMIterator();
        this.ciHMMs = new ArrayList();
        this.senonesToUnits = new HashMap();
        while (hmmIter.hasNext()) {
            HMM hmm = hmmIter.next();
            if (hmm.getUnit().isContextDependent()) continue;
            SenoneSequence senoneSeq = ((SenoneHMM)hmm).getSenoneSequence();
            ArrayList<Unit> sameSenonesUnits = this.senonesToUnits.get(senoneSeq);
            if (sameSenonesUnits == null) {
                sameSenonesUnits = new ArrayList();
                this.senonesToUnits.put(senoneSeq, sameSenonesUnits);
            }
            sameSenonesUnits.add(hmm.getUnit());
            this.ciHMMs.add(hmm);
        }
    }

    private void createContextDependentSuccessors() {
        this.cdHMMs = new HashMap();
        this.senonesToUnits = new HashMap();
        this.fillerHMMs = new ArrayList();
        this.leftContextSilHMMs = new ArrayList();
        Iterator<HMM> hmmIter = this.acousticModel.getHMMIterator();
        while (hmmIter.hasNext()) {
            ArrayList<HMM> lcBaseSuccessors;
            HMM hmm = hmmIter.next();
            SenoneSequence senoneSeq = ((SenoneHMM)hmm).getSenoneSequence();
            ArrayList<Unit> sameSenonesUnits = this.senonesToUnits.get(senoneSeq);
            if (sameSenonesUnits == null) {
                sameSenonesUnits = new ArrayList();
                this.senonesToUnits.put(senoneSeq, sameSenonesUnits);
            }
            sameSenonesUnits.add(hmm.getUnit());
            if (hmm.getUnit().isFiller()) {
                this.fillerHMMs.add(hmm);
                continue;
            }
            if (!hmm.getUnit().isContextDependent()) continue;
            LeftRightContext context = (LeftRightContext)hmm.getUnit().getContext();
            Unit lc = context.getLeftContext()[0];
            if (lc == UnitManager.SILENCE) {
                this.leftContextSilHMMs.add(hmm);
                continue;
            }
            Unit base = hmm.getUnit().getBaseUnit();
            HashMap<Unit, ArrayList<HMM>> lcSuccessors = this.cdHMMs.get(lc);
            if (lcSuccessors == null) {
                lcSuccessors = new HashMap();
                this.cdHMMs.put(lc, lcSuccessors);
            }
            if ((lcBaseSuccessors = lcSuccessors.get(base)) == null) {
                lcBaseSuccessors = new ArrayList();
                lcSuccessors.put(base, lcBaseSuccessors);
            }
            lcBaseSuccessors.add(hmm);
        }
        this.leftContextSilHMMs.addAll(this.fillerHMMs);
    }
}

