/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;

public class TrainerScore {
    private Data feature;
    private float logOutputProbability;
    private float logScalingFactor;
    private int senoneID;
    private HMMState hmmState;
    private Senone senone;
    private float logAlpha;
    private float logBeta;
    private float logGamma;
    private float[] logComponentGamma;
    private float[] logComponentProb;
    private static float logLikelihood;

    public TrainerScore(Data feature, float probability, int senone) {
        this.feature = feature;
        this.logOutputProbability = probability;
        this.senoneID = senone;
        this.logScalingFactor = 0.0f;
        this.logAlpha = 0.0f;
        this.logBeta = 0.0f;
        this.logGamma = 0.0f;
        this.logComponentProb = new float[1];
        this.logComponentProb[0] = 0.0f;
        this.logComponentGamma = new float[1];
        this.logComponentGamma[0] = 0.0f;
    }

    public TrainerScore(Data feature, float probability, HMMState state, float logAlpha, float logBeta, float[] logComponentProb) {
        this.feature = feature;
        this.hmmState = state;
        this.logScalingFactor = 0.0f;
        if (state != null && state.isEmitting()) {
            int stateIndex = state.getState();
            SenoneHMM hmm = (SenoneHMM)state.getHMM();
            SenoneSequence ss = hmm.getSenoneSequence();
            this.senone = ss.getSenones()[stateIndex];
        }
        this.logOutputProbability = probability;
        this.logAlpha = logAlpha;
        this.logBeta = logBeta;
        this.logGamma = logAlpha + logBeta;
        if (logComponentProb != null) {
            this.logComponentProb = new float[logComponentProb.length];
            this.logComponentGamma = new float[logComponentProb.length];
            for (int i = 0; i < logComponentProb.length; ++i) {
                this.logComponentProb[i] = logComponentProb[i];
                this.logComponentGamma[i] = logComponentProb[i] + this.logGamma;
            }
        } else {
            this.logComponentProb = null;
            this.logComponentGamma = null;
        }
    }

    public TrainerScore(Data feature, float probability, HMMState state, float logAlpha, float[] logComponentProb) {
        this(feature, probability, state, logAlpha, 0.0f, logComponentProb);
    }

    public TrainerScore(Data feature, float probability, HMMState state, float[] logComponentProb) {
        this(feature, probability, state, 0.0f, 0.0f, logComponentProb);
    }

    public TrainerScore(Data feature, float probability, HMMState state) {
        this(feature, probability, state, 0.0f, 0.0f, null);
    }

    public Data getData() {
        return this.feature;
    }

    public float getScore() {
        return this.logOutputProbability;
    }

    public float getAlpha() {
        return this.logAlpha;
    }

    public float getBeta() {
        return this.logBeta;
    }

    public static float getLogLikelihood() {
        return logLikelihood;
    }

    public float getGamma() {
        return this.logGamma;
    }

    public float[] getComponentGamma() {
        return this.logComponentGamma;
    }

    public float getScalingFactor() {
        return this.logScalingFactor;
    }

    public static void setLogLikelihood(float likelihood) {
        logLikelihood = likelihood;
    }

    public void setAlpha(float logAlpha) {
        this.logAlpha = logAlpha;
    }

    public void setBeta(float logBeta) {
        this.logBeta = logBeta;
    }

    public void setGamma() {
        this.logGamma = this.logAlpha + this.logBeta + this.logScalingFactor;
        if (this.logComponentGamma != null) {
            for (int i = 0; i < this.logComponentGamma.length; ++i) {
                this.logComponentGamma[i] = this.logComponentProb[i] + this.logGamma;
                if (!(this.logComponentGamma[i] < -3.4028235E38f)) continue;
                this.logComponentGamma[i] = -3.4028235E38f;
            }
        }
    }

    public void setScalingFactor(float logScalingFactor) {
        this.logScalingFactor = logScalingFactor;
    }

    public int getSenoneID() {
        return this.senoneID;
    }

    public Senone getSenone() {
        return this.senone;
    }

    public HMMState getState() {
        return this.hmmState;
    }
}

