/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.util.LogMath;

class Buffer {
    private double[] numerator;
    private double denominator;
    private boolean wasUsed;
    private boolean isLog;
    private int id;

    Buffer(int size, boolean isLog, int id) {
        this.id = id;
        this.isLog = isLog;
        this.wasUsed = false;
        this.numerator = new double[size];
        if (isLog) {
            this.denominator = -3.4028234663852886E38;
            for (int i = 0; i < size; ++i) {
                this.numerator[i] = -3.4028234663852886E38;
            }
        }
    }

    void accumulate(float data, int entry) {
        assert (false);
        assert (this.numerator != null);
        assert (!this.isLog);
        int n = entry;
        this.numerator[n] = this.numerator[n] + (double)data;
        this.denominator += (double)data;
        this.wasUsed = true;
    }

    void logAccumulate(float data, int entry, LogMath logMath) {
        assert (this.numerator != null);
        assert (this.isLog);
        this.numerator[entry] = logMath.addAsLinear((float)this.numerator[entry], data);
        this.denominator = logMath.addAsLinear((float)this.denominator, data);
        this.wasUsed = true;
    }

    void accumulate(double[] numeratorData, double denominatorData) {
        assert (this.numerator != null);
        assert (numeratorData != null);
        assert (this.numerator.length == numeratorData.length);
        assert (!this.isLog);
        for (int i = 0; i < this.numerator.length; ++i) {
            int n = i;
            this.numerator[n] = this.numerator[n] + numeratorData[i];
        }
        this.denominator += denominatorData;
        this.wasUsed = true;
    }

    void logAccumulate(float[] logNumeratorData, float logDenominatorData, LogMath logMath) {
        assert (this.numerator != null);
        assert (logNumeratorData != null);
        assert (this.numerator.length == logNumeratorData.length);
        assert (this.isLog);
        for (int i = 0; i < this.numerator.length; ++i) {
            this.numerator[i] = logMath.addAsLinear((float)this.numerator[i], logNumeratorData[i]);
        }
        this.denominator = logMath.addAsLinear((float)this.denominator, logDenominatorData);
        this.wasUsed = true;
    }

    void normalize() {
        assert (!this.isLog);
        if (this.denominator == 0.0) {
            System.out.println("Empty denominator: " + this.id);
            this.wasUsed = false;
            return;
        }
        double invDenominator = 1.0 / this.denominator;
        int i = 0;
        while (i < this.numerator.length) {
            int n = i++;
            this.numerator[n] = this.numerator[n] * invDenominator;
        }
        this.denominator = 1.0;
    }

    void logNormalize() {
        assert (this.isLog);
        int i = 0;
        while (i < this.numerator.length) {
            int n = i++;
            this.numerator[n] = this.numerator[n] - this.denominator;
        }
        this.denominator = 0.0;
    }

    void logNormalizeNonZero(float[] mask) {
        assert (this.isLog);
        assert (mask.length == this.numerator.length);
        for (int i = 0; i < this.numerator.length; ++i) {
            if (mask[i] == -3.4028235E38f) continue;
            int n = i;
            this.numerator[n] = this.numerator[n] - this.denominator;
        }
        this.denominator = 0.0;
    }

    void normalizeToSum() {
        assert (!this.isLog);
        float den = 0.0f;
        for (double val : this.numerator) {
            den = (float)((double)den + val);
        }
        float invDenominator = (float)(1.0 / (double)den);
        int i = 0;
        while (i < this.numerator.length) {
            int n = i++;
            this.numerator[n] = this.numerator[n] * (double)invDenominator;
        }
        this.denominator = 1.0;
    }

    void logNormalizeToSum(LogMath logMath) {
        float logZero;
        assert (this.isLog);
        float den = logZero = -3.4028235E38f;
        for (double val : this.numerator) {
            if (val == (double)logZero) continue;
            den = logMath.addAsLinear(den, (float)val);
        }
        for (int i = 0; i < this.numerator.length; ++i) {
            if (this.numerator[i] == (double)logZero) continue;
            int n = i;
            this.numerator[n] = this.numerator[n] - (double)den;
        }
        this.denominator = 0.0;
    }

    protected boolean floor(float floor) {
        assert (!this.isLog);
        boolean wasModified = false;
        for (int i = 0; i < this.numerator.length; ++i) {
            if (!(this.numerator[i] < (double)floor)) continue;
            wasModified = true;
            this.numerator[i] = floor;
        }
        return wasModified;
    }

    protected boolean logFloor(float logFloor) {
        assert (this.isLog);
        boolean wasModified = false;
        for (int i = 0; i < this.numerator.length; ++i) {
            if (!(this.numerator[i] < (double)logFloor)) continue;
            wasModified = true;
            this.numerator[i] = logFloor;
        }
        return wasModified;
    }

    protected float getValue(int entry) {
        return (float)this.numerator[entry];
    }

    protected void setValue(int entry, float value) {
        this.numerator[entry] = value;
    }

    protected float[] getValues() {
        float[] returnVector = new float[this.numerator.length];
        for (int i = 0; i < this.numerator.length; ++i) {
            returnVector[i] = (float)this.numerator[i];
        }
        return returnVector;
    }

    protected boolean wasUsed() {
        return this.wasUsed;
    }

    public void dump() {
        System.out.println("Denominator= " + this.denominator);
        System.out.println("Numerators= ");
        for (int i = 0; i < this.numerator.length; ++i) {
            System.out.println("[" + i + "]= " + this.numerator[i]);
        }
    }
}

