/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.MixtureComponentSet;

public class SetBasedGaussianMixture
extends GaussianMixture {
    private MixtureComponentSet mixtureComponentSet;

    public SetBasedGaussianMixture(GaussianWeights mixtureWeights, MixtureComponentSet mixtureComponentSet, int id) {
        super(mixtureWeights, null, id);
        this.mixtureComponentSet = mixtureComponentSet;
    }

    @Override
    public float calculateScore(Data feature) {
        this.mixtureComponentSet.updateTopScores(feature);
        float ascore = 0.0f;
        for (int i = 0; i < this.mixtureWeights.getStreamsNum(); ++i) {
            float logTotal = -3.4028235E38f;
            for (int j = 0; j < this.mixtureComponentSet.getTopGauNum(); ++j) {
                float gauScore = this.mixtureComponentSet.getTopGauScore(i, j);
                int gauId = this.mixtureComponentSet.getTopGauId(i, j);
                logTotal = this.logMath.addAsLinear(logTotal, gauScore + this.mixtureWeights.get(this.id, i, gauId));
            }
            ascore += logTotal;
        }
        return ascore;
    }

    @Override
    public float[] calculateComponentScore(Data feature) {
        this.mixtureComponentSet.updateScores(feature);
        float[] scores = new float[this.mixtureComponentSet.size()];
        int scoreIdx = 0;
        for (int i = 0; i < this.mixtureWeights.getStreamsNum(); ++i) {
            for (int j = 0; j < this.mixtureComponentSet.getGauNum(); ++j) {
                scores[scoreIdx++] = this.mixtureComponentSet.getGauScore(i, j) + this.mixtureWeights.get(this.id, i, this.mixtureComponentSet.getGauId(i, j));
            }
        }
        return scores;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return this.mixtureComponentSet.toArray();
    }

    @Override
    public int dimension() {
        return this.mixtureComponentSet.dimension();
    }

    @Override
    public int numComponents() {
        return this.mixtureComponentSet.size();
    }
}

