/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.MixtureComponentSetScores;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.PrunableMixtureComponent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;

public class MixtureComponentSet {
    private int scoresQueueLen;
    private boolean toStoreScore;
    private LinkedList<MixtureComponentSetScores> storedScores;
    MixtureComponentSetScores curScores;
    private ArrayList<PrunableMixtureComponent[]> components;
    private ArrayList<PrunableMixtureComponent[]> topComponents;
    private int numStreams;
    private int topGauNum;
    private int gauNum;
    private long gauCalcSampleNumber;
    private Comparator<PrunableMixtureComponent> componentComparator = new Comparator<PrunableMixtureComponent>(){

        @Override
        public int compare(PrunableMixtureComponent a, PrunableMixtureComponent b) {
            return (int)(a.getStoredScore() - b.getStoredScore());
        }
    };

    public MixtureComponentSet(ArrayList<PrunableMixtureComponent[]> components, int topGauNum) {
        this.components = components;
        this.numStreams = components.size();
        this.topGauNum = topGauNum;
        this.gauNum = components.get(0).length;
        this.topComponents = new ArrayList();
        for (int i = 0; i < this.numStreams; ++i) {
            PrunableMixtureComponent[] featTopComponents = new PrunableMixtureComponent[topGauNum];
            for (int j = 0; j < topGauNum; ++j) {
                featTopComponents[j] = components.get(i)[j];
            }
            this.topComponents.add(featTopComponents);
        }
        this.gauCalcSampleNumber = -1L;
        this.toStoreScore = false;
        this.storedScores = new LinkedList();
        this.curScores = null;
    }

    private void storeScores(MixtureComponentSetScores scores) {
        this.storedScores.add(scores);
        while (this.storedScores.size() > this.scoresQueueLen) {
            this.storedScores.poll();
        }
    }

    private MixtureComponentSetScores getStoredScores(long frameFirstSample) {
        if (this.storedScores.isEmpty()) {
            return null;
        }
        if (this.storedScores.peekLast().getFrameStartSample() < frameFirstSample) {
            return null;
        }
        for (MixtureComponentSetScores scores : this.storedScores) {
            if (scores.getFrameStartSample() != frameFirstSample) continue;
            return scores;
        }
        return null;
    }

    private MixtureComponentSetScores createFromTopGau(long firstFrameSample) {
        MixtureComponentSetScores scores = new MixtureComponentSetScores(this.numStreams, this.topGauNum, firstFrameSample);
        for (int i = 0; i < this.numStreams; ++i) {
            for (int j = 0; j < this.topGauNum; ++j) {
                scores.setScore(i, j, this.topComponents.get(i)[j].getStoredScore());
                scores.setGauId(i, j, this.topComponents.get(i)[j].getId());
            }
        }
        return scores;
    }

    private void insertTopComponent(PrunableMixtureComponent[] topComponents, PrunableMixtureComponent component) {
        for (int i = 0; i < topComponents.length - 1; ++i) {
            if (component.getPartialScore() < topComponents[i].getPartialScore()) {
                topComponents[i - 1] = component;
                return;
            }
            topComponents[i] = topComponents[i + 1];
        }
        if (component.getPartialScore() < topComponents[topComponents.length - 1].getPartialScore()) {
            topComponents[topComponents.length - 2] = component;
        } else {
            topComponents[topComponents.length - 1] = component;
        }
    }

    private boolean isInTopComponents(PrunableMixtureComponent[] topComponents, PrunableMixtureComponent component) {
        for (PrunableMixtureComponent topComponent : topComponents) {
            if (topComponent.getId() != component.getId()) continue;
            return true;
        }
        return false;
    }

    private void updateTopScores(float[] featureVector) {
        int step = featureVector.length / this.numStreams;
        float[] streamVector = new float[step];
        for (int i = 0; i < this.numStreams; ++i) {
            System.arraycopy(featureVector, i * step, streamVector, 0, step);
            PrunableMixtureComponent[] featTopComponents = this.topComponents.get(i);
            PrunableMixtureComponent[] featComponents = this.components.get(i);
            for (PrunableMixtureComponent topComponent : featTopComponents) {
                topComponent.updateScore(streamVector);
            }
            Arrays.sort(featTopComponents, this.componentComparator);
            float threshold = featTopComponents[0].getPartialScore();
            for (PrunableMixtureComponent component : featComponents) {
                if (this.isInTopComponents(featTopComponents, component) || !component.isTopComponent(streamVector, threshold)) continue;
                this.insertTopComponent(featTopComponents, component);
                threshold = featTopComponents[0].getPartialScore();
            }
        }
    }

    public void updateTopScores(Data feature) {
        if (feature instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        long firstSampleNumber = FloatData.toFloatData(feature).getFirstSampleNumber();
        if (this.toStoreScore) {
            this.curScores = this.getStoredScores(firstSampleNumber);
        } else if (this.curScores != null && this.curScores.getFrameStartSample() != firstSampleNumber) {
            this.curScores = null;
        }
        if (this.curScores != null) {
            return;
        }
        float[] featureVector = FloatData.toFloatData(feature).getValues();
        this.updateTopScores(featureVector);
        this.curScores = this.createFromTopGau(firstSampleNumber);
        if (this.toStoreScore) {
            this.storeScores(this.curScores);
        }
    }

    private void updateScores(float[] featureVector) {
        int step = featureVector.length / this.numStreams;
        float[] streamVector = new float[step];
        for (int i = 0; i < this.numStreams; ++i) {
            System.arraycopy(featureVector, i * step, streamVector, 0, step);
            for (PrunableMixtureComponent component : this.components.get(i)) {
                component.updateScore(streamVector);
            }
        }
    }

    public void updateScores(Data feature) {
        long firstSampleNumber;
        if (feature instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        if (this.gauCalcSampleNumber != (firstSampleNumber = FloatData.toFloatData(feature).getFirstSampleNumber())) {
            float[] featureVector = FloatData.toFloatData(feature).getValues();
            this.updateScores(featureVector);
            this.gauCalcSampleNumber = firstSampleNumber;
        }
    }

    public void clearStoredScores() {
        this.storedScores.clear();
    }

    public void setScoreQueueLength(int scoresQueueLen) {
        this.toStoreScore = scoresQueueLen > 0;
        this.scoresQueueLen = scoresQueueLen;
    }

    public int getTopGauNum() {
        return this.topGauNum;
    }

    public int getGauNum() {
        return this.gauNum;
    }

    public float getTopGauScore(int streamId, int topGauId) {
        return this.curScores.getScore(streamId, topGauId);
    }

    public int getTopGauId(int streamId, int topGauId) {
        return this.curScores.getGauId(streamId, topGauId);
    }

    public float getGauScore(int streamId, int topGauId) {
        return this.components.get(streamId)[topGauId].getStoredScore();
    }

    public int getGauId(int streamId, int topGauId) {
        return this.components.get(streamId)[topGauId].getId();
    }

    private <T> T[] concatenate(T[] A, T[] B) {
        int aLen = A.length;
        int bLen = B.length;
        Object[] C = (Object[])Array.newInstance(A.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }

    protected MixtureComponent[] toArray() {
        MixtureComponent[] allComponents = new PrunableMixtureComponent[]{};
        for (int i = 0; i < this.numStreams; ++i) {
            this.concatenate(allComponents, (Object[])this.components.get(i));
        }
        return allComponents;
    }

    protected int dimension() {
        int dimension = 0;
        for (int i = 0; i < this.numStreams; ++i) {
            dimension += this.components.get(i)[0].getMean().length;
        }
        return dimension;
    }

    protected int size() {
        int size = 0;
        for (int i = 0; i < this.numStreams; ++i) {
            size += this.components.get(0).length;
        }
        return size;
    }
}

