/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.Utilities;
import java.util.ArrayList;

public class SenoneHMMState
implements HMMState {
    private final SenoneHMM hmm;
    private final int state;
    HMMStateArc[] arcs;
    private final boolean isEmitting;
    private Senone senone;
    private final int hashCode;
    private static int objectCount;

    SenoneHMMState(SenoneHMM hmm, int which) {
        this.hmm = hmm;
        this.state = which;
        boolean bl = this.isEmitting = hmm.getTransitionMatrix().length - 1 != this.state;
        if (this.isEmitting) {
            SenoneSequence ss = hmm.getSenoneSequence();
            this.senone = ss.getSenones()[this.state];
        }
        Utilities.objectTracker("HMMState", objectCount++);
        this.hashCode = hmm.hashCode() + 37 * this.state;
    }

    @Override
    public HMM getHMM() {
        return this.hmm;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public float getScore(Data feature) {
        return this.senone.getScore(feature);
    }

    @Override
    public float[] calculateComponentScore(Data feature) {
        this.hmm.getSenoneSequence();
        return this.senone.calculateComponentScore(feature);
    }

    public Senone getSenone() {
        return this.senone;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SenoneHMMState)) {
            return false;
        }
        SenoneHMMState otherState = (SenoneHMMState)other;
        return this.hmm == otherState.hmm && this.state == otherState.state;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public final boolean isEmitting() {
        return this.isEmitting;
    }

    @Override
    public HMMStateArc[] getSuccessors() {
        if (this.arcs == null) {
            ArrayList<HMMStateArc> list = new ArrayList<HMMStateArc>();
            float[][] transitionMatrix = this.hmm.getTransitionMatrix();
            for (int i = 0; i < transitionMatrix.length; ++i) {
                if (!(transitionMatrix[this.state][i] > -3.4028235E38f)) continue;
                HMMStateArc arc = new HMMStateArc(this.hmm.getState(i), transitionMatrix[this.state][i]);
                list.add(arc);
            }
            this.arcs = list.toArray(new HMMStateArc[list.size()]);
        }
        return this.arcs;
    }

    @Override
    public boolean isExitState() {
        return !this.isEmitting;
    }

    public String toString() {
        return "HMMS " + this.hmm + " state " + this.state;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return this.senone.getMixtureComponents();
    }

    @Override
    public long getMixtureId() {
        return this.senone.getID();
    }

    @Override
    public float[] getLogMixtureWeights() {
        return this.senone.getLogMixtureWeights();
    }
}

