/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.LogMath;
import java.io.Serializable;
import java.util.Arrays;

public class MixtureComponent
implements Cloneable,
Serializable {
    private float[] mean;
    protected float[] meanTransformed;
    private float[][] meanTransformationMatrix;
    private float[] meanTransformationVector;
    private float[] variance;
    protected float[] precisionTransformed;
    private float[][] varianceTransformationMatrix;
    private float[] varianceTransformationVector;
    protected float distFloor;
    private float varianceFloor;
    public static final float DEFAULT_VAR_FLOOR = 1.0E-4f;
    public static final float DEFAULT_DIST_FLOOR = 0.0f;
    protected float logPreComputedGaussianFactor;
    protected LogMath logMath;

    public MixtureComponent(float[] mean, float[] variance) {
        this(mean, null, null, variance, null, null, 0.0f, 1.0E-4f);
    }

    public MixtureComponent(float[] mean, float[][] meanTransformationMatrix, float[] meanTransformationVector, float[] variance, float[][] varianceTransformationMatrix, float[] varianceTransformationVector) {
        this(mean, meanTransformationMatrix, meanTransformationVector, variance, varianceTransformationMatrix, varianceTransformationVector, 0.0f, 1.0E-4f);
    }

    public MixtureComponent(float[] mean, float[][] meanTransformationMatrix, float[] meanTransformationVector, float[] variance, float[][] varianceTransformationMatrix, float[] varianceTransformationVector, float distFloor, float varianceFloor) {
        assert (variance.length == mean.length);
        this.logMath = LogMath.getLogMath();
        this.mean = mean;
        this.meanTransformationMatrix = meanTransformationMatrix;
        this.meanTransformationVector = meanTransformationVector;
        this.variance = variance;
        this.varianceTransformationMatrix = varianceTransformationMatrix;
        this.varianceTransformationVector = varianceTransformationVector;
        assert ((double)distFloor >= 0.0) : "distFloot seems to be already in log-domain";
        this.distFloor = this.logMath.linearToLog(distFloor);
        this.varianceFloor = varianceFloor;
        this.transformStats();
        this.logPreComputedGaussianFactor = this.precomputeDistance();
    }

    public float[] getMean() {
        return this.mean;
    }

    public float[] getVariance() {
        return this.variance;
    }

    public float getScore(FloatData feature) {
        return this.getScore(feature.getValues());
    }

    public float getScore(float[] feature) {
        float logDval = this.logPreComputedGaussianFactor;
        for (int i = 0; i < feature.length; ++i) {
            float logDiff = feature[i] - this.meanTransformed[i];
            logDval += logDiff * logDiff * this.precisionTransformed[i];
        }
        if (Float.isNaN(logDval = this.logMath.lnToLog(logDval))) {
            System.out.println("gs is Nan, converting to 0");
            logDval = -3.4028235E38f;
        }
        if (logDval < this.distFloor) {
            logDval = this.distFloor;
        }
        return logDval;
    }

    public float precomputeDistance() {
        double logPreComputedGaussianFactor = 0.0;
        for (int i = 0; i < this.variance.length; ++i) {
            logPreComputedGaussianFactor += Math.log(this.precisionTransformed[i] * -2.0f);
        }
        logPreComputedGaussianFactor = Math.log(Math.PI * 2) * (double)this.variance.length - logPreComputedGaussianFactor;
        return -((float)logPreComputedGaussianFactor) * 0.5f;
    }

    public void transformStats() {
        int k;
        int j;
        int i;
        int featDim = this.mean.length;
        if (this.meanTransformationMatrix != null) {
            this.meanTransformed = new float[featDim];
            for (i = 0; i < featDim; ++i) {
                for (j = 0; j < featDim; ++j) {
                    int n = i;
                    this.meanTransformed[n] = this.meanTransformed[n] + this.mean[j] * this.meanTransformationMatrix[i][j];
                }
            }
        } else {
            this.meanTransformed = this.mean;
        }
        if (this.meanTransformationVector != null) {
            for (k = 0; k < featDim; ++k) {
                int n = k;
                this.meanTransformed[n] = this.meanTransformed[n] + this.meanTransformationVector[k];
            }
        }
        if (this.varianceTransformationMatrix != null) {
            this.precisionTransformed = new float[this.variance.length];
            for (i = 0; i < featDim; ++i) {
                for (j = 0; j < featDim; ++j) {
                    int n = i;
                    this.precisionTransformed[n] = this.precisionTransformed[n] + this.variance[j] * this.varianceTransformationMatrix[i][j];
                }
            }
        } else {
            this.precisionTransformed = (float[])this.variance.clone();
        }
        if (this.varianceTransformationVector != null) {
            for (k = 0; k < featDim; ++k) {
                int n = k;
                this.precisionTransformed[n] = this.precisionTransformed[n] + this.varianceTransformationVector[k];
            }
        }
        for (k = 0; k < featDim; ++k) {
            float flooredPrecision = this.precisionTransformed[k] < this.varianceFloor ? this.varianceFloor : this.precisionTransformed[k];
            this.precisionTransformed[k] = 1.0f / (-2.0f * flooredPrecision);
        }
    }

    public MixtureComponent clone() throws CloneNotSupportedException {
        int i;
        MixtureComponent mixComp = (MixtureComponent)super.clone();
        mixComp.distFloor = this.distFloor;
        mixComp.varianceFloor = this.varianceFloor;
        mixComp.logPreComputedGaussianFactor = this.logPreComputedGaussianFactor;
        float[] fArray = mixComp.mean = this.mean != null ? (float[])this.mean.clone() : null;
        if (this.meanTransformationMatrix != null) {
            mixComp.meanTransformationMatrix = (float[][])this.meanTransformationMatrix.clone();
            for (i = 0; i < this.meanTransformationMatrix.length; ++i) {
                mixComp.meanTransformationMatrix[i] = (float[])this.meanTransformationMatrix[i].clone();
            }
        }
        mixComp.meanTransformationVector = this.meanTransformationVector != null ? (float[])this.meanTransformationVector.clone() : null;
        mixComp.meanTransformed = this.meanTransformed != null ? (float[])this.meanTransformed.clone() : null;
        float[] fArray2 = mixComp.variance = this.variance != null ? (float[])this.variance.clone() : null;
        if (this.varianceTransformationMatrix != null) {
            mixComp.varianceTransformationMatrix = (float[][])this.varianceTransformationMatrix.clone();
            for (i = 0; i < this.varianceTransformationMatrix.length; ++i) {
                mixComp.varianceTransformationMatrix[i] = (float[])this.varianceTransformationMatrix[i].clone();
            }
        }
        mixComp.varianceTransformationVector = this.varianceTransformationVector != null ? (float[])this.varianceTransformationVector.clone() : null;
        mixComp.precisionTransformed = this.precisionTransformed != null ? (float[])this.precisionTransformed.clone() : null;
        return mixComp;
    }

    public String toString() {
        return "mu=" + Arrays.toString(this.mean) + " cov=" + Arrays.toString(this.variance);
    }
}

