/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.GMMDiag;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMSet;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.SingleHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTKLoader
implements Loader {
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Boolean(defaultValue=true)
    public static final String PROP_IS_BINARY = "isBinary";
    @S4String(mandatory=true, defaultValue="hmmdefs")
    public static final String PROP_MODEL = "modelDefinition";
    @S4Boolean(defaultValue=true)
    public static final String PROP_TIE_1PH = "tie1ph";
    @S4String(defaultValue="model.props")
    public static final String PROP_PROPERTIES_FILE = "propertiesFile";
    @S4Integer(defaultValue=39)
    public static final String PROP_VECTOR_LENGTH = "vectorLength";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    protected static final String FILLER = "filler";
    protected static final String SILENCE_CIPHONE = "SIL";
    protected static final int BYTE_ORDER_MAGIC = 287454020;
    public static final String MODEL_VERSION = "0.3";
    protected static final int CONTEXT_SIZE = 1;
    private Pool<float[]> meansPool;
    private Pool<float[]> variancePool;
    private Pool<float[][]> matrixPool;
    private Pool<float[][]> meanTransformationMatrixPool;
    private Pool<float[]> meanTransformationVectorPool;
    private Pool<float[][]> varianceTransformationMatrixPool;
    private Pool<float[]> varianceTransformationVectorPool;
    private GaussianWeights mixtureWeights;
    private Pool<Senone> senonePool;
    private Map<String, Unit> contextIndependentUnits;
    private HMMManager hmmManager;
    private LogMath logMath;
    private UnitManager unitManager;
    private Properties properties;
    private boolean swap;
    protected static final String DENSITY_FILE_VERSION = "1.0";
    protected static final String MIXW_FILE_VERSION = "1.0";
    protected static final String TMAT_FILE_VERSION = "1.0";
    private String name;
    private Logger logger;
    private String location;
    private String model;
    private String dataDir;
    private String propsFile;
    private float distFloor;
    private float mixtureWeightFloor;
    private float varianceFloor;
    private boolean useCDUnits;
    private boolean loaded;
    private boolean tie1ph;

    public HTKLoader(String propsFile, UnitManager unitManager, boolean isBinary, int vectorLength, String model, boolean tie1ph, float distFloor, float mixtureWeightFloor, float varianceFloor) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.propsFile = propsFile;
        this.loadProperties();
        this.logMath = LogMath.getLogMath();
        this.unitManager = unitManager;
        this.model = model;
        this.tie1ph = tie1ph;
        this.distFloor = distFloor;
        this.mixtureWeightFloor = mixtureWeightFloor;
        this.varianceFloor = varianceFloor;
    }

    public HTKLoader() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.propsFile = ps.getString(PROP_PROPERTIES_FILE);
        this.loadProperties();
        this.unitManager = (UnitManager)ps.getComponent(PROP_UNIT_MANAGER);
        String mdef = (String)this.properties.get(PROP_MODEL);
        this.model = mdef != null ? mdef : ps.getString(PROP_MODEL);
        this.tie1ph = ps.getBoolean(PROP_TIE_1PH);
        this.distFloor = ps.getFloat(PROP_MC_FLOOR);
        this.mixtureWeightFloor = ps.getFloat(PROP_MW_FLOOR);
        this.varianceFloor = ps.getFloat(PROP_VARIANCE_FLOOR);
    }

    private void loadProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                URL url = this.getClass().getResource(this.propsFile);
                if (url != null) {
                    this.properties.load(url.openStream());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public void load() throws IOException {
        if (!this.loaded) {
            this.hmmManager = new HMMManager();
            this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
            this.meanTransformationMatrixPool = null;
            this.meanTransformationVectorPool = null;
            this.varianceTransformationMatrixPool = null;
            this.varianceTransformationVectorPool = null;
            this.loadModelFiles(this.model);
            System.err.println("HTK -> S4 conversion finished");
            this.loaded = true;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    protected String getLocation() {
        return this.location;
    }

    private void loadModelFiles(String MMFname) throws IOException {
        this.logger.config("Loading HTK acoustic model: " + MMFname);
        this.logger.config("    Path      : " + this.location);
        this.logger.config("    modellName: " + this.model);
        this.logger.config("    dataDir   : " + this.dataDir);
        HTKStruct htkmods = new HTKStruct();
        htkmods.load(MMFname);
        this.meansPool = htkmods.htkMeans(MMFname);
        this.variancePool = htkmods.htkVars(MMFname, this.varianceFloor);
        this.mixtureWeights = htkmods.htkWeights(MMFname, this.mixtureWeightFloor);
        this.matrixPool = htkmods.htkTrans(MMFname);
        this.senonePool = this.createSenonePool(this.distFloor, this.varianceFloor);
        this.loadHMMPool(this.useCDUnits, htkmods, this.location + File.separator + this.model);
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private Pool<Senone> createSenonePool(float distFloor, float varianceFloor) {
        Pool<Senone> pool = new Pool<Senone>("senones");
        int numMeans = this.meansPool.size();
        int numVariances = this.variancePool.size();
        int numGaussiansPerSenone = this.mixtureWeights.getGauPerState();
        int numSenones = this.mixtureWeights.getStatesNum();
        int whichGaussian = 0;
        this.logger.fine("NG " + numGaussiansPerSenone);
        this.logger.fine("NS " + numSenones);
        this.logger.fine("NMNS " + numMeans);
        this.logger.fine("NMNS " + numVariances);
        assert (numGaussiansPerSenone > 0);
        assert (numVariances == numSenones * numGaussiansPerSenone);
        assert (numMeans == numSenones * numGaussiansPerSenone);
        float[][] meansTransformationMatrix = this.meanTransformationMatrixPool == null ? (float[][])null : this.meanTransformationMatrixPool.get(0);
        float[] meansTransformationVector = this.meanTransformationVectorPool == null ? null : this.meanTransformationVectorPool.get(0);
        float[][] varianceTransformationMatrix = this.varianceTransformationMatrixPool == null ? (float[][])null : this.varianceTransformationMatrixPool.get(0);
        float[] varianceTransformationVector = this.varianceTransformationVectorPool == null ? null : this.varianceTransformationVectorPool.get(0);
        for (int i = 0; i < numSenones; ++i) {
            MixtureComponent[] mixtureComponents = new MixtureComponent[numGaussiansPerSenone];
            for (int j = 0; j < numGaussiansPerSenone; ++j) {
                mixtureComponents[j] = new MixtureComponent(this.meansPool.get(whichGaussian), meansTransformationMatrix, meansTransformationVector, this.variancePool.get(whichGaussian), varianceTransformationMatrix, varianceTransformationVector, distFloor, varianceFloor);
                ++whichGaussian;
            }
            GaussianMixture senone = new GaussianMixture(this.mixtureWeights, mixtureComponents, i);
            pool.put(i, senone);
        }
        return pool;
    }

    String readWord(DataInputStream dis) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (Character.isWhitespace(c = this.readChar(dis))) {
        }
        do {
            sb.append(c);
        } while (!Character.isWhitespace(c = this.readChar(dis)));
        return sb.toString();
    }

    private char readChar(DataInputStream dis) throws IOException {
        return (char)dis.readByte();
    }

    protected int readInt(DataInputStream dis) throws IOException {
        if (this.swap) {
            return Utilities.readLittleEndianInt(dis);
        }
        return dis.readInt();
    }

    protected float readFloat(DataInputStream dis) throws IOException {
        float val = this.swap ? Utilities.readLittleEndianFloat(dis) : dis.readFloat();
        return val;
    }

    protected float[] readFloatArray(DataInputStream dis, int size) throws IOException {
        float[] data = new float[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readFloat(dis);
        }
        return data;
    }

    protected void loadHMMPool(boolean useCDUnits, HTKStruct htkModels, String path) throws IOException {
        SingleHMM hmm;
        SenoneHMM hmm2;
        SenoneSequence ss;
        float[][] transitionMatrix;
        Unit unit;
        HMMState s;
        int j;
        int[] stid;
        int numStatePerHMM;
        int tmat;
        String attribute;
        String name;
        SingleHMM hmm3;
        if (!this.tie1ph) {
            Iterator<SingleHMM> monoPhones = htkModels.hmmsHTK.get1phIt();
            while (monoPhones.hasNext() && (hmm3 = monoPhones.next()) != null) {
                name = hmm3.getName();
                attribute = name.equals("sil") || name.equals("sp") || name.equals("bb") || name.equals("xx") || name.equals("hh") ? FILLER : "nofiller";
                tmat = hmm3.trIdx;
                numStatePerHMM = hmm3.getNstates();
                stid = new int[hmm3.getNbEmittingStates()];
                j = 0;
                for (int ii = 0; ii < numStatePerHMM; ++ii) {
                    if (!hmm3.isEmitting(ii)) continue;
                    s = hmm3.getState(ii);
                    stid[j] = htkModels.hmmsHTK.getStateIdx(s);
                    ++j;
                }
                unit = this.unitManager.getUnit(name, attribute.equals(FILLER));
                this.contextIndependentUnits.put(unit.getName(), unit);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Loaded " + unit);
                }
                if (unit.isFiller() && unit.getName().equals(SILENCE_CIPHONE)) {
                    unit = UnitManager.SILENCE;
                }
                transitionMatrix = this.matrixPool.get(tmat);
                ss = this.getSenoneSequence(stid);
                hmm2 = new SenoneHMM(unit, ss, transitionMatrix, HMMPosition.lookup("-"));
                this.hmmManager.put(hmm2);
            }
        } else {
            for (int i = 0; i < htkModels.hmmsHTK.getNhmms() && (hmm3 = htkModels.hmmsHTK.getHMM(i)) != null; ++i) {
                name = hmm3.getBaseName();
                if (this.contextIndependentUnits.containsKey(name)) continue;
                attribute = name.equals(SILENCE_CIPHONE) || name.equals("SP") || name.equals("BB") || name.equals("XX") || name.equals("HH") ? FILLER : "nofiller";
                tmat = hmm3.trIdx;
                numStatePerHMM = hmm3.getNstates();
                stid = new int[hmm3.getNbEmittingStates()];
                j = 0;
                for (int ii = 0; ii < numStatePerHMM; ++ii) {
                    if (!hmm3.isEmitting(ii)) continue;
                    s = hmm3.getState(ii);
                    stid[j] = htkModels.hmmsHTK.getStateIdx(s);
                    ++j;
                }
                unit = this.unitManager.getUnit(name, attribute.equals(FILLER));
                this.contextIndependentUnits.put(unit.getName(), unit);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Loaded " + unit);
                }
                if (unit.isFiller() && unit.getName().equals(SILENCE_CIPHONE)) {
                    unit = UnitManager.SILENCE;
                }
                transitionMatrix = this.matrixPool.get(tmat);
                ss = this.getSenoneSequence(stid);
                hmm2 = new SenoneHMM(unit, ss, transitionMatrix, HMMPosition.lookup("-"));
                this.hmmManager.put(hmm2);
            }
        }
        String lastUnitName = "";
        Unit lastUnit = null;
        int[] lastStid = null;
        SenoneSequence lastSenoneSequence = null;
        ArrayList<String> HMMdejavu = new ArrayList<String>();
        Iterator<SingleHMM> triPhones = htkModels.hmmsHTK.get3phIt();
        while (triPhones.hasNext() && (hmm = triPhones.next()) != null) {
            Unit unit2;
            String s2;
            String name2 = hmm.getBaseName();
            String left = hmm.getLeft();
            String right = hmm.getRight();
            if (left.equals("-")) {
                left = SILENCE_CIPHONE;
            }
            if (right.equals("-")) {
                right = SILENCE_CIPHONE;
            }
            if (HMMdejavu.contains(s2 = left + ' ' + name2 + ' ' + right)) continue;
            HMMdejavu.add(s2);
            String position = "i";
            int tmat2 = hmm.trIdx;
            numStatePerHMM = hmm.getNstates();
            int[] stid2 = new int[hmm.getNbEmittingStates()];
            int j2 = 0;
            for (int ii = 0; ii < numStatePerHMM; ++ii) {
                if (!hmm.isEmitting(ii)) continue;
                HMMState s3 = hmm.getState(ii);
                stid2[j2] = htkModels.hmmsHTK.getStateIdx(s3);
                ++j2;
            }
            if (!useCDUnits) continue;
            String unitName = name2 + ' ' + left + ' ' + right;
            if (unitName.equals(lastUnitName)) {
                unit2 = lastUnit;
            } else {
                Unit[] leftContext = new Unit[]{this.contextIndependentUnits.get(left)};
                Unit[] rightContext = new Unit[]{this.contextIndependentUnits.get(right)};
                LeftRightContext context = LeftRightContext.get(leftContext, rightContext);
                unit2 = this.unitManager.getUnit(name2, false, context);
            }
            lastUnitName = unitName;
            lastUnit = unit2;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + unit2);
            }
            float[][] transitionMatrix2 = this.matrixPool.get(tmat2);
            SenoneSequence ss2 = lastSenoneSequence;
            if (ss2 == null || !this.sameSenoneSequence(stid2, lastStid)) {
                ss2 = this.getSenoneSequence(stid2);
            }
            lastSenoneSequence = ss2;
            lastStid = stid2;
            SenoneHMM hmm22 = new SenoneHMM(unit2, ss2, transitionMatrix2, HMMPosition.lookup(position));
            this.hmmManager.put(hmm22);
        }
    }

    protected boolean sameSenoneSequence(int[] ssid1, int[] ssid2) {
        if (ssid1.length == ssid2.length) {
            for (int i = 0; i < ssid1.length; ++i) {
                if (ssid1[i] == ssid2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected SenoneSequence getSenoneSequence(int[] stateId) {
        Senone[] senones = new Senone[stateId.length];
        for (int i = 0; i < stateId.length; ++i) {
            senones[i] = this.senonePool.get(stateId[i]);
        }
        return new SenoneSequence(senones);
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return this.mixtureWeights;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return this.matrixPool;
    }

    @Override
    public float[][] getTransformMatrix() {
        return null;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("HTKLoader");
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.matrixPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        if (this.meanTransformationMatrixPool != null) {
            this.meanTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.meanTransformationVectorPool != null) {
            this.meanTransformationVectorPool.logInfo(this.logger);
        }
        if (this.varianceTransformationMatrixPool != null) {
            this.varianceTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.varianceTransformationVectorPool != null) {
            this.varianceTransformationVectorPool.logInfo(this.logger);
        }
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusters) {
    }

    class HTKStruct {
        HMMSet hmmsHTK;

        HTKStruct() {
        }

        public void load(String name) {
            System.err.println("HTK loading...");
            this.hmmsHTK = new HMMSet();
            this.hmmsHTK.loadHTK(name);
            System.err.println("HTK loading finished");
        }

        int getNumStates() {
            return this.hmmsHTK.getNstates();
        }

        int getGMMSize() {
            GMMDiag gmm = this.hmmsHTK.gmms.get(0);
            return gmm.getNgauss();
        }

        int getNcoefs() {
            GMMDiag gmm = this.hmmsHTK.gmms.get(0);
            return gmm.getNcoefs();
        }

        int getNumHMMs() {
            return this.hmmsHTK.getNhmms();
        }

        public Pool<float[]> htkMeans(String path) {
            Pool<float[]> pool = new Pool<float[]>(path);
            int numStates = this.getNumStates();
            int numStreams = 1;
            int numGaussiansPerState = this.getGMMSize();
            pool.setFeature(Pool.Feature.NUM_SENONES, numStates);
            pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
            pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
            int ncoefs = this.getNcoefs();
            for (int i = 0; i < numStates; ++i) {
                GMMDiag gmm = this.hmmsHTK.gmms.get(i);
                for (int j = 0; j < numGaussiansPerState; ++j) {
                    float[] density = new float[ncoefs];
                    for (int k = 0; k < ncoefs; ++k) {
                        density[k] = gmm.getMean(j, k);
                    }
                    int id = i * numGaussiansPerState + j;
                    pool.put(id, density);
                }
            }
            return pool;
        }

        public Pool<float[]> htkVars(String path, float floor) {
            Pool<float[]> pool = new Pool<float[]>(path);
            int numStates = this.getNumStates();
            int numStreams = 1;
            int numGaussiansPerState = this.getGMMSize();
            pool.setFeature(Pool.Feature.NUM_SENONES, numStates);
            pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
            pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
            int ncoefs = this.getNcoefs();
            for (int i = 0; i < numStates; ++i) {
                GMMDiag gmm = this.hmmsHTK.gmms.get(i);
                for (int j = 0; j < numGaussiansPerState; ++j) {
                    float[] vars = new float[ncoefs];
                    for (int k = 0; k < ncoefs; ++k) {
                        vars[k] = gmm.getVar(j, k);
                    }
                    Utilities.floorData(vars, HTKLoader.this.varianceFloor);
                    int id = i * numGaussiansPerState + j;
                    pool.put(id, vars);
                }
            }
            return pool;
        }

        public GaussianWeights htkWeights(String path, float floor) {
            int numStates = this.getNumStates();
            int numStreams = 1;
            int numGaussiansPerState = this.getGMMSize();
            GaussianWeights mixtureWeights = new GaussianWeights(path, numStates, numGaussiansPerState, numStreams);
            for (int i = 0; i < numStates; ++i) {
                GMMDiag gmm = this.hmmsHTK.gmms.get(i);
                float[] logWeights = new float[numGaussiansPerState];
                for (int j = 0; j < numGaussiansPerState; ++j) {
                    logWeights[j] = gmm.getWeight(j);
                }
                Utilities.floorData(logWeights, HTKLoader.this.mixtureWeightFloor);
                HTKLoader.this.logMath.linearToLog(logWeights);
                mixtureWeights.put(i, 0, logWeights);
            }
            return mixtureWeights;
        }

        public Pool<float[][]> htkTrans(String path) {
            int i;
            Pool<float[][]> pool = new Pool<float[][]>(path);
            int numMatrices = this.getNumHMMs();
            if (this.hmmsHTK.transitions != null) {
                for (i = 0; i < this.hmmsHTK.transitions.size(); ++i) {
                    float[][] tr = this.hmmsHTK.transitions.get(i);
                    float[][] tmat = new float[tr.length][tr[0].length];
                    for (int j = 0; j < tmat.length; ++j) {
                        for (int k = 0; k < tmat[j].length; ++k) {
                            tmat[j][k] = HTKLoader.this.logMath.linearToLog(tr[j][k]);
                        }
                    }
                    pool.put(i, tmat);
                }
            }
            for (int l = 0; l < numMatrices; ++l) {
                SingleHMM hmm = this.hmmsHTK.getHMM(l);
                if (hmm.trans != null) {
                    float[][] tr = hmm.trans;
                    float[][] tmat = new float[tr.length][tr[0].length];
                    for (int j = 0; j < tmat.length; ++j) {
                        for (int k = 0; k < tmat[j].length; ++k) {
                            tmat[j][k] = HTKLoader.this.logMath.linearToLog(tr[j][k]);
                        }
                    }
                    hmm.trIdx = i;
                    pool.put(i++, tmat);
                    continue;
                }
                hmm.trIdx = hmm.getTransIdx();
            }
            return pool;
        }
    }
}

