/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class HMMManager
implements Iterable<HMM> {
    private final List<HMM> allHMMs = new ArrayList<HMM>();
    private final Map<HMMPosition, Map<Unit, HMM>> hmmsPerPosition = new EnumMap<HMMPosition, Map<Unit, HMM>>(HMMPosition.class);

    public HMMManager() {
        for (HMMPosition pos : HMMPosition.values()) {
            this.hmmsPerPosition.put(pos, new HashMap());
        }
    }

    public void put(HMM hmm) {
        this.hmmsPerPosition.get((Object)hmm.getPosition()).put(hmm.getUnit(), hmm);
        this.allHMMs.add(hmm);
    }

    public HMM get(HMMPosition position, Unit unit) {
        return this.hmmsPerPosition.get((Object)position).get(unit);
    }

    @Override
    public Iterator<HMM> iterator() {
        return this.allHMMs.iterator();
    }

    private int getNumHMMs() {
        int count = 0;
        for (Map<Unit, HMM> map : this.hmmsPerPosition.values()) {
            if (map == null) continue;
            count += map.size();
        }
        return count;
    }

    public void logInfo(Logger logger) {
        logger.info("HMM Manager: " + this.getNumHMMs() + " hmms");
    }
}

