/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.GrXMLHandler;
import edu.cmu.sphinx.jsgf.JSGFGrammar;
import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class GrXMLGrammar
extends JSGFGrammar {
    Map<String, JSGFRule> rules;

    protected void loadXML() throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader xr = factory.newSAXParser().getXMLReader();
            this.rules = new HashMap<String, JSGFRule>();
            GrXMLHandler handler = new GrXMLHandler(this.baseURL, this.rules, this.logger);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            InputStream is = this.baseURL.openStream();
            xr.parse(new InputSource(is));
            is.close();
        }
        catch (SAXParseException e) {
            String msg = "Error while parsing line " + e.getLineNumber() + " of " + this.baseURL + ": " + e.getMessage();
            throw new IOException(msg);
        }
        catch (SAXException e) {
            throw new IOException("Problem with XML: " + e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void commitChanges() throws IOException, JSGFGrammarParseException, JSGFGrammarException {
        try {
            if (this.loadGrammar) {
                if (this.manager == null) {
                    this.getGrammarManager();
                }
                this.loadXML();
                this.loadGrammar = false;
            }
            this.ruleStack = new JSGFGrammar.RuleStack(this);
            this.newGrammar();
            this.firstNode = this.createGrammarNode("<sil>");
            GrammarNode finalNode = this.createGrammarNode("<sil>");
            finalNode.setFinalNode(true);
            for (Map.Entry<String, JSGFRule> entry : this.rules.entrySet()) {
                JSGFGrammar.GrammarGraph publicRuleGraph = new JSGFGrammar.GrammarGraph(this);
                this.ruleStack.push(entry.getKey(), publicRuleGraph);
                JSGFGrammar.GrammarGraph graph = this.processRule(entry.getValue());
                this.ruleStack.pop();
                this.firstNode.add(publicRuleGraph.getStartNode(), 0.0f);
                publicRuleGraph.getEndNode().add(finalNode, 0.0f);
                publicRuleGraph.getStartNode().add(graph.getStartNode(), 0.0f);
                graph.getEndNode().add(publicRuleGraph.getEndNode(), 0.0f);
            }
            this.postProcessGrammar();
        }
        catch (MalformedURLException mue) {
            throw new IOException("bad base grammar URL " + this.baseURL + ' ' + mue);
        }
    }
}

