/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.instrumentation.AccuracyTracker;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;

public class BestPathAccuracyTracker
extends AccuracyTracker {
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_FULL_PATH = "showFullPath";
    private boolean showFullPath;

    public BestPathAccuracyTracker(Recognizer recognizer, boolean showSummary, boolean showDetails, boolean showResults, boolean showAlignedResults, boolean showRawResults, boolean showFullPath) {
        super(recognizer, showSummary, showDetails, showResults, showAlignedResults, showRawResults);
        this.showFullPath = showFullPath;
    }

    public BestPathAccuracyTracker() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.showFullPath = ps.getBoolean(PROP_SHOW_FULL_PATH);
    }

    private void showFullPath(Result result) {
        if (this.showFullPath) {
            System.out.println();
            Token bestToken = result.getBestToken();
            if (bestToken != null) {
                bestToken.dumpTokenPath();
            } else {
                System.out.println("Null result");
            }
            System.out.println();
        }
    }

    @Override
    public void newResult(Result result) {
        String ref = result.getReferenceText();
        if (result.isFinal() && ref != null) {
            String hyp = result.getBestResultNoFiller();
            this.getAligner().align(ref, hyp);
            this.showFullPath(result);
            this.showDetails(result.toString());
        }
    }
}

