/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.util.ArrayList;

public class ExtendFinal {
    private ExtendFinal() {
    }

    public static void apply(Fst fst) {
        Semiring semiring = fst.getSemiring();
        ArrayList<State> fStates = new ArrayList<State>();
        int numStates = fst.getNumStates();
        for (int i = 0; i < numStates; ++i) {
            State s = fst.getState(i);
            if (s.getFinalWeight() == semiring.zero()) continue;
            fStates.add(s);
        }
        State newFinal = new State(semiring.one());
        fst.addState(newFinal);
        for (State s : fStates) {
            s.addArc(new Arc(0, 0, s.getFinalWeight(), newFinal));
            s.setFinalWeight(semiring.zero());
        }
    }

    public static void undo(Fst fst) {
        State s;
        int i;
        State f = null;
        int numStates = fst.getNumStates();
        for (i = 0; i < numStates; ++i) {
            s = fst.getState(i);
            if (s.getFinalWeight() == fst.getSemiring().zero()) continue;
            f = s;
            break;
        }
        if (f == null) {
            System.err.println("Final state not found.");
            return;
        }
        for (i = 0; i < numStates; ++i) {
            s = fst.getState(i);
            for (int j = 0; j < s.getNumArcs(); ++j) {
                Arc a = s.getArc(j);
                if (a.getIlabel() != 0 || a.getOlabel() != 0 || a.getNextState().getId() != f.getId()) continue;
                s.setFinalWeight(a.getWeight());
            }
        }
        fst.deleteState(f);
    }
}

