/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Determinize {
    private Determinize() {
    }

    private static Pair<State, Float> getPair(ArrayList<Pair<State, Float>> queue, State state, Float zero) {
        Pair<State, Float> res = null;
        for (Pair<State, Float> tmp : queue) {
            if (state.getId() != tmp.getLeft().getId()) continue;
            res = tmp;
            break;
        }
        if (res == null) {
            res = new Pair<State, Float>(state, zero);
            queue.add(res);
        }
        return res;
    }

    private static ArrayList<Integer> getUniqueLabels(Fst fst, ArrayList<Pair<State, Float>> pa) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (Pair<State, Float> p : pa) {
            State s = p.getLeft();
            int numArcs = s.getNumArcs();
            for (int j = 0; j < numArcs; ++j) {
                Arc arc = s.getArc(j);
                if (res.contains(arc.getIlabel())) continue;
                res.add(arc.getIlabel());
            }
        }
        return res;
    }

    private static State getStateLabel(ArrayList<Pair<State, Float>> pa, HashMap<String, State> stateMapper) {
        StringBuilder sb = new StringBuilder();
        for (Pair<State, Float> p : pa) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("(" + p.getLeft() + "," + p.getRight() + ")");
        }
        return stateMapper.get(sb.toString());
    }

    /*
     * Could not resolve type clashes
     */
    public static Fst get(Fst fst) {
        if (fst.getSemiring() == null) {
            return null;
        }
        Semiring semiring = fst.getSemiring();
        Fst res = new Fst(semiring);
        res.setIsyms(fst.getIsyms());
        res.setOsyms(fst.getOsyms());
        LinkedList queue = new LinkedList();
        HashMap<String, State> stateMapper = new HashMap<String, State>();
        State s = new State(semiring.zero());
        String stateString = "(" + fst.getStart() + "," + semiring.one() + ")";
        queue.add(new ArrayList());
        ((ArrayList)queue.peek()).add(new Pair<State, Float>(fst.getStart(), Float.valueOf(semiring.one())));
        res.addState(s);
        stateMapper.put(stateString, s);
        res.setStart(s);
        while (!queue.isEmpty()) {
            ArrayList p = (ArrayList)queue.remove();
            State pnew = Determinize.getStateLabel(p, stateMapper);
            queue.remove((Object)0);
            ArrayList<Integer> labels = Determinize.getUniqueLabels(fst, p);
            for (int label : labels) {
                Float wnew = Float.valueOf(semiring.zero());
                for (Pair ps : p) {
                    State old = (State)ps.getLeft();
                    Float u = (Float)ps.getRight();
                    int numArcs = old.getNumArcs();
                    for (int j = 0; j < numArcs; ++j) {
                        Arc arc = old.getArc(j);
                        if (label != arc.getIlabel()) continue;
                        wnew = Float.valueOf(semiring.plus(wnew.floatValue(), semiring.times(u.floatValue(), arc.getWeight())));
                    }
                }
                ArrayList<Pair<State, Float>> forQueue = new ArrayList<Pair<State, Float>>();
                for (Pair ps : p) {
                    State old = (State)ps.getLeft();
                    Float u = (Float)ps.getRight();
                    Float wnewRevert = Float.valueOf(semiring.divide(semiring.one(), wnew.floatValue()));
                    int numArcs = old.getNumArcs();
                    for (int j = 0; j < numArcs; ++j) {
                        Arc arc = old.getArc(j);
                        if (label != arc.getIlabel()) continue;
                        State oldstate = arc.getNextState();
                        Pair<State, Float> pair = Determinize.getPair(forQueue, oldstate, Float.valueOf(semiring.zero()));
                        pair.setRight(Float.valueOf(semiring.plus(pair.getRight().floatValue(), semiring.times(wnewRevert.floatValue(), semiring.times(u.floatValue(), arc.getWeight())))));
                    }
                }
                String qnewid = "";
                for (Pair ps : forQueue) {
                    State old = (State)ps.getLeft();
                    Float unew = (Float)ps.getRight();
                    if (!qnewid.equals("")) {
                        qnewid = qnewid + ",";
                    }
                    qnewid = qnewid + "(" + old + "," + unew + ")";
                }
                if (stateMapper.get(qnewid) == null) {
                    State qnew = new State(semiring.zero());
                    res.addState(qnew);
                    stateMapper.put(qnewid, qnew);
                    Float fw = Float.valueOf(qnew.getFinalWeight());
                    for (Pair ps : forQueue) {
                        fw = Float.valueOf(semiring.plus(fw.floatValue(), semiring.times(((State)ps.getLeft()).getFinalWeight(), ((Float)ps.getRight()).floatValue())));
                    }
                    qnew.setFinalWeight(fw.floatValue());
                    queue.add(forQueue);
                }
                pnew.addArc(new Arc(label, label, wnew.floatValue(), stateMapper.get(qnewid)));
            }
        }
        return res;
    }
}

