/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.util.ArrayList;
import java.util.HashSet;

public class Connect {
    private static void calcCoAccessible(Fst fst, State state, ArrayList<ArrayList<State>> paths, HashSet<State> coaccessible) {
        ArrayList<State> newCoAccessibles = new ArrayList<State>();
        for (ArrayList<State> path : paths) {
            int index = path.lastIndexOf(state);
            if (index == -1 || state.getFinalWeight() == fst.getSemiring().zero() && !coaccessible.contains(state)) continue;
            for (int j = index; j > -1; --j) {
                if (coaccessible.contains(path.get(j))) continue;
                newCoAccessibles.add(path.get(j));
                coaccessible.add(path.get(j));
            }
        }
        for (State s : newCoAccessibles) {
            Connect.calcCoAccessible(fst, s, paths, coaccessible);
        }
    }

    private static void duplicatePath(int lastPathIndex, State fromState, State toState, ArrayList<ArrayList<State>> paths) {
        ArrayList<State> lastPath = paths.get(lastPathIndex);
        int fromIndex = lastPath.indexOf(fromState);
        int toIndex = lastPath.indexOf(toState);
        if (toIndex == -1) {
            toIndex = lastPath.size() - 1;
        }
        ArrayList<State> newPath = new ArrayList<State>(lastPath.subList(fromIndex, toIndex));
        paths.add(newPath);
    }

    private static State depthFirstSearchNext(Fst fst, State start, ArrayList<ArrayList<State>> paths, ArrayList<Arc>[] exploredArcs, HashSet<State> accessible) {
        int lastPathIndex = paths.size() - 1;
        ArrayList<Arc> currentExploredArcs = exploredArcs[start.getId()];
        paths.get(lastPathIndex).add(start);
        if (start.getNumArcs() != 0) {
            int arcCount = 0;
            int numArcs = start.getNumArcs();
            for (int j = 0; j < numArcs; ++j) {
                Arc arc = start.getArc(j);
                if (currentExploredArcs != null && currentExploredArcs.contains(arc)) continue;
                lastPathIndex = paths.size() - 1;
                if (arcCount++ > 0) {
                    Connect.duplicatePath(lastPathIndex, fst.getStart(), start, paths);
                    lastPathIndex = paths.size() - 1;
                    paths.get(lastPathIndex).add(start);
                }
                State next = arc.getNextState();
                Connect.addExploredArc(start.getId(), arc, exploredArcs);
                if (next.getId() == start.getId()) continue;
                Connect.depthFirstSearchNext(fst, next, paths, exploredArcs, accessible);
            }
        }
        lastPathIndex = paths.size() - 1;
        accessible.add(start);
        return start;
    }

    private static void addExploredArc(int stateId, Arc arc, ArrayList<Arc>[] exploredArcs) {
        if (exploredArcs[stateId] == null) {
            exploredArcs[stateId] = new ArrayList();
        }
        exploredArcs[stateId].add(arc);
    }

    private static void depthFirstSearch(Fst fst, HashSet<State> accessible, ArrayList<ArrayList<State>> paths, ArrayList<Arc>[] exploredArcs, HashSet<State> coaccessible) {
        State currentState;
        State nextState = currentState = fst.getStart();
        do {
            if (accessible.contains(currentState)) continue;
            nextState = Connect.depthFirstSearchNext(fst, currentState, paths, exploredArcs, accessible);
        } while (currentState.getId() != nextState.getId());
        int numStates = fst.getNumStates();
        for (int i = 0; i < numStates; ++i) {
            State s = fst.getState(i);
            if (s.getFinalWeight() == fst.getSemiring().zero()) continue;
            Connect.calcCoAccessible(fst, s, paths, coaccessible);
        }
    }

    public static void apply(Fst fst) {
        Semiring semiring = fst.getSemiring();
        if (semiring == null) {
            System.out.println("Fst has no semiring.");
            return;
        }
        HashSet<State> accessible = new HashSet<State>();
        HashSet<State> coaccessible = new HashSet<State>();
        ArrayList[] exploredArcs = new ArrayList[fst.getNumStates()];
        ArrayList<ArrayList<State>> paths = new ArrayList<ArrayList<State>>();
        paths.add(new ArrayList());
        Connect.depthFirstSearch(fst, accessible, paths, exploredArcs, coaccessible);
        HashSet<State> toDelete = new HashSet<State>();
        for (int i = 0; i < fst.getNumStates(); ++i) {
            State s = fst.getState(i);
            if (accessible.contains(s) || coaccessible.contains(s)) continue;
            toDelete.add(s);
        }
        fst.deleteStates(toDelete);
    }
}

