/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class State {
    protected int id = -1;
    private float fnlWeight;
    private ArrayList<Arc> arcs = null;
    protected int initialNumArcs = -1;

    protected State() {
        this.arcs = new ArrayList();
    }

    public State(float fnlWeight) {
        this();
        this.fnlWeight = fnlWeight;
    }

    public State(int initialNumArcs) {
        this.initialNumArcs = initialNumArcs;
        if (initialNumArcs > 0) {
            this.arcs = new ArrayList(initialNumArcs);
        }
    }

    public void arcSort(Comparator<Arc> cmp) {
        Collections.sort(this.arcs, cmp);
    }

    public float getFinalWeight() {
        return this.fnlWeight;
    }

    public void setArcs(ArrayList<Arc> arcs) {
        this.arcs = arcs;
    }

    public void setFinalWeight(float fnlfloat) {
        this.fnlWeight = fnlfloat;
    }

    public int getId() {
        return this.id;
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public void addArc(Arc arc) {
        this.arcs.add(arc);
    }

    public Arc getArc(int index) {
        return this.arcs.get(index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.fnlWeight != other.fnlWeight && Float.floatToIntBits(this.fnlWeight) != Float.floatToIntBits(other.fnlWeight)) {
            return false;
        }
        return !(this.arcs == null ? other.arcs != null : !this.arcs.equals(other.arcs));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(" + this.id + ", " + this.fnlWeight + ")");
        return sb.toString();
    }

    public Arc deleteArc(int index) {
        return this.arcs.remove(index);
    }

    public int hashCode() {
        return this.id * 991;
    }

    public void setArc(int index, Arc arc) {
        this.arcs.set(index, arc);
    }
}

