/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Convert;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.semiring.TropicalSemiring;
import java.io.IOException;

public class Import {
    private Import() {
    }

    public static void main(String[] args) throws NumberFormatException, IOException {
        if (args.length < 2) {
            System.err.println("Input and output files not provided");
            System.err.println("You need to provide both the input binary openfst model");
            System.err.println("and the output serialized java fst model.");
            System.exit(1);
        }
        Fst fst = Convert.importFst(args[0], new TropicalSemiring());
        System.out.println("Saving as binary java fst model...");
        try {
            fst.saveModel(args[1]);
        }
        catch (IOException e) {
            System.err.println("Cannot write to file " + args[1]);
            System.exit(1);
        }
    }
}

