/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.window;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.frontend.window.DoubleBuffer;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RaisedCosineWindower
extends BaseDataProcessor {
    @S4Double(defaultValue=25.625)
    public static final String PROP_WINDOW_SIZE_MS = "windowSizeInMs";
    private float windowSizeInMs;
    @S4Double(defaultValue=10.0)
    public static final String PROP_WINDOW_SHIFT_MS = "windowShiftInMs";
    private float windowShiftInMs;
    @S4Double(defaultValue=0.46)
    public static final String PROP_ALPHA = "alpha";
    private double alpha;
    public static final String WINDOW_SHIFT_SAMPLES = "windowSize";
    public static final String WINDOW_SIZE_SAMPLES = "windowShift";
    private double[] cosineWindow;
    private int windowShift;
    private List<Data> outputQueue;
    private DoubleBuffer overflowBuffer;
    private long currentFirstSampleNumber;
    private int sampleRate;

    public RaisedCosineWindower(double alpha, float windowSizeInMs, float windowShiftInMs) {
        this.initLogger();
        this.alpha = alpha;
        this.windowSizeInMs = windowSizeInMs;
        this.windowShiftInMs = windowShiftInMs;
    }

    public RaisedCosineWindower() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.alpha = ps.getDouble(PROP_ALPHA);
        this.windowSizeInMs = ps.getFloat(PROP_WINDOW_SIZE_MS);
        this.windowShiftInMs = ps.getFloat(PROP_WINDOW_SHIFT_MS);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.outputQueue = new LinkedList<Data>();
    }

    private void createWindow(int sampleRate) {
        if (this.cosineWindow != null && sampleRate == this.sampleRate) {
            return;
        }
        this.sampleRate = sampleRate;
        int windowSize = DataUtil.getSamplesPerWindow(sampleRate, this.windowSizeInMs);
        this.cosineWindow = new double[windowSize];
        this.windowShift = DataUtil.getSamplesPerShift(sampleRate, this.windowShiftInMs);
        if (this.cosineWindow.length > 1) {
            double oneMinusAlpha = 1.0 - this.alpha;
            for (int i = 0; i < this.cosineWindow.length; ++i) {
                this.cosineWindow[i] = oneMinusAlpha - this.alpha * Math.cos(Math.PI * 2 * (double)i / ((double)this.cosineWindow.length - 1.0));
            }
        }
        this.overflowBuffer = new DoubleBuffer(windowSize);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input;
        if (this.outputQueue.isEmpty() && (input = this.getPredecessor().getData()) != null) {
            if (input instanceof DoubleData) {
                DoubleData data = (DoubleData)input;
                if (this.currentFirstSampleNumber == -1L) {
                    this.currentFirstSampleNumber = data.getFirstSampleNumber();
                }
                this.createWindow(data.getSampleRate());
                this.process(data);
            } else {
                if (input instanceof DataStartSignal) {
                    DataStartSignal startSignal = (DataStartSignal)input;
                    this.createWindow(startSignal.getSampleRate());
                    Map<String, Object> props = startSignal.getProps();
                    props.put(WINDOW_SHIFT_SAMPLES, this.windowShift);
                    props.put(WINDOW_SIZE_SAMPLES, this.cosineWindow.length);
                    this.currentFirstSampleNumber = -1L;
                } else if (input instanceof SpeechStartSignal) {
                    this.currentFirstSampleNumber = -1L;
                } else if (input instanceof DataEndSignal || input instanceof SpeechEndSignal) {
                    this.processUtteranceEnd();
                }
                this.outputQueue.add(input);
            }
        }
        if (!this.outputQueue.isEmpty()) {
            Data output = this.outputQueue.remove(0);
            if (output instanceof DoubleData) assert (((DoubleData)output).getValues().length == this.cosineWindow.length);
            return output;
        }
        return null;
    }

    private void process(DoubleData input) throws DataProcessingException {
        double[] in = input.getValues();
        int length = this.overflowBuffer.getOccupancy() + in.length;
        LinkedList<DoubleData> dataList = new LinkedList<DoubleData>();
        dataList.add(input);
        Data utteranceEnd = null;
        while (length < this.cosineWindow.length) {
            Data next = this.getPredecessor().getData();
            if (next instanceof DoubleData) {
                dataList.add((DoubleData)next);
                length += ((DoubleData)next).getValues().length;
                continue;
            }
            if (next instanceof DataEndSignal || next instanceof SpeechEndSignal) {
                utteranceEnd = next;
                break;
            }
            this.outputQueue.add(next);
        }
        double[] allSamples = in;
        if (length != in.length) {
            allSamples = new double[length];
            System.arraycopy(this.overflowBuffer.getBuffer(), 0, allSamples, 0, this.overflowBuffer.getOccupancy());
            int start = this.overflowBuffer.getOccupancy();
            for (DoubleData aDataList : dataList) {
                double[] samples = aDataList.getValues();
                System.arraycopy(samples, 0, allSamples, start, samples.length);
                start += samples.length;
            }
        }
        int residual = this.applyRaisedCosineWindow(allSamples, length);
        this.overflowBuffer.reset();
        if (length - residual > 0) {
            this.overflowBuffer.append(allSamples, residual, length - residual);
        }
        if (utteranceEnd != null) {
            this.processUtteranceEnd();
            this.outputQueue.add(utteranceEnd);
        }
    }

    private void processUtteranceEnd() {
        if (this.overflowBuffer.getOccupancy() > 0) {
            this.overflowBuffer.padWindow(this.cosineWindow.length);
            this.applyRaisedCosineWindow(this.overflowBuffer.getBuffer(), this.cosineWindow.length);
            this.overflowBuffer.reset();
        }
    }

    private int applyRaisedCosineWindow(double[] in, int length) {
        int windowCount;
        if (length < this.cosineWindow.length) {
            double[] padded = new double[this.cosineWindow.length];
            System.arraycopy(in, 0, padded, 0, length);
            in = padded;
            windowCount = 1;
        } else {
            windowCount = RaisedCosineWindower.getWindowCount(length, this.cosineWindow.length, this.windowShift);
        }
        double[][] windows = new double[windowCount][this.cosineWindow.length];
        int windowStart = 0;
        for (int i = 0; i < windowCount; ++i) {
            double[] myWindow = windows[i];
            int s = windowStart;
            for (int w = 0; w < myWindow.length; ++w) {
                myWindow[w] = in[s] * this.cosineWindow[w];
                ++s;
            }
            this.outputQueue.add(new DoubleData(myWindow, this.sampleRate, this.currentFirstSampleNumber));
            this.currentFirstSampleNumber += (long)this.windowShift;
            windowStart += this.windowShift;
        }
        return windowStart;
    }

    private static int getWindowCount(int arraySize, int windowSize, int windowShift) {
        if (arraySize < windowSize) {
            return 0;
        }
        int windowCount = 1;
        int windowEnd = windowSize;
        while (windowEnd + windowShift <= arraySize) {
            ++windowCount;
            windowEnd += windowShift;
        }
        return windowCount;
    }

    public float getWindowShiftInMs() {
        if (this.windowShiftInMs == 0.0f) {
            throw new RuntimeException(this + " was not initialized yet!");
        }
        return this.windowShiftInMs;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public long roundToFrames(long samples) {
        int windowSize = DataUtil.getSamplesPerWindow(this.sampleRate, this.windowSizeInMs);
        int windowShift = DataUtil.getSamplesPerShift(this.sampleRate, this.windowShiftInMs);
        long mxNumShifts = samples / (long)windowShift;
        int i = (int)mxNumShifts;
        long remainingSamples;
        while ((remainingSamples = samples - (long)(windowShift * i)) <= (long)windowSize) {
            --i;
        }
        return windowShift * (i + 1) + windowSize;
    }
}

