/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WavWriter
extends BaseDataProcessor {
    @S4String(defaultValue="seg000000")
    public static final String PROP_OUT_FILE_NAME_PATTERN = "outFilePattern";
    @S4Boolean(defaultValue=false)
    public static final String PROP_IS_COMPLETE_PATH = "isCompletePath";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SIGNED_DATA = "signedData";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CAPTURE_UTTERANCES = "captureUtterances";
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private int sampleRate;
    private boolean isInSpeech;
    private boolean isSigned = true;
    private int bitsPerSample;
    private String outFileNamePattern;
    protected boolean captureUtts;
    private boolean isCompletePath;

    public WavWriter(String dumpFilePath, boolean isCompletePath, int bitsPerSample, boolean isSigned, boolean captureUtts) {
        this.initLogger();
        this.outFileNamePattern = dumpFilePath;
        this.isCompletePath = isCompletePath;
        this.bitsPerSample = bitsPerSample;
        if (bitsPerSample % 8 != 0) {
            throw new Error("StreamDataSource: bits per sample must be a multiple of 8.");
        }
        this.isSigned = isSigned;
        this.captureUtts = captureUtts;
        this.initialize();
    }

    public WavWriter() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.outFileNamePattern = ps.getString(PROP_OUT_FILE_NAME_PATTERN);
        this.isCompletePath = ps.getBoolean(PROP_IS_COMPLETE_PATH);
        this.bitsPerSample = ps.getInt(PROP_BITS_PER_SAMPLE);
        if (this.bitsPerSample % 8 != 0) {
            throw new Error("StreamDataSource: bits per sample must be a multiple of 8.");
        }
        this.isSigned = ps.getBoolean(PROP_SIGNED_DATA);
        this.captureUtts = ps.getBoolean(PROP_CAPTURE_UTTERANCES);
        this.initialize();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data instanceof DataStartSignal) {
            this.sampleRate = ((DataStartSignal)data).getSampleRate();
        }
        if (data instanceof DataStartSignal || data instanceof SpeechStartSignal && this.captureUtts) {
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
        }
        if (data instanceof DataEndSignal && !this.captureUtts || data instanceof SpeechEndSignal && this.captureUtts) {
            String wavName = this.isCompletePath ? this.outFileNamePattern : WavWriter.getNextFreeIndex(this.outFileNamePattern);
            this.writeFile(wavName);
            this.isInSpeech = false;
        }
        if (data instanceof SpeechStartSignal) {
            this.isInSpeech = true;
        }
        if ((data instanceof DoubleData || data instanceof FloatData) && (this.isInSpeech || !this.captureUtts)) {
            double[] values;
            DoubleData dd = data instanceof DoubleData ? (DoubleData)data : DataUtil.FloatData2DoubleData((FloatData)data);
            for (double value : values = dd.getValues()) {
                try {
                    this.dos.writeShort(new Short((short)value).shortValue());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return data;
    }

    private static String getNextFreeIndex(String outPattern) {
        String fileName;
        int fileIndex = 0;
        while (true) {
            String indexString = Integer.toString(fileIndex);
            fileName = outPattern.substring(0, Math.max(0, outPattern.length() - indexString.length())) + indexString + ".wav";
            if (!new File(fileName).isFile()) break;
            ++fileIndex;
        }
        return fileName;
    }

    @Override
    public void initialize() {
        super.initialize();
        assert (this.outFileNamePattern != null);
        this.baos = new ByteArrayOutputStream();
    }

    public void setOutFilePattern(String outFileNamePattern) {
        this.outFileNamePattern = outFileNamePattern;
    }

    private static AudioFileFormat.Type getTargetType(String extension) {
        AudioFileFormat.Type[] typesSupported;
        for (AudioFileFormat.Type aTypesSupported : typesSupported = AudioSystem.getAudioFileTypes()) {
            if (!aTypesSupported.getExtension().equals(extension)) continue;
            return aTypesSupported;
        }
        return null;
    }

    public static byte[] valuesToBytes(double[] values, int bytesPerValue, boolean signedData) throws ArrayIndexOutOfBoundsException {
        byte[] byteArray = new byte[bytesPerValue * values.length];
        int byteArInd = 0;
        for (double value : values) {
            int val = (int)value;
            for (int j = bytesPerValue - 1; j >= 0; ++j) {
                byteArray[byteArInd + j] = (byte)(val & 0xFF);
                val >>= 8;
            }
            byteArInd += bytesPerValue;
        }
        return byteArray;
    }

    protected void writeFile(String wavName) {
        AudioFormat wavFormat = new AudioFormat(this.sampleRate, this.bitsPerSample, 1, this.isSigned, true);
        AudioFileFormat.Type outputType = WavWriter.getTargetType("wav");
        byte[] abAudioData = this.baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(abAudioData);
        AudioInputStream ais = new AudioInputStream(bais, wavFormat, abAudioData.length / wavFormat.getFrameSize());
        File outWavFile = new File(wavName);
        if (AudioSystem.isFileTypeSupported(outputType, ais)) {
            try {
                AudioSystem.write(ais, outputType, outWavFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

