/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.TimeFrame;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.io.InputStream;

public class StreamDataSource
extends BaseDataProcessor {
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    @S4Integer(defaultValue=3200)
    public static final String PROP_BYTES_PER_READ = "bytesPerRead";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Boolean(defaultValue=false)
    public static final String PROP_BIG_ENDIAN_DATA = "bigEndianData";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SIGNED_DATA = "signedData";
    private InputStream dataStream;
    protected int sampleRate;
    private int bytesPerRead;
    private int bytesPerValue;
    private long totalValuesRead;
    private boolean bigEndian;
    private boolean signedData;
    private boolean streamEndReached;
    private boolean utteranceEndSent;
    private boolean utteranceStarted;
    protected int bitsPerSample;
    private TimeFrame timeFrame = TimeFrame.INFINITE;

    public StreamDataSource(int sampleRate, int bytesPerRead, int bitsPerSample, boolean bigEndian, boolean signedData) {
        this.initLogger();
        this.init(sampleRate, bytesPerRead, bitsPerSample, bigEndian, signedData);
    }

    public StreamDataSource() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.init(ps.getInt(PROP_SAMPLE_RATE), ps.getInt(PROP_BYTES_PER_READ), ps.getInt(PROP_BITS_PER_SAMPLE), ps.getBoolean(PROP_BIG_ENDIAN_DATA), ps.getBoolean(PROP_SIGNED_DATA));
    }

    private void init(int sampleRate, int bytesPerRead, int bitsPerSample, boolean bigEndian, boolean signedData) {
        this.sampleRate = sampleRate;
        this.bytesPerRead = bytesPerRead;
        this.bitsPerSample = bitsPerSample;
        if (this.bitsPerSample % 8 != 0) {
            throw new IllegalArgumentException("bits per sample must be a multiple of 8");
        }
        this.bytesPerValue = bitsPerSample / 8;
        this.bigEndian = bigEndian;
        this.signedData = signedData;
        this.bytesPerRead += bytesPerRead % 2;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void setInputStream(InputStream inputStream) {
        this.setInputStream(inputStream, TimeFrame.INFINITE);
    }

    public void setInputStream(InputStream inputStream, TimeFrame timeFrame) {
        this.dataStream = inputStream;
        this.timeFrame = timeFrame;
        this.streamEndReached = false;
        this.utteranceEndSent = false;
        this.utteranceStarted = false;
        this.totalValuesRead = 0L;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data output = null;
        if (this.streamEndReached) {
            if (!this.utteranceEndSent) {
                output = new DataEndSignal(this.getDuration());
                this.utteranceEndSent = true;
            }
        } else if (!this.utteranceStarted) {
            this.utteranceStarted = true;
            output = new DataStartSignal(this.sampleRate);
        } else if (this.dataStream != null) {
            while ((output = this.readNextFrame()) != null && this.getDuration() < this.timeFrame.getStart()) {
            }
            if (!(output != null && this.getDuration() <= this.timeFrame.getEnd() || this.utteranceEndSent)) {
                output = new DataEndSignal(this.getDuration());
                this.utteranceEndSent = true;
                this.streamEndReached = true;
            }
        } else {
            this.logger.warning("Input stream is not set");
            if (!this.utteranceEndSent) {
                output = new DataEndSignal(this.getDuration());
                this.utteranceEndSent = true;
            }
        }
        return output;
    }

    private DoubleData readNextFrame() throws DataProcessingException {
        int totalRead = 0;
        int bytesToRead = this.bytesPerRead;
        byte[] samplesBuffer = new byte[this.bytesPerRead];
        long firstSample = this.totalValuesRead;
        try {
            int read;
            do {
                if ((read = this.dataStream.read(samplesBuffer, totalRead, bytesToRead - totalRead)) <= 0) continue;
                totalRead += read;
            } while (read != -1 && totalRead < bytesToRead);
            if (totalRead <= 0) {
                this.closeDataStream();
                return null;
            }
            this.totalValuesRead += (long)(totalRead / this.bytesPerValue);
            if (totalRead < bytesToRead) {
                totalRead = totalRead % 2 == 0 ? totalRead + 2 : totalRead + 3;
                byte[] shrinkedBuffer = new byte[totalRead];
                System.arraycopy(samplesBuffer, 0, shrinkedBuffer, 0, totalRead);
                samplesBuffer = shrinkedBuffer;
                this.closeDataStream();
            }
        }
        catch (IOException ioe) {
            throw new DataProcessingException("Error reading data", ioe);
        }
        double[] doubleData = this.bigEndian ? DataUtil.bytesToValues(samplesBuffer, 0, totalRead, this.bytesPerValue, this.signedData) : DataUtil.littleEndianBytesToValues(samplesBuffer, 0, totalRead, this.bytesPerValue, this.signedData);
        return new DoubleData(doubleData, this.sampleRate, firstSample);
    }

    private void closeDataStream() throws IOException {
        this.streamEndReached = true;
        if (this.dataStream != null) {
            this.dataStream.close();
        }
    }

    private long getDuration() {
        return (long)((double)this.totalValuesRead / (double)this.sampleRate * 1000.0);
    }
}

