/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;

public class AudioContinuityTester
extends BaseDataProcessor {
    long lastSampleNum = -1L;

    public AudioContinuityTester() {
        this.initLogger();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data d = this.getPredecessor().getData();
        assert (this.isAudioStreamContinuous(d)) : "audio stream is not continuous";
        return d;
    }

    private boolean isAudioStreamContinuous(Data input) {
        if (input instanceof DoubleData) {
            DoubleData d = (DoubleData)input;
            if (this.lastSampleNum != -1L && this.lastSampleNum != d.getFirstSampleNumber()) {
                return false;
            }
            this.lastSampleNum = d.getFirstSampleNumber() + (long)d.getValues().length;
        } else if (input instanceof DataStartSignal) {
            this.lastSampleNum = -1L;
        }
        return true;
    }
}

