/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.frequencywarp.FrequencyWarper;

public class PLPFilter {
    private double[] filterCoefficients;
    private final int numDFTPoints;
    public final double centerFreqInHz;
    public final double centerFreqInBark;

    public PLPFilter(double[] DFTFrequenciesInHz, double centerFreqInHz) throws IllegalArgumentException {
        FrequencyWarper bark = new FrequencyWarper();
        this.numDFTPoints = DFTFrequenciesInHz.length;
        this.centerFreqInHz = centerFreqInHz;
        this.centerFreqInBark = bark.hertzToBark(centerFreqInHz);
        if (centerFreqInHz < DFTFrequenciesInHz[0] || centerFreqInHz > DFTFrequenciesInHz[this.numDFTPoints - 1]) {
            throw new IllegalArgumentException("Center frequency for PLP filter out of range");
        }
        this.filterCoefficients = new double[this.numDFTPoints];
        for (int i = 0; i < this.numDFTPoints; ++i) {
            double barkf = bark.hertzToBark(DFTFrequenciesInHz[i]) - this.centerFreqInBark;
            this.filterCoefficients[i] = barkf < -2.5 ? 0.0 : (barkf <= -0.5 ? Math.pow(10.0, barkf + 0.5) : (barkf <= 0.5 ? 1.0 : (barkf <= 1.3 ? Math.pow(10.0, -2.5 * (barkf - 0.5)) : 0.0)));
        }
    }

    public double filterOutput(double[] spectrum) throws IllegalArgumentException {
        if (spectrum.length != this.numDFTPoints) {
            throw new IllegalArgumentException("Mismatch in no. of DFT points " + spectrum.length + " in spectrum and in filter " + this.numDFTPoints);
        }
        double output = 0.0;
        for (int i = 0; i < this.numDFTPoints; ++i) {
            output += spectrum[i] * this.filterCoefficients[i];
        }
        return output;
    }
}

