/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.MelFilter2;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public class MelFrequencyFilterBank2
extends BaseDataProcessor {
    @S4Integer(defaultValue=40)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Double(defaultValue=130.0)
    public static final String PROP_MIN_FREQ = "minimumFrequency";
    @S4Double(defaultValue=6800.0)
    public static final String PROP_MAX_FREQ = "maximumFrequency";
    private int sampleRate;
    private int numberFilters;
    private double minFreq;
    private double maxFreq;
    private MelFilter2[] filters;

    public MelFrequencyFilterBank2(double minFreq, double maxFreq, int numberFilters) {
        this.initLogger();
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.numberFilters = numberFilters;
    }

    public MelFrequencyFilterBank2() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.minFreq = ps.getDouble(PROP_MIN_FREQ);
        this.maxFreq = ps.getDouble(PROP_MAX_FREQ);
        this.numberFilters = ps.getInt(PROP_NUMBER_FILTERS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private double linearToMel(double inputFreq) {
        return 1127.0 * Math.log1p(inputFreq / 700.0);
    }

    private void buildFilterbank(int windowLength, int numberFilters, double minFreq, double maxFreq) throws IllegalArgumentException {
        int i;
        assert (windowLength > 0);
        assert (numberFilters > 0);
        double minFreqMel = this.linearToMel(minFreq);
        double maxFreqMel = this.linearToMel(maxFreq);
        double deltaFreqMel = (maxFreqMel - minFreqMel) / (double)(numberFilters + 1);
        double deltaFreq = (double)this.sampleRate / (double)windowLength;
        double[] melPoints = new double[windowLength / 2];
        this.filters = new MelFilter2[numberFilters];
        for (i = 0; i < windowLength / 2; ++i) {
            melPoints[i] = this.linearToMel((double)i * deltaFreq);
        }
        for (i = 0; i < numberFilters; ++i) {
            double centerMel = minFreqMel + (double)(i + 1) * deltaFreqMel;
            this.filters[i] = new MelFilter2(centerMel, deltaFreqMel, melPoints);
        }
    }

    private DoubleData process(DoubleData input) throws IllegalArgumentException {
        double[] in = input.getValues();
        int windowLength = in.length - 1 << 1;
        if (this.filters == null || this.sampleRate != input.getSampleRate()) {
            this.sampleRate = input.getSampleRate();
            this.buildFilterbank(windowLength, this.numberFilters, this.minFreq, this.maxFreq);
        } else if (in.length != (windowLength >> 1) + 1) {
            throw new IllegalArgumentException("Window size is incorrect: in.length == " + in.length + ", numberFftPoints == " + ((windowLength >> 1) + 1));
        }
        double[] output = new double[this.numberFilters];
        for (int i = 0; i < this.numberFilters; ++i) {
            output[i] = this.filters[i].apply(in);
        }
        DoubleData outputMelSpectrum = new DoubleData(output, this.sampleRate, input.getFirstSampleNumber());
        return outputMelSpectrum;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (input != null && input instanceof DoubleData) {
            input = this.process((DoubleData)input);
        }
        return input;
    }
}

