/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import java.util.Arrays;

public class MelFilter2 {
    private final int offset;
    private final double[] weights;

    public MelFilter2(double center, double delta, double[] melPoints) {
        int lastIndex = 0;
        int firstIndex = melPoints.length;
        double left = center - delta;
        double right = center + delta;
        double[] heights = new double[melPoints.length];
        for (int i = 0; i < heights.length; ++i) {
            if (left < melPoints[i] && melPoints[i] <= center) {
                heights[i] = (melPoints[i] - left) / (center - left);
                firstIndex = Math.min(i, firstIndex);
                lastIndex = i;
            }
            if (!(center < melPoints[i]) || !(melPoints[i] < right)) continue;
            heights[i] = (right - melPoints[i]) / (right - center);
            lastIndex = i;
        }
        this.offset = firstIndex;
        this.weights = Arrays.copyOfRange(heights, firstIndex, lastIndex + 1);
    }

    public double apply(double[] powerSpectrum) {
        double result = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            result += this.weights[i] * powerSpectrum[this.offset + i];
        }
        return result;
    }
}

