/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.filter;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;

public class Preemphasizer
extends BaseDataProcessor {
    @S4Double(defaultValue=0.97)
    public static final String PROP_PREEMPHASIS_FACTOR = "factor";
    private double preemphasisFactor;
    private double prior;

    public Preemphasizer(double preemphasisFactor) {
        this.initLogger();
        this.preemphasisFactor = preemphasisFactor;
    }

    public Preemphasizer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.preemphasisFactor = ps.getDouble(PROP_PREEMPHASIS_FACTOR);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (input != null) {
            if (input instanceof DoubleData) {
                this.applyPreemphasis(((DoubleData)input).getValues());
            } else if (input instanceof DataEndSignal || input instanceof SpeechEndSignal) {
                this.prior = 0.0;
            }
        }
        return input;
    }

    private void applyPreemphasis(double[] in) {
        double nextPrior = this.prior;
        if (in.length > 0) {
            nextPrior = in[in.length - 1];
        }
        if (in.length > 1 && this.preemphasisFactor != 0.0) {
            double previous = in[0];
            in[0] = previous - this.preemphasisFactor * this.prior;
            for (int i = 1; i < in.length; ++i) {
                double current = in[i];
                in[i] = current - this.preemphasisFactor * previous;
                previous = current;
            }
        }
        this.prior = nextPrior;
    }
}

