/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.feature.AbstractFeatureExtractor;

public class S3FeatureExtractor
extends AbstractFeatureExtractor {
    @Override
    protected Data computeNextFeature() {
        int k;
        int jp1 = (this.currentPosition - 1 + this.cepstraBufferSize) % this.cepstraBufferSize;
        int jp2 = (this.currentPosition - 2 + this.cepstraBufferSize) % this.cepstraBufferSize;
        int jp3 = (this.currentPosition - 3 + this.cepstraBufferSize) % this.cepstraBufferSize;
        int jf1 = (this.currentPosition + 1) % this.cepstraBufferSize;
        int jf2 = (this.currentPosition + 2) % this.cepstraBufferSize;
        int jf3 = (this.currentPosition + 3) % this.cepstraBufferSize;
        DoubleData currentCepstrum = this.cepstraBuffer[this.currentPosition];
        double[] mfc3f = this.cepstraBuffer[jf3].getValues();
        double[] mfc2f = this.cepstraBuffer[jf2].getValues();
        double[] mfc1f = this.cepstraBuffer[jf1].getValues();
        double[] current = currentCepstrum.getValues();
        double[] mfc1p = this.cepstraBuffer[jp1].getValues();
        double[] mfc2p = this.cepstraBuffer[jp2].getValues();
        double[] mfc3p = this.cepstraBuffer[jp3].getValues();
        float[] feature = new float[current.length * 3];
        this.currentPosition = (this.currentPosition + 1) % this.cepstraBufferSize;
        int j = 0;
        for (k = 1; k < current.length; ++k) {
            feature[j++] = (float)current[k];
        }
        for (k = 1; k < mfc2f.length; ++k) {
            feature[j++] = (float)(mfc2f[k] - mfc2p[k]);
        }
        feature[j++] = (float)current[0];
        feature[j++] = (float)(mfc2f[0] - mfc2p[0]);
        for (k = 0; k < mfc3f.length; ++k) {
            feature[j++] = (float)(mfc3f[k] - mfc1p[k] - (mfc1f[k] - mfc3p[k]));
        }
        return new FloatData(feature, currentCepstrum.getSampleRate(), currentCepstrum.getFirstSampleNumber());
    }
}

