/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;

public class FeatureTransform
extends BaseDataProcessor {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    float[][] transform;
    protected Loader loader;
    int rows;
    int values;

    public FeatureTransform(Loader loader) {
        this.initLogger();
        this.init(loader);
    }

    public FeatureTransform() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.init((Loader)ps.getComponent(PROP_LOADER));
    }

    private void init(Loader loader) {
        this.loader = loader;
        try {
            loader.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.transform = loader.getTransformMatrix();
    }

    @Override
    public Data getData() throws DataProcessingException {
        int i;
        Data data = this.getPredecessor().getData();
        if (null == this.transform || null == data || !(data instanceof FloatData)) {
            return data;
        }
        FloatData floatData = (FloatData)data;
        float[] features = floatData.getValues();
        if (features.length > this.transform[0].length + 1) {
            throw new IllegalArgumentException("dimenstion mismatch");
        }
        float[] result = new float[this.transform.length];
        for (i = 0; i < this.transform.length; ++i) {
            for (int j = 0; j < features.length; ++j) {
                int n = i;
                result[n] = result[n] + this.transform[i][j] * features[j];
            }
        }
        if (features.length > this.transform[0].length) {
            for (i = 0; i < this.transform.length; ++i) {
                int n = i;
                result[n] = result[n] + this.transform[i][features.length];
            }
        }
        return new FloatData(result, floatData.getSampleRate(), floatData.getFirstSampleNumber());
    }
}

