/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.databranch;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.databranch.DataListener;
import edu.cmu.sphinx.frontend.databranch.DataProducer;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.ArrayList;
import java.util.List;

public class FrontEndSplitter
extends BaseDataProcessor
implements DataProducer {
    @S4ComponentList(type=Configurable.class, beTolerant=true)
    public static final String PROP_DATA_LISTENERS = "dataListeners";
    private List<DataListener> listeners = new ArrayList<DataListener>();

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.listeners = ps.getComponentList(PROP_DATA_LISTENERS, DataListener.class);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        for (DataListener l : this.listeners) {
            l.processDataFrame(input);
        }
        return input;
    }

    @Override
    public void addDataListener(DataListener l) {
        if (l == null) {
            return;
        }
        this.listeners.add(l);
    }

    @Override
    public void removeDataListener(DataListener l) {
        if (l == null) {
            return;
        }
        this.listeners.remove(l);
    }
}

