/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.denoise.Denoise;
import edu.cmu.sphinx.frontend.frequencywarp.MelFrequencyFilterBank;
import edu.cmu.sphinx.frontend.frequencywarp.MelFrequencyFilterBank2;
import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform;
import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform2;
import edu.cmu.sphinx.frontend.transform.KaldiDiscreteCosineTransform;
import edu.cmu.sphinx.frontend.transform.Lifter;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.KaldiLoader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AutoCepstrum
extends BaseDataProcessor {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    protected Loader loader;
    protected BaseDataProcessor filterBank;
    protected Denoise denoise;
    protected DiscreteCosineTransform dct;
    protected Lifter lifter;
    protected List<DataProcessor> selectedDataProcessors;

    public AutoCepstrum(Loader loader) throws IOException {
        this.initLogger();
        this.loader = loader;
        loader.load();
        this.initDataProcessors();
    }

    public AutoCepstrum() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.loader = (Loader)ps.getComponent(PROP_LOADER);
        try {
            this.loader.load();
        }
        catch (IOException e) {
            throw new PropertyException(e);
        }
        this.initDataProcessors();
    }

    private void initDataProcessors() {
        try {
            Properties featParams = this.loader.getProperties();
            this.selectedDataProcessors = new ArrayList<DataProcessor>();
            double lowFreq = Double.parseDouble(featParams.getProperty("-lowerf"));
            double hiFreq = Double.parseDouble(featParams.getProperty("-upperf"));
            int numFilter = Integer.parseInt(featParams.getProperty("-nfilt"));
            this.filterBank = this.loader instanceof KaldiLoader ? new MelFrequencyFilterBank2(lowFreq, hiFreq, numFilter) : new MelFrequencyFilterBank(lowFreq, hiFreq, numFilter);
            this.selectedDataProcessors.add(this.filterBank);
            if (featParams.get("-remove_noise") == null || featParams.get("-remove_noise").equals("yes")) {
                this.denoise = new Denoise(Denoise.class.getField("LAMBDA_POWER").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("LAMBDA_A").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("LAMBDA_B").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("LAMBDA_T").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("MU_T").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("MAX_GAIN").getAnnotation(S4Double.class).defaultValue(), Denoise.class.getField("SMOOTH_WINDOW").getAnnotation(S4Integer.class).defaultValue());
                this.denoise.setPredecessor(this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1));
                this.selectedDataProcessors.add(this.denoise);
            }
            this.dct = featParams.get("-transform") != null && featParams.get("-transform").equals("dct") ? new DiscreteCosineTransform2(numFilter, DiscreteCosineTransform.class.getField("PROP_CEPSTRUM_LENGTH").getAnnotation(S4Integer.class).defaultValue()) : (featParams.get("-transform") != null && featParams.get("-transform").equals("kaldi") ? new KaldiDiscreteCosineTransform(numFilter, DiscreteCosineTransform.class.getField("PROP_CEPSTRUM_LENGTH").getAnnotation(S4Integer.class).defaultValue()) : new DiscreteCosineTransform(numFilter, DiscreteCosineTransform.class.getField("PROP_CEPSTRUM_LENGTH").getAnnotation(S4Integer.class).defaultValue()));
            this.dct.setPredecessor(this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1));
            this.selectedDataProcessors.add(this.dct);
            if (featParams.get("-lifter") != null) {
                this.lifter = new Lifter(Integer.parseInt((String)featParams.get("-lifter")));
                this.lifter.setPredecessor(this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1));
                this.selectedDataProcessors.add(this.lifter);
            }
            this.logger.info("Cepstrum component auto-configured as follows: " + this.toString());
        }
        catch (NoSuchFieldException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        for (DataProcessor dataProcessor : this.selectedDataProcessors) {
            dataProcessor.initialize();
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        DataProcessor dp = this.selectedDataProcessors.get(this.selectedDataProcessors.size() - 1);
        return dp.getData();
    }

    @Override
    public void setPredecessor(DataProcessor predecessor) {
        this.filterBank.setPredecessor(predecessor);
    }

    @Override
    public String toString() {
        StringBuilder description = new StringBuilder(super.toString()).append(" {");
        for (DataProcessor dp : this.selectedDataProcessors) {
            description.append(dp).append(", ");
        }
        description.setLength(description.length() - 2);
        return description.append('}').toString();
    }
}

