/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.pruner.Pruner;
import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListManager;
import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.TokenSearchManager;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WordPruningBreadthFirstSearchManager
extends TokenSearchManager {
    @S4Component(type=Linguist.class)
    public static final String PROP_LINGUIST = "linguist";
    @S4Component(type=Pruner.class)
    public static final String PROP_PRUNER = "pruner";
    @S4Component(type=AcousticScorer.class)
    public static final String PROP_SCORER = "scorer";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_TOKEN_COUNT = "showTokenCount";
    @S4Integer(defaultValue=0)
    public static final String PROP_GROW_SKIP_INTERVAL = "growSkipInterval";
    @S4Component(type=ActiveListManager.class)
    public static final String PROP_ACTIVE_LIST_MANAGER = "activeListManager";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CHECK_STATE_ORDER = "checkStateOrder";
    @S4Integer(defaultValue=100)
    public static final String PROP_MAX_LATTICE_EDGES = "maxLatticeEdges";
    @S4Double(defaultValue=0.0)
    public static final String PROP_ACOUSTIC_LOOKAHEAD_FRAMES = "acousticLookaheadFrames";
    @S4Double(defaultValue=0.0)
    public static final String PROP_RELATIVE_BEAM_WIDTH = "relativeBeamWidth";
    protected Linguist linguist;
    protected Pruner pruner;
    protected AcousticScorer scorer;
    private ActiveListManager activeListManager;
    protected LogMath logMath;
    protected Logger logger;
    protected boolean showTokenCount;
    protected boolean checkStateOrder;
    private int growSkipInterval;
    protected float relativeBeamWidth;
    protected float acousticLookaheadFrames;
    private int maxLatticeEdges = 100;
    protected Timer scoreTimer;
    protected Timer pruneTimer;
    protected Timer growTimer;
    protected StatisticsVariable totalTokensScored;
    protected StatisticsVariable curTokensScored;
    protected StatisticsVariable tokensCreated;
    private long tokenSum;
    private int tokenCount;
    protected int currentFrameNumber;
    protected long currentCollectTime;
    protected ActiveList activeList;
    protected List<Token> resultList;
    protected Map<SearchState, Token> bestTokenMap;
    protected AlternateHypothesisManager loserManager;
    private int numStateOrder;
    protected boolean streamEnd;

    public WordPruningBreadthFirstSearchManager(Linguist linguist, Pruner pruner, AcousticScorer scorer, ActiveListManager activeListManager, boolean showTokenCount, double relativeWordBeamWidth, int growSkipInterval, boolean checkStateOrder, boolean buildWordLattice, int maxLatticeEdges, float acousticLookaheadFrames, boolean keepAllTokens) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logMath = LogMath.getLogMath();
        this.linguist = linguist;
        this.pruner = pruner;
        this.scorer = scorer;
        this.activeListManager = activeListManager;
        this.showTokenCount = showTokenCount;
        this.growSkipInterval = growSkipInterval;
        this.checkStateOrder = checkStateOrder;
        this.buildWordLattice = buildWordLattice;
        this.maxLatticeEdges = maxLatticeEdges;
        this.acousticLookaheadFrames = acousticLookaheadFrames;
        this.keepAllTokens = keepAllTokens;
        this.relativeBeamWidth = this.logMath.linearToLog(relativeWordBeamWidth);
    }

    public WordPruningBreadthFirstSearchManager() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logMath = LogMath.getLogMath();
        this.logger = ps.getLogger();
        this.linguist = (Linguist)ps.getComponent(PROP_LINGUIST);
        this.pruner = (Pruner)ps.getComponent(PROP_PRUNER);
        this.scorer = (AcousticScorer)ps.getComponent(PROP_SCORER);
        this.activeListManager = (ActiveListManager)ps.getComponent(PROP_ACTIVE_LIST_MANAGER);
        this.showTokenCount = ps.getBoolean(PROP_SHOW_TOKEN_COUNT);
        this.growSkipInterval = ps.getInt(PROP_GROW_SKIP_INTERVAL);
        this.checkStateOrder = ps.getBoolean(PROP_CHECK_STATE_ORDER);
        this.maxLatticeEdges = ps.getInt(PROP_MAX_LATTICE_EDGES);
        this.acousticLookaheadFrames = ps.getFloat(PROP_ACOUSTIC_LOOKAHEAD_FRAMES);
        this.relativeBeamWidth = this.logMath.linearToLog(ps.getDouble(PROP_RELATIVE_BEAM_WIDTH));
    }

    @Override
    public void allocate() {
        this.scoreTimer = TimerPool.getTimer(this, "Score");
        this.pruneTimer = TimerPool.getTimer(this, "Prune");
        this.growTimer = TimerPool.getTimer(this, "Grow");
        this.totalTokensScored = StatisticsVariable.getStatisticsVariable("totalTokensScored");
        this.curTokensScored = StatisticsVariable.getStatisticsVariable("curTokensScored");
        this.tokensCreated = StatisticsVariable.getStatisticsVariable("tokensCreated");
        try {
            this.linguist.allocate();
            this.pruner.allocate();
            this.scorer.allocate();
        }
        catch (IOException e) {
            throw new RuntimeException("Allocation of search manager resources failed", e);
        }
    }

    @Override
    public void deallocate() {
        try {
            this.scorer.deallocate();
            this.pruner.deallocate();
            this.linguist.deallocate();
        }
        catch (IOException e) {
            throw new RuntimeException("Deallocation of search manager resources failed", e);
        }
    }

    @Override
    public void startRecognition() {
        this.linguist.startRecognition();
        this.pruner.startRecognition();
        this.scorer.startRecognition();
        this.localStart();
    }

    @Override
    public Result recognize(int nFrames) {
        boolean done = false;
        Result result = null;
        this.streamEnd = false;
        for (int i = 0; i < nFrames && !done; ++i) {
            done = this.recognize();
        }
        if (!this.streamEnd) {
            result = new Result(this.loserManager, this.activeList, this.resultList, this.currentCollectTime, done, this.linguist.getSearchGraph().getWordTokenFirst(), true);
        }
        if (this.showTokenCount) {
            this.showTokenCount();
        }
        return result;
    }

    protected boolean recognize() {
        this.activeList = this.activeListManager.getEmittingList();
        boolean more = this.scoreTokens();
        if (more) {
            this.pruneBranches();
            ++this.currentFrameNumber;
            if (this.growSkipInterval == 0 || this.currentFrameNumber % this.growSkipInterval != 0) {
                this.clearCollectors();
                this.growEmittingBranches();
                this.growNonEmittingBranches();
            }
        }
        return !more;
    }

    private void clearCollectors() {
        this.resultList = new LinkedList<Token>();
        this.createBestTokenMap();
        this.activeListManager.clearEmittingList();
    }

    protected void createBestTokenMap() {
        int mapSize = this.activeList.size() * 10;
        if (mapSize == 0) {
            mapSize = 1;
        }
        this.bestTokenMap = new HashMap<SearchState, Token>(mapSize, 0.3f);
    }

    @Override
    public void stopRecognition() {
        this.localStop();
        this.scorer.stopRecognition();
        this.pruner.stopRecognition();
        this.linguist.stopRecognition();
    }

    protected void localStart() {
        SearchGraph searchGraph = this.linguist.getSearchGraph();
        this.currentFrameNumber = 0;
        this.curTokensScored.value = 0.0;
        this.numStateOrder = searchGraph.getNumStateOrder();
        this.activeListManager.setNumStateOrder(this.numStateOrder);
        if (this.buildWordLattice) {
            this.loserManager = new AlternateHypothesisManager(this.maxLatticeEdges);
        }
        SearchState state = searchGraph.getInitialState();
        this.activeList = this.activeListManager.getEmittingList();
        this.activeList.add(new Token(state, -1L));
        this.clearCollectors();
        this.growBranches();
        this.growNonEmittingBranches();
    }

    protected void localStop() {
    }

    protected void growBranches() {
        this.growTimer.start();
        float relativeBeamThreshold = this.activeList.getBeamThreshold();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Frame: " + this.currentFrameNumber + " thresh : " + relativeBeamThreshold + " bs " + this.activeList.getBestScore() + " tok " + this.activeList.getBestToken());
        }
        for (Token token : this.activeList) {
            if (!(token.getScore() >= relativeBeamThreshold) || !this.allowExpansion(token)) continue;
            this.collectSuccessorTokens(token);
        }
        this.growTimer.stop();
    }

    protected void growEmittingBranches() {
        if (this.acousticLookaheadFrames <= 0.0f) {
            this.growBranches();
            return;
        }
        this.growTimer.start();
        float bestScore = -3.4028235E38f;
        for (Token t : this.activeList) {
            float score = t.getScore() + t.getAcousticScore() * this.acousticLookaheadFrames;
            if (!(score > bestScore)) continue;
            bestScore = score;
        }
        float relativeBeamThreshold = bestScore + this.relativeBeamWidth;
        for (Token t : this.activeList) {
            if (!(t.getScore() + t.getAcousticScore() * this.acousticLookaheadFrames > relativeBeamThreshold)) continue;
            this.collectSuccessorTokens(t);
        }
        this.growTimer.stop();
    }

    private void growNonEmittingBranches() {
        Iterator<ActiveList> i = this.activeListManager.getNonEmittingListIterator();
        while (i.hasNext()) {
            this.activeList = i.next();
            if (this.activeList == null) continue;
            i.remove();
            this.pruneBranches();
            this.growBranches();
        }
    }

    protected boolean scoreTokens() {
        this.scoreTimer.start();
        Data data = this.scorer.calculateScores(this.activeList.getTokens());
        this.scoreTimer.stop();
        Token bestToken = null;
        if (data instanceof Token) {
            bestToken = (Token)data;
        } else if (data == null) {
            this.streamEnd = true;
        }
        if (bestToken != null) {
            this.currentCollectTime = bestToken.getCollectTime();
        }
        boolean moreTokens = bestToken != null;
        this.activeList.setBestToken(bestToken);
        this.monitorStates(this.activeList);
        this.curTokensScored.value += (double)this.activeList.size();
        this.totalTokensScored.value += (double)this.activeList.size();
        return moreTokens;
    }

    private void monitorWords(ActiveList activeList) {
    }

    protected void monitorStates(ActiveList activeList) {
        this.tokenSum += (long)activeList.size();
        ++this.tokenCount;
        if (this.tokenCount % 1000 == 0) {
            this.logger.info("Average Tokens/State: " + this.tokenSum / (long)this.tokenCount);
        }
    }

    protected void pruneBranches() {
        this.pruneTimer.start();
        this.activeList = this.pruner.prune(this.activeList);
        this.pruneTimer.stop();
    }

    protected Token getBestToken(SearchState state) {
        return this.bestTokenMap.get(state);
    }

    protected void setBestToken(Token token, SearchState state) {
        this.bestTokenMap.put(state, token);
    }

    protected void checkStateOrder(SearchState fromState, SearchState toState) {
        if (fromState.getOrder() == this.numStateOrder - 1) {
            return;
        }
        if (fromState.getOrder() > toState.getOrder()) {
            throw new Error("IllegalState order: from " + fromState.getClass().getName() + ' ' + fromState.toPrettyString() + " order: " + fromState.getOrder() + " to " + toState.getClass().getName() + ' ' + toState.toPrettyString() + " order: " + toState.getOrder());
        }
    }

    protected void collectSuccessorTokens(Token token) {
        if (token.isFinal()) {
            this.resultList.add(this.getResultListPredecessor(token));
            return;
        }
        if (!token.isEmitting() && this.keepAllTokens && this.isVisited(token)) {
            return;
        }
        SearchState state = token.getSearchState();
        SearchStateArc[] arcs = state.getSuccessors();
        Token predecessor = this.getResultListPredecessor(token);
        for (SearchStateArc arc : arcs) {
            SearchState nextState = arc.getState();
            if (this.checkStateOrder) {
                this.checkStateOrder(state, nextState);
            }
            float logEntryScore = token.getScore() + arc.getProbability();
            Token bestToken = this.getBestToken(nextState);
            if (bestToken == null) {
                Token newBestToken = new Token(predecessor, nextState, logEntryScore, arc.getInsertionProbability(), arc.getLanguageProbability(), this.currentCollectTime);
                this.tokensCreated.value += 1.0;
                this.setBestToken(newBestToken, nextState);
                this.activeListAdd(newBestToken);
                continue;
            }
            if (bestToken.getScore() < logEntryScore) {
                Token oldPredecessor = bestToken.getPredecessor();
                bestToken.update(predecessor, nextState, logEntryScore, arc.getInsertionProbability(), arc.getLanguageProbability(), this.currentCollectTime);
                if (!this.buildWordLattice || !(nextState instanceof WordSearchState)) continue;
                this.loserManager.addAlternatePredecessor(bestToken, oldPredecessor);
                continue;
            }
            if (!this.buildWordLattice || !(nextState instanceof WordSearchState) || predecessor == null) continue;
            this.loserManager.addAlternatePredecessor(bestToken, predecessor);
        }
    }

    protected boolean isVisited(Token t) {
        SearchState curState = t.getSearchState();
        for (t = t.getPredecessor(); t != null && !t.isEmitting(); t = t.getPredecessor()) {
            if (!curState.equals(t.getSearchState())) continue;
            System.out.println("CS " + curState + " match " + t.getSearchState());
            return true;
        }
        return false;
    }

    protected void activeListAdd(Token token) {
        this.activeListManager.add(token);
    }

    protected boolean allowExpansion(Token t) {
        return true;
    }

    protected void showTokenCount() {
        Token token;
        HashSet<Token> tokenSet = new HashSet<Token>();
        Iterator<Object> i$ = this.activeList.iterator();
        while (i$.hasNext()) {
            for (token = (Token)i$.next(); token != null; token = token.getPredecessor()) {
                tokenSet.add(token);
            }
        }
        System.out.println("Token Lattice size: " + tokenSet.size());
        tokenSet = new HashSet();
        i$ = this.resultList.iterator();
        while (i$.hasNext()) {
            for (token = (Token)i$.next(); token != null; token = token.getPredecessor()) {
                tokenSet.add(token);
            }
        }
        System.out.println("Result Lattice size: " + tokenSet.size());
    }

    public ActiveList getActiveList() {
        return this.activeList;
    }

    public void setActiveList(ActiveList activeList) {
        this.activeList = activeList;
    }

    public List<Token> getResultList() {
        return this.resultList;
    }

    public void setResultList(List<Token> resultList) {
        this.resultList = resultList;
    }

    public int getCurrentFrameNumber() {
        return this.currentFrameNumber;
    }

    public Timer getGrowTimer() {
        return this.growTimer;
    }

    public StatisticsVariable getTokensCreated() {
        return this.tokensCreated;
    }
}

