/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;

public abstract class TokenSearchManager
implements SearchManager {
    @S4Boolean(defaultValue=true)
    public static final String PROP_BUILD_WORD_LATTICE = "buildWordLattice";
    @S4Boolean(defaultValue=false)
    public static final String PROP_KEEP_ALL_TOKENS = "keepAllTokens";
    protected boolean buildWordLattice;
    protected boolean keepAllTokens;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.buildWordLattice = ps.getBoolean(PROP_BUILD_WORD_LATTICE);
        this.keepAllTokens = ps.getBoolean(PROP_KEEP_ALL_TOKENS);
    }

    protected Token getResultListPredecessor(Token token) {
        if (this.keepAllTokens) {
            return token;
        }
        if (!this.buildWordLattice) {
            if (token.isWord()) {
                return token;
            }
            return token.getPredecessor();
        }
        float logAcousticScore = 0.0f;
        float logLanguageScore = 0.0f;
        float logInsertionScore = 0.0f;
        while (token != null && !token.isWord()) {
            logAcousticScore += token.getAcousticScore();
            logLanguageScore += token.getLanguageScore();
            logInsertionScore += token.getInsertionScore();
            token = token.getPredecessor();
        }
        return new Token(token, token.getScore(), logInsertionScore, logAcousticScore, logLanguageScore);
    }
}

