/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.WordPruningBreadthFirstSearchManager;
import edu.cmu.sphinx.linguist.SearchState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TokenHeapSearchManager
extends WordPruningBreadthFirstSearchManager {
    protected final int maxTokenHeapSize = 3;
    Map<Object, TokenHeap> bestTokenMap;

    @Override
    protected void createBestTokenMap() {
        int mapSize = this.activeList.size() << 2;
        if (mapSize == 0) {
            mapSize = 1;
        }
        this.bestTokenMap = new HashMap<Object, TokenHeap>(mapSize, 0.3f);
    }

    @Override
    protected void setBestToken(Token token, SearchState state) {
        TokenHeap th = this.bestTokenMap.get(state);
        if (th == null) {
            th = new TokenHeap(3);
            this.bestTokenMap.put(state, th);
        }
        th.add(token);
    }

    @Override
    protected Token getBestToken(SearchState state) {
        TokenHeap th = this.bestTokenMap.get(state);
        if (th == null) {
            return null;
        }
        Token t = th.get(state);
        if (t != null) {
            return t;
        }
        if (!th.isFull()) {
            return null;
        }
        return th.getSmallest();
    }

    class TokenHeap {
        final Token[] tokens;
        int curSize;

        TokenHeap(int maxSize) {
            this.tokens = new Token[maxSize];
        }

        void add(Token token) {
            if (!this.tryReplace(token)) {
                if (this.curSize < this.tokens.length) {
                    this.tokens[this.curSize++] = token;
                } else if (token.getScore() > this.tokens[this.curSize - 1].getScore()) {
                    this.tokens[this.curSize - 1] = token;
                }
            }
            this.fixupInsert();
        }

        Token getSmallest() {
            if (this.curSize == 0) {
                return null;
            }
            return this.tokens[this.curSize - 1];
        }

        boolean isFull() {
            return this.curSize == this.tokens.length;
        }

        private boolean tryReplace(Token t) {
            for (int i = 0; i < this.curSize; ++i) {
                if (!t.getSearchState().equals(this.tokens[i].getSearchState())) continue;
                assert (t.getScore() > this.tokens[i].getScore());
                this.tokens[i] = t;
                return true;
            }
            return false;
        }

        private void fixupInsert() {
            Arrays.sort(this.tokens, 0, this.curSize - 1, Scoreable.COMPARATOR);
        }

        Token get(SearchState s) {
            for (int i = 0; i < this.curSize; ++i) {
                if (!this.tokens[i].getSearchState().equals(s)) continue;
                return this.tokens[i];
            }
            return null;
        }
    }
}

