/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Token
implements Scoreable {
    private static int curCount;
    private static int lastCount;
    private static final DecimalFormat scoreFmt;
    private static final DecimalFormat numFmt;
    private Token predecessor;
    private float logLanguageScore;
    private float logTotalScore;
    private float logInsertionScore;
    private float logAcousticScore;
    private SearchState searchState;
    private long collectTime;
    private Data data;

    public Token(Token predecessor, SearchState state, float logTotalScore, float logInsertionScore, float logLanguageScore, long collectTime) {
        this.predecessor = predecessor;
        this.searchState = state;
        this.logTotalScore = logTotalScore;
        this.logInsertionScore = logInsertionScore;
        this.logLanguageScore = logLanguageScore;
        this.collectTime = collectTime;
        ++curCount;
    }

    public Token(SearchState state, long collectTime) {
        this(null, state, 0.0f, 0.0f, 0.0f, collectTime);
    }

    public Token(Token predecessor, float logTotalScore, float logAcousticScore, float logInsertionScore, float logLanguageScore) {
        this(predecessor, null, logTotalScore, logInsertionScore, logLanguageScore, 0L);
        this.logAcousticScore = logAcousticScore;
    }

    public Token getPredecessor() {
        return this.predecessor;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public void setData(Data data) {
        this.data = data;
        if (data instanceof FloatData) {
            this.collectTime = ((FloatData)data).getCollectTime();
        }
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public float getScore() {
        return this.logTotalScore;
    }

    @Override
    public float calculateScore(Data feature) {
        this.logAcousticScore = ((ScoreProvider)((Object)this.searchState)).getScore(feature);
        this.logTotalScore += this.logAcousticScore;
        this.setData(feature);
        return this.logTotalScore;
    }

    public float[] calculateComponentScore(Data feature) {
        return ((ScoreProvider)((Object)this.searchState)).getComponentScore(feature);
    }

    @Override
    public float normalizeScore(float maxLogScore) {
        this.logTotalScore -= maxLogScore;
        this.logAcousticScore -= maxLogScore;
        return this.logTotalScore;
    }

    public void setScore(float logScore) {
        this.logTotalScore = logScore;
    }

    public float getLanguageScore() {
        return this.logLanguageScore;
    }

    public float getInsertionScore() {
        return this.logInsertionScore;
    }

    public float getAcousticScore() {
        return this.logAcousticScore;
    }

    public SearchState getSearchState() {
        return this.searchState;
    }

    public boolean isEmitting() {
        return this.searchState.isEmitting();
    }

    public boolean isFinal() {
        return this.searchState.isFinal();
    }

    public boolean isWord() {
        return this.searchState instanceof WordSearchState;
    }

    public String toString() {
        return numFmt.format(this.getCollectTime()) + ' ' + scoreFmt.format(this.getScore()) + ' ' + scoreFmt.format(this.getAcousticScore()) + ' ' + scoreFmt.format(this.getLanguageScore()) + ' ' + this.getSearchState();
    }

    public void dumpTokenPath() {
        this.dumpTokenPath(true);
    }

    public void dumpTokenPath(boolean includeHMMStates) {
        Token token;
        ArrayList<Token> list = new ArrayList<Token>();
        for (token = this; token != null; token = token.getPredecessor()) {
            list.add(token);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            token = (Token)list.get(i);
            if (!includeHMMStates && token.getSearchState() instanceof HMMSearchState) continue;
            System.out.println("  " + token);
        }
        System.out.println();
    }

    public String getWordPath(boolean wantFiller, boolean wantPronunciations) {
        StringBuilder sb = new StringBuilder();
        for (Token token = this; token != null; token = token.getPredecessor()) {
            if (!token.isWord()) continue;
            WordSearchState wordState = (WordSearchState)token.getSearchState();
            Pronunciation pron = wordState.getPronunciation();
            Word word = wordState.getPronunciation().getWord();
            if (!wantFiller && word.isFiller()) continue;
            if (wantPronunciations) {
                sb.insert(0, ']');
                Unit[] u = pron.getUnits();
                for (int i = u.length - 1; i >= 0; --i) {
                    if (i < u.length - 1) {
                        sb.insert(0, ',');
                    }
                    sb.insert(0, u[i].getName());
                }
                sb.insert(0, '[');
            }
            sb.insert(0, word.getSpelling());
            sb.insert(0, ' ');
        }
        return sb.toString().trim();
    }

    public String getWordPathNoFiller() {
        return this.getWordPath(false, false);
    }

    public String getWordPath() {
        return this.getWordPath(true, false);
    }

    public String getWordUnitPath() {
        StringBuilder sb = new StringBuilder();
        for (Token token = this; token != null; token = token.getPredecessor()) {
            SearchState searchState = token.getSearchState();
            if (searchState instanceof WordSearchState) {
                WordSearchState wordState = (WordSearchState)searchState;
                Word word = wordState.getPronunciation().getWord();
                sb.insert(0, ' ' + word.getSpelling());
                continue;
            }
            if (!(searchState instanceof UnitSearchState)) continue;
            UnitSearchState unitState = (UnitSearchState)searchState;
            Unit unit = unitState.getUnit();
            sb.insert(0, ' ' + unit.getName());
        }
        return sb.toString().trim();
    }

    public Word getWord() {
        if (this.isWord()) {
            WordSearchState wordState = (WordSearchState)this.searchState;
            return wordState.getPronunciation().getWord();
        }
        return null;
    }

    public static void showCount() {
        System.out.println("Cur count: " + curCount + " new " + (curCount - lastCount));
        lastCount = curCount;
    }

    public boolean validate() {
        return true;
    }

    protected static DecimalFormat getScoreFormat() {
        return scoreFmt;
    }

    protected static DecimalFormat getNumberFormat() {
        return numFmt;
    }

    public void update(Token predecessor, SearchState nextState, float logEntryScore, float insertionProbability, float languageProbability, long collectTime) {
        this.predecessor = predecessor;
        this.searchState = nextState;
        this.logTotalScore = logEntryScore;
        this.logInsertionScore = insertionProbability;
        this.logLanguageScore = languageProbability;
        this.collectTime = collectTime;
    }

    static {
        scoreFmt = new DecimalFormat("0.0000000E00");
        numFmt = new DecimalFormat("0000");
    }
}

