/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Partitioner;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.TokenArrayIterator;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PartitionActiveListFactory
extends ActiveListFactory {
    public PartitionActiveListFactory(int absoluteBeamWidth, double relativeBeamWidth) {
        super(absoluteBeamWidth, relativeBeamWidth);
    }

    public PartitionActiveListFactory() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    public ActiveList newInstance() {
        return new PartitionActiveList(this.absoluteBeamWidth, this.logRelativeBeamWidth);
    }

    class PartitionActiveList
    implements ActiveList {
        private int size;
        private final int absoluteBeamWidth;
        private final float logRelativeBeamWidth;
        private Token bestToken;
        private Token[] tokenList;
        private final Partitioner partitioner = new Partitioner();

        public PartitionActiveList(int absoluteBeamWidth, float logRelativeBeamWidth) {
            this.absoluteBeamWidth = absoluteBeamWidth;
            this.logRelativeBeamWidth = logRelativeBeamWidth;
            int listSize = 2000;
            if (absoluteBeamWidth > 0) {
                listSize = absoluteBeamWidth / 3;
            }
            this.tokenList = new Token[listSize];
        }

        @Override
        public void add(Token token) {
            if (this.size < this.tokenList.length) {
                this.tokenList[this.size] = token;
                ++this.size;
            } else {
                this.doubleCapacity();
                this.add(token);
            }
            if (this.bestToken == null || token.getScore() > this.bestToken.getScore()) {
                this.bestToken = token;
            }
        }

        private void doubleCapacity() {
            this.tokenList = Arrays.copyOf(this.tokenList, this.tokenList.length * 2);
        }

        @Override
        public ActiveList purge() {
            if (this.absoluteBeamWidth > 0 && this.size > this.absoluteBeamWidth) {
                this.size = this.partitioner.partition(this.tokenList, this.size, this.absoluteBeamWidth) + 1;
            }
            return this;
        }

        @Override
        public float getBeamThreshold() {
            return this.getBestScore() + this.logRelativeBeamWidth;
        }

        @Override
        public float getBestScore() {
            float bestScore = -3.4028235E38f;
            if (this.bestToken != null) {
                bestScore = this.bestToken.getScore();
            }
            return bestScore;
        }

        @Override
        public void setBestToken(Token token) {
            this.bestToken = token;
        }

        @Override
        public Token getBestToken() {
            return this.bestToken;
        }

        @Override
        public Iterator<Token> iterator() {
            return new TokenArrayIterator(this.tokenList, this.size);
        }

        @Override
        public List<Token> getTokens() {
            return Arrays.asList(this.tokenList).subList(0, this.size);
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public ActiveList newInstance() {
            return PartitionActiveListFactory.this.newInstance();
        }
    }
}

