/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.adaptation;

import edu.cmu.sphinx.decoder.adaptation.Stats;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Sphinx3Loader;
import java.io.File;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class Transform {
    private float[][][][] As;
    private float[][][] Bs;
    private Sphinx3Loader loader;
    private int nrOfClusters;

    public Transform(Sphinx3Loader loader, int nrOfClusters) {
        this.loader = loader;
        this.nrOfClusters = nrOfClusters;
    }

    public float[][][][] getAs() {
        return this.As;
    }

    public float[][][] getBs() {
        return this.Bs;
    }

    public void store(String filePath, int index) throws Exception {
        PrintWriter writer = new PrintWriter(filePath, "UTF-8");
        writer.println("1");
        writer.println(this.loader.getNumStreams());
        for (int i = 0; i < this.loader.getNumStreams(); ++i) {
            int j;
            writer.println(this.loader.getVectorLength()[i]);
            for (j = 0; j < this.loader.getVectorLength()[i]; ++j) {
                for (int k = 0; k < this.loader.getVectorLength()[i]; ++k) {
                    writer.print(this.As[index][i][j][k]);
                    writer.print(" ");
                }
                writer.println();
            }
            for (j = 0; j < this.loader.getVectorLength()[i]; ++j) {
                writer.print(this.Bs[index][i][j]);
                writer.print(" ");
            }
            writer.println();
            for (j = 0; j < this.loader.getVectorLength()[i]; ++j) {
                writer.print("1.0 ");
            }
            writer.println();
        }
        writer.close();
    }

    private void computeMllrTransforms(double[][][][][] regLs, double[][][][] regRs) {
        for (int c = 0; c < this.nrOfClusters; ++c) {
            this.As[c] = new float[this.loader.getNumStreams()][][];
            this.Bs[c] = new float[this.loader.getNumStreams()][];
            for (int i = 0; i < this.loader.getNumStreams(); ++i) {
                int len = this.loader.getVectorLength()[i];
                this.As[c][i] = new float[len][len];
                this.Bs[c][i] = new float[len];
                for (int j = 0; j < len; ++j) {
                    Array2DRowRealMatrix coef = new Array2DRowRealMatrix(regLs[c][i][j], false);
                    DecompositionSolver solver = new LUDecomposition((RealMatrix)coef).getSolver();
                    ArrayRealVector vect = new ArrayRealVector(regRs[c][i][j], false);
                    RealVector ABloc = solver.solve((RealVector)vect);
                    for (int k = 0; k < len; ++k) {
                        this.As[c][i][j][k] = (float)ABloc.getEntry(k);
                    }
                    this.Bs[c][i][j] = (float)ABloc.getEntry(len);
                }
            }
        }
    }

    public void load(String filePath) throws Exception {
        Scanner input = new Scanner(new File(filePath));
        int[] vectorLength = new int[1];
        int nMllrClass = input.nextInt();
        assert (nMllrClass == 1);
        int numStreams = input.nextInt();
        this.As = new float[nMllrClass][][][];
        this.Bs = new float[nMllrClass][][];
        for (int i = 0; i < numStreams; ++i) {
            int j;
            vectorLength[i] = input.nextInt();
            int length = vectorLength[i];
            this.As[0] = new float[numStreams][length][length];
            this.Bs[0] = new float[numStreams][length];
            for (j = 0; j < length; ++j) {
                for (int k = 0; k < length; ++k) {
                    this.As[0][i][j][k] = input.nextFloat();
                }
            }
            for (j = 0; j < length; ++j) {
                this.Bs[0][i][j] = input.nextFloat();
            }
        }
        input.close();
    }

    public void update(Stats stats) {
        stats.fillRegLowerPart();
        this.As = new float[this.nrOfClusters][][][];
        this.Bs = new float[this.nrOfClusters][][];
        this.computeMllrTransforms(stats.getRegLs(), stats.getRegRs());
    }
}

