/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder;

import edu.cmu.sphinx.decoder.AbstractDecoder;
import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.result.Result;
import java.util.List;

public class FrameDecoder
extends AbstractDecoder
implements DataProcessor {
    private DataProcessor predecessor;
    private boolean isRecognizing;
    private Result result;

    public FrameDecoder(SearchManager searchManager, boolean fireNonFinalResults, boolean autoAllocate, List<ResultListener> listeners) {
        super(searchManager, fireNonFinalResults, autoAllocate, listeners);
    }

    public FrameDecoder() {
    }

    @Override
    public Result decode(String referenceText) {
        return this.searchManager.recognize(1);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data d = this.getPredecessor().getData();
        if (this.isRecognizing && (d instanceof FloatData || d instanceof DoubleData || d instanceof SpeechEndSignal)) {
            this.result = this.decode(null);
            if (this.result != null) {
                this.fireResultListeners(this.result);
                this.result = null;
            }
        }
        if (d instanceof DataEndSignal) {
            this.searchManager.stopRecognition();
        }
        if (d instanceof SpeechStartSignal) {
            this.searchManager.startRecognition();
            this.isRecognizing = true;
            this.result = null;
        }
        if (d instanceof SpeechEndSignal) {
            this.searchManager.stopRecognition();
            if (this.result != null) {
                this.fireResultListeners(this.result);
            }
            this.isRecognizing = false;
        }
        return d;
    }

    @Override
    public DataProcessor getPredecessor() {
        return this.predecessor;
    }

    @Override
    public void setPredecessor(DataProcessor predecessor) {
        this.predecessor = predecessor;
    }

    @Override
    public void initialize() {
    }
}

