/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.LatticeOptimizer;
import edu.cmu.sphinx.result.Nbest;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.WordResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class SpeechResult {
    private final Result result;
    private final Lattice lattice;

    public SpeechResult(Result result) {
        this.result = result;
        if (result.toCreateLattice()) {
            this.lattice = new Lattice(result);
            new LatticeOptimizer(this.lattice).optimize();
            this.lattice.computeNodePosteriors(1.0f);
        } else {
            this.lattice = null;
        }
    }

    public List<WordResult> getWords() {
        return this.lattice != null ? this.lattice.getWordResultPath() : this.result.getTimedBestResult(false);
    }

    public String getHypothesis() {
        return this.result.getBestResultNoFiller();
    }

    public Collection<String> getNbest(int n) {
        if (this.lattice == null) {
            return new HashSet<String>();
        }
        return new Nbest(this.lattice).getNbest(n);
    }

    public Lattice getLattice() {
        return this.lattice;
    }

    public Result getResult() {
        return this.result;
    }
}

