/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import edu.cmu.sphinx.alignment.LongTextAligner;
import edu.cmu.sphinx.alignment.SimpleTokenizer;
import edu.cmu.sphinx.alignment.TextTokenizer;
import edu.cmu.sphinx.api.Configuration;
import edu.cmu.sphinx.api.Context;
import edu.cmu.sphinx.linguist.language.grammar.AlignerGrammar;
import edu.cmu.sphinx.linguist.language.ngram.DynamicTrigramModel;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.Range;
import edu.cmu.sphinx.util.TimeFrame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.logging.Logger;

public class SpeechAligner {
    private final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private static final int TUPLE_SIZE = 3;
    private final Context context;
    private final Recognizer recognizer;
    private final AlignerGrammar grammar;
    private final DynamicTrigramModel languageModel;
    private TextTokenizer tokenizer;

    public SpeechAligner(String amPath, String dictPath, String g2pPath) throws MalformedURLException, IOException {
        Configuration configuration = new Configuration();
        configuration.setAcousticModelPath(amPath);
        configuration.setDictionaryPath(dictPath);
        this.context = new Context(configuration);
        if (g2pPath != null) {
            this.context.setLocalProperty("dictionary->g2pModelPath", g2pPath);
            this.context.setLocalProperty("dictionary->g2pMaxPron", "2");
        }
        this.context.setLocalProperty("lexTreeLinguist->languageModel", "dynamicTrigramModel");
        this.recognizer = this.context.getInstance(Recognizer.class);
        this.grammar = this.context.getInstance(AlignerGrammar.class);
        this.languageModel = this.context.getInstance(DynamicTrigramModel.class);
        this.setTokenizer(new SimpleTokenizer());
    }

    public List<WordResult> align(URL audioUrl, String transcript) throws IOException {
        return this.align(audioUrl, this.getTokenizer().expand(transcript));
    }

    public List<WordResult> align(URL audioUrl, List<String> sentenceTranscript) throws IOException {
        List<String> transcript = this.sentenceToWords(sentenceTranscript);
        LongTextAligner aligner = new LongTextAligner(transcript, 3);
        TreeMap<Integer, WordResult> alignedWords = new TreeMap<Integer, WordResult>();
        LinkedList<Range> ranges = new LinkedList<Range>();
        ArrayDeque<List<String>> texts = new ArrayDeque<List<String>>();
        ArrayDeque<TimeFrame> timeFrames = new ArrayDeque<TimeFrame>();
        ranges.offer(new Range(0, transcript.size()));
        texts.offer(transcript);
        TimeFrame totalTimeFrame = TimeFrame.INFINITE;
        timeFrames.offer(totalTimeFrame);
        long lastFrame = TimeFrame.INFINITE.getEnd();
        this.languageModel.setText(sentenceTranscript);
        for (int i = 0; i < 4; ++i) {
            if (i == 1) {
                this.context.setLocalProperty("decoder->searchManager", "alignerSearchManager");
            }
            while (!texts.isEmpty()) {
                Result result;
                assert (texts.size() == ranges.size());
                assert (texts.size() == timeFrames.size());
                List text = (List)texts.poll();
                TimeFrame frame = (TimeFrame)timeFrames.poll();
                Range range = (Range)ranges.poll();
                this.logger.info("Aligning frame " + frame + " to text " + text + " range " + range);
                this.recognizer.allocate();
                if (i >= 1) {
                    this.grammar.setWords(text);
                }
                this.context.setSpeechSource(audioUrl.openStream(), frame);
                ArrayList<WordResult> hypothesis = new ArrayList<WordResult>();
                while (null != (result = this.recognizer.recognize())) {
                    this.logger.info("Utterance result " + result.getTimedBestResult(true));
                    hypothesis.addAll(result.getTimedBestResult(false));
                }
                if (i == 0 && hypothesis.size() > 0) {
                    lastFrame = ((WordResult)hypothesis.get(hypothesis.size() - 1)).getTimeFrame().getEnd();
                }
                ArrayList<String> words = new ArrayList<String>();
                for (WordResult wr : hypothesis) {
                    words.add(wr.getWord().getSpelling());
                }
                int[] alignment = aligner.align(words, range);
                ArrayList<WordResult> results = hypothesis;
                this.logger.info("Decoding result is " + results);
                this.dumpAlignmentStats(transcript, alignment, results);
                for (int j = 0; j < alignment.length; ++j) {
                    if (alignment[j] == -1) continue;
                    alignedWords.put(alignment[j], (WordResult)hypothesis.get(j));
                }
                this.recognizer.deallocate();
            }
            this.scheduleNextAlignment(transcript, alignedWords, ranges, texts, timeFrames, lastFrame);
        }
        return new ArrayList<WordResult>(alignedWords.values());
    }

    public List<String> sentenceToWords(List<String> sentenceTranscript) {
        ArrayList<String> transcript = new ArrayList<String>();
        for (String sentence : sentenceTranscript) {
            String[] words;
            for (String word : words = sentence.split("\\s+")) {
                if (word.length() <= 0) continue;
                transcript.add(word);
            }
        }
        return transcript;
    }

    private void dumpAlignmentStats(List<String> transcript, int[] alignment, List<WordResult> results) {
        int insertions = 0;
        int deletions = 0;
        int size = transcript.size();
        int[] aid = alignment;
        int lastId = -1;
        for (int ij = 0; ij < aid.length; ++ij) {
            if (aid[ij] == -1) {
                ++insertions;
                continue;
            }
            if (aid[ij] - lastId > 1) {
                deletions += aid[ij] - lastId;
            }
            lastId = aid[ij];
        }
        if (lastId >= 0 && transcript.size() - lastId > 1) {
            deletions += transcript.size() - lastId;
        }
        this.logger.info(String.format("Size %d deletions %d insertions %d error rate %.2f", size, insertions, deletions, Float.valueOf((float)(insertions + deletions) / (float)size * 100.0f)));
    }

    private void scheduleNextAlignment(List<String> transcript, Map<Integer, WordResult> alignedWords, Queue<Range> ranges, Queue<List<String>> texts, Queue<TimeFrame> timeFrames, long lastFrame) {
        int prevKey = 0;
        long prevStart = 0L;
        for (Map.Entry<Integer, WordResult> e : alignedWords.entrySet()) {
            if (e.getKey() - prevKey > 1) {
                this.checkedOffer(transcript, texts, timeFrames, ranges, prevKey, e.getKey() + 1, prevStart, e.getValue().getTimeFrame().getEnd());
            }
            prevKey = e.getKey();
            prevStart = e.getValue().getTimeFrame().getStart();
        }
        if (transcript.size() - prevKey > 1) {
            this.checkedOffer(transcript, texts, timeFrames, ranges, prevKey, transcript.size(), prevStart, lastFrame);
        }
    }

    public void dumpAlignment(List<String> transcript, int[] alignment, List<WordResult> results) {
        this.logger.info("Alignment");
        int[] aid = alignment;
        int lastId = -1;
        for (int ij = 0; ij < aid.length; ++ij) {
            if (aid[ij] == -1) {
                this.logger.info(String.format("+ %s", results.get(ij)));
                continue;
            }
            if (aid[ij] - lastId > 1) {
                for (String result1 : transcript.subList(lastId + 1, aid[ij])) {
                    this.logger.info(String.format("- %-25s", result1));
                }
            } else {
                this.logger.info(String.format("  %-25s", transcript.get(aid[ij])));
            }
            lastId = aid[ij];
        }
        if (lastId >= 0 && transcript.size() - lastId > 1) {
            for (String result1 : transcript.subList(lastId + 1, transcript.size())) {
                this.logger.info(String.format("- %-25s", result1));
            }
        }
    }

    private void checkedOffer(List<String> transcript, Queue<List<String>> texts, Queue<TimeFrame> timeFrames, Queue<Range> ranges, int start, int end, long timeStart, long timeEnd) {
        double wordDensity = (double)(timeEnd - timeStart) / (double)(end - start);
        if (wordDensity < 10.0 && end - start > 3) {
            this.logger.info("Skipping text range due to a high density " + transcript.subList(start, end).toString());
            return;
        }
        texts.offer(transcript.subList(start, end));
        timeFrames.offer(new TimeFrame(timeStart, timeEnd));
        ranges.offer(new Range(start, end - 1));
    }

    public TextTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(TextTokenizer wordExpander) {
        this.tokenizer = wordExpander;
    }
}

