/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.ItemContents;
import edu.cmu.sphinx.alignment.tokenizer.Utterance;

public class Relation {
    private String name;
    private Utterance owner;
    private Item head;
    private Item tail;
    public static final String TOKEN = "Token";
    public static final String WORD = "Word";

    Relation(String name, Utterance owner) {
        this.name = name;
        this.owner = owner;
        this.head = null;
        this.tail = null;
    }

    public String getName() {
        return this.name;
    }

    public Item getHead() {
        return this.head;
    }

    void setHead(Item item) {
        this.head = item;
    }

    public Item getTail() {
        return this.tail;
    }

    void setTail(Item item) {
        this.tail = item;
    }

    public Item appendItem() {
        return this.appendItem(null);
    }

    public Item appendItem(Item originalItem) {
        ItemContents contents = originalItem == null ? null : originalItem.getSharedContents();
        Item newItem = new Item(this, contents);
        if (this.head == null) {
            this.head = newItem;
        }
        if (this.tail != null) {
            this.tail.attach(newItem);
        }
        this.tail = newItem;
        return newItem;
    }

    public Utterance getUtterance() {
        return this.owner;
    }
}

