// JavaScript Document

// Global variables
g_last = null;

$ = function(id){
	return document.getElementById(id); 
};

function blockIEContextMenus(o){
	var blocker = function(){ event.returnValue = false;};
	var anArray = o.getElementsByTagName("div");
	var i;
	
	o.oncontextmenu = blocker;
	for (i=0;i<anArray.length;i++){
		anArray[i].oncontextmenu = blocker;
	}
	return;
}

window.onload = function(){
	/*
		Main onload function which loads all the interface initializations functions.
	*/
	window.external.SetSize(356, 208);
	window.external.SetTransparentColor(0xffff00);
	
	for (i=0; i<document.all.length; i++){
		if (document.all(i).tagName.toLowerCase() != "input"){
			 document.all(i).unselectable = "on";
			 document.all(i).style.cursor = "default";
		}
	}
	blockIEContextMenus(document.body);

	initCaptionButtons();
	$("eCaptionBar").onmousedown = function(){
		if (event.button == 1){
			window.external.CaptionMouseDown();
		}
	};
	
	$("dictionaryListButton").onmouseout = function(){
		this.style.backgroundImage = "url(img/Buttons/add_to_dict_up.png)";
	};
	
	$("dictionaryListButton").onmouseover = function(){
		this.style.backgroundImage = "url(img/Buttons/add_to_dict_up.png)";
	};
	
	$("dictionaryListButton").onmousedown = function(){
		if (event.button == 1)
			this.style.backgroundImage = "url(img/Buttons/add_to_dict_press.png)";
	};
	
	$("dictionaryListButton").onmouseup = function(){
		this.style.backgroundImage = "url(img/Buttons/add_to_dict_up.png)";
		if (event.button == 1){
			window.external.ViewMyWords();
		}
	};
	
	$("enableProxy").onclick = function(){
		if (this.checked){
			$("serverAddress").disabled = "";
			$("serverPort").disabled = "";
			$("serverAddress").style.backgroundColor="#ffffff";
			$("serverPort").style.backgroundColor="#ffffff";
		} else {
			$("serverAddress").disabled = "disabled";
			$("serverPort").disabled = "disabled";
			$("serverAddress").value = "";
			$("serverPort").value = "";
			$("serverAddress").style.backgroundColor="#EAEAEA";
			$("serverPort").style.backgroundColor="#EAEAEA";
		}
	};
	
	/*var anArray = document.getElementsByTagName("input");
	for (i=0;i<anArray.length;i++){
		//anArray[i].onclick = function(){updateRegistry(this);};
	}*/
	setupFields();
	writingStylesStartup();
	//window.external.SetRegistryValue("ShowMarkedMsg","Yes");
	//answer = window.external.GetRegistryValue("ShowMarkedMsg",answer);
};

function GetRegistryYesNoValueAsBool(regStringValue){
	var answer = window.external.GetRegistryValue(regStringValue, "");
	if (answer == "Yes"){return true;} else {return false;}
}
function GetRegistryOneZeroValueAsBool(regDWORDValue){
	var answer = window.external.GetDWORDRegistryValue(regDWORDValue, 0);
	if (answer == 0){return false;} else {return true;}
}
setupFields = function(){
	//$("autoCorrect").checked = GetRegistryYesNoValueAsBool("WSAutoCorrect");
	//$("welcomeScreen").checked = GetRegistryOneZeroValueAsBool("ShowOnStartup");
	//$("notifyError").checked = GetRegistryYesNoValueAsBool("WSAutoCheck");
	$("addSigToEmail").checked = GetRegistryYesNoValueAsBool("WSSignature");
	$("showFloatingButton").checked = GetRegistryOneZeroValueAsBool("ShowFloatingButton");
	$("outlookIntegration").checked = GetRegistryOneZeroValueAsBool("OutlookCheckOnSend");

	var answer = window.external.GetDWORDRegistryValue("ShortCutID", 113);
	switch (answer){
		case 113:
			$("shortcutKeyF2").checked = true;
			$("shortcutKeyF4").checked = false;
			$("shortcutKeyF6").checked = false;
			$("shortcutKeyF8").checked = false;
		break;
		case 115:
			$("shortcutKeyF2").checked = false;
			$("shortcutKeyF4").checked = true;
			$("shortcutKeyF6").checked = false;
			$("shortcutKeyF8").checked = false;
		break;
		case 117:
			$("shortcutKeyF2").checked = false;
			$("shortcutKeyF4").checked = false;
			$("shortcutKeyF6").checked = true;
			$("shortcutKeyF8").checked = false;
		break;
		case 119:
			$("shortcutKeyF2").checked = false;
			$("shortcutKeyF4").checked = false;
			$("shortcutKeyF6").checked = false;
			$("shortcutKeyF8").checked = true;
		break;
	}
	
	answer = window.external.GetDWORDRegistryValue("DictMouseButton", 2);
	switch(answer){
		case 1: $("dictMouseLeft").checked = true; $("dictMouseMiddle").checked = false; $("dictMouseRight").checked = false; break;
		case 2: $("dictMouseLeft").checked = false; $("dictMouseMiddle").checked = false; $("dictMouseRight").checked = true; break;
		case 4: $("dictMouseLeft").checked = false; $("dictMouseMiddle").checked = true; $("dictMouseRight").checked = false; break;
		default: $("dictMouseLeft").checked = false; $("dictMouseMiddle").checked = false; $("dictMouseRight").checked = true; break;
	}
	
	answer = window.external.GetDWORDRegistryValue("DictKeyState", 2);
	switch(answer){
		case 1: $("dictKeyboardShortcutCtrl").checked = false; $("dictKeyboardShortcutShift").checked = false; $("dictKeyboardShortcutAlt").checked = true; break;
		case 2: $("dictKeyboardShortcutCtrl").checked = true; $("dictKeyboardShortcutShift").checked = false; $("dictKeyboardShortcutAlt").checked = false; break;
		case 4: $("dictKeyboardShortcutCtrl").checked = false; $("dictKeyboardShortcutShift").checked = true; $("dictKeyboardShortcutAlt").checked = false; break;
		default: $("dictKeyboardShortcutCtrl").checked = false; $("dictKeyboardShortcutShift").checked = true; $("dictKeyboardShortcutAlt").checked = false; break;
	}
	
	answer = window.external.GetRegistryValue("SerialKey", "");
	$("userID").innerHTML = answer;
	
	$("versionID").innerHTML = window.external.version;
	
	/*
		Setting up the proxy screen values and controls!
	*/
	
	answer = window.external.GetDWORDRegistryValue("ProxyEnable", 0);
	
	if (answer == 1){
		answer = window.external.GetRegistryValue("ProxyServer", "");
		$("enableProxy").checked = true;
		$("serverAddress").value = "";
		$("serverAddress").disabled = "";
		$("serverPort").value = "";
		$("serverPort").disabled = "";
		$("serverAddress").style.backgroundColor="#ffffff";
		$("serverPort").style.backgroundColor="#ffffff";
		
		if (answer == ""){
		} else {
			var server = answer.split(":");
			$("serverAddress").value = server[0];
			$("serverPort").value = server[1];
		}
	} else {
		$("enableProxy").checked = false;
		$("serverAddress").value = "";
		$("serverAddress").disabled = "disabled";
		$("serverPort").value = "";
		$("serverPort").disabled = "disabled";
		$("serverAddress").style.backgroundColor="#EAEAEA";
		$("serverPort").style.backgroundColor="#EAEAEA";
	}
	return;
};

function SetRegistryYesNoValue(checkBox, regStringValue){
	if (checkBox.checked)
		window.external.SetRegistryValue(regStringValue, "Yes");
	else
		window.external.SetRegistryValue(regStringValue, "No");
}
function SetRegistryOneZeroValue(checkBox, regDWORDValue){
	if (checkBox.checked)
		window.external.SetDWORDRegistryValue(regDWORDValue, 1);
	else
		window.external.SetDWORDRegistryValue(regDWORDValue, 0);
}
updateRegistry = function(){
	var o ;
	//var o = $("autoCorrect");
	//SetRegistryYesNoValue(o, "WSAutoCorrect");
	
	//o = $("welcomeScreen");
	//SetRegistryOneZeroValue(o, "ShowOnStartup");
	
	//o = $("notifyError");
	//SetRegistryYesNoValue(o, "WSAutoCheck");
	
	o = $("addSigToEmail");
	SetRegistryYesNoValue(o, "WSSignature");
	
	o = $("showFloatingButton");
	SetRegistryOneZeroValue(o, "ShowFloatingButton");
			
	o = $("outlookIntegration");
	SetRegistryOneZeroValue(o, "OutlookCheckOnSend");

	o = $("shortcutKeyF2");
	
		if (o.checked){
			window.external.SetDWORDRegistryValue("ShortCutID",113);
		}
		
	o = $("shortcutKeyF4");
	
		if (o.checked){
			window.external.SetDWORDRegistryValue("ShortCutID",115);
		}
		
	o = $("shortcutKeyF6");
	
		if (o.checked){
			window.external.SetDWORDRegistryValue("ShortCutID",117);
		}
		
	o = $("shortcutKeyF8");
	
		if (o.checked){
			window.external.SetDWORDRegistryValue("ShortCutID",119);
		}
	
	     o = $("dictKeyboardShortcutCtrl");
	var o2 = $("dictKeyboardShortcutShift");
	var o3 = $("dictKeyboardShortcutAlt");
	
	if (o.checked){
		// Ctrl
		window.external.SetDWORDRegistryValue("DictKeyState",2);
	} else if (o2.checked){
		// Shift
		window.external.SetDWORDRegistryValue("DictKeyState",4);
	} else if (o3.checked){
		// Alt
		window.external.SetDWORDRegistryValue("DictKeyState",1);
	}
	
	     o = $("dictMouseLeft");
	var o2 = $("dictMouseMiddle");
	var o3 = $("dictMouseRight");
	
	if (o.checked){
		// Left
		window.external.SetDWORDRegistryValue("DictMouseButton" ,1);
	} else if (o2.checked){
		// Middle
		window.external.SetDWORDRegistryValue("DictMouseButton",4);
	} else if (o3.checked){
		// Right
		window.external.SetDWORDRegistryValue("DictMouseButton",2);
	}	
	
	/*
		Saving the proxy server and port information if needed.
	*/
	
	if ($("enableProxy").checked){
		var server 	= $("serverAddress");
		var port 	= $("serverPort");
		
		if (server.value != "" && port.value != ""){
			port = parseInt(port.value);
			var serverString = server.value+":"+port;
			window.external.SetDWORDRegistryValue("ProxyEnable" ,1);
			window.external.SetRegistryValue("ProxyServer",serverString);
		}
	} else {
		window.external.SetDWORDRegistryValue("ProxyEnable" ,0);
		window.external.SetRegistryValue("ProxyServer","");
	}
	return;
};

initCaptionButtons = function(){
	/* The closeButton,maximize and minimize buttons over and down background changes settings. */	
	$("appMinimizeButton").onmouseover = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_min_over.gif)";
	};
	
	$("appMinimizeButton").onmouseout = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_min_up.gif)";
	};
	
	$("appMinimizeButton").onmousedown = function(){
		if (event.button == 1)
			this.style.backgroundImage = "url(img/captionbar/caption_bar_min_down.gif)";
	};
	
	$("appMinimizeButton").onmouseup = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_min_over.gif)";		
		if (event.button == 1)
			window.external.Minimize();
	};
	
		
	$("appMaximizeButton").onmouseover = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_max_over.gif)";
	};
	
	$("appMaximizeButton").onmouseout = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_max_up.gif)";
	};
	
	$("appMaximizeButton").onmousedown = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_max_down.gif)";
	};
	
	$("appMaximizeButton").onmouseup = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_max_over.gif)";
		alert("MAXIMIZE WINDOW");
	};
		
	$("appCloseButton").onmouseover = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_close_over.gif)";
	};
	
	$("appCloseButton").onmouseout = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_close_up.gif)";
	};
	
	$("appCloseButton").onmousedown = function(){
		if (event.button == 1)
			this.style.backgroundImage = "url(img/captionbar/caption_bar_close_down.gif)";
	};
	
	$("appCloseButton").onmouseup = function(){
		this.style.backgroundImage = "url(img/captionbar/caption_bar_close_over.gif)";
		if (event.button == 1)
			window.external.Close();
	};
	
	$("appSaveButton").onmouseover = function(){
		this.style.backgroundImage = "url(img/Buttons/save_over.png)";
	};
	
	$("appSaveButton").onmouseout = function(){
		this.style.backgroundImage = "url(img/Buttons/save_up.png)";
	};
	
	$("appSaveButton").onmousedown = function(){
		if (event.button == 1)
			this.style.backgroundImage = "url(img/Buttons/save_down.png)";
	};
	
	$("appSaveButton").onmouseup = function(){
		if (event.button == 1){
			this.style.backgroundImage = "url(img/Buttons/save_over.png)";
			updateRegistry();
			window.external.NotifySettingsChanged();	// So we can update tray's tooltip when WS hot key changed, for example
			window.external.Close();
		}
	};
	
	$("appCancelButton").onmouseover = function(){
		this.style.backgroundImage = "url(img/Buttons/cancel_over.png)";
	};
	
	$("appCancelButton").onmouseout = function(){
		this.style.backgroundImage = "url(img/Buttons/cancel_up.png)";
	};
	
	$("appCancelButton").onmousedown = function(){
		if (event.button == 1)
			this.style.backgroundImage = "url(img/Buttons/cancel_down.png)";
	};
	
	$("appCancelButton").onmouseup = function(){
		if (event.button == 1){
			this.style.backgroundImage = "url(img/Buttons/cancel_over.png)";
			window.external.Close();
		}
	};
	
	
	/* Tabs interaction methods */
	
	$("general").onmouseup = function(){
		//this.style.backgroundImage = "url(img/Buttons/tab_general_on.png)";
		if (!g_last){
			g_last = this;
		} else {
			hide(g_last);
			g_last = this;
		}
		show(this);
	};
	
	$("shortcut").onmouseup = function(){
		//this.style.backgroundImage = "url(img/Buttons/tab_shortcut_on.png)";
		if (!g_last){
			g_last = this;
		} else {
			hide(g_last);
			g_last = this;
		}
		show(this);
	};
	
	$("info").onmouseup = function(){
		//this.style.backgroundImage = "url(img/Buttons/tab_info_on.png)";
		if (!g_last){
			g_last = this;
		} else {
			hide(g_last);
			g_last = this;
		}
		show(this);
	};
	
	$("connection").onmouseup = function(){
		//this.style.backgroundImage = "url(img/Buttons/tab_info_on.png)";
		if (!g_last){
			g_last = this;
		} else {
			hide(g_last);
			g_last = this;
		}
		show(this);
	};
	$("content").onmouseup = function(){
		//this.style.backgroundImage = "url(img/Buttons/tab_info_on.png)";
		if (!g_last){
			g_last = this;
		} else {
			hide(g_last);
			g_last = this;
		}
		show(this);
	};
	
	g_last = $("general");
	show(g_last);
};

writingStylesStartup = function(){
	/*
		Writing styles startup function is made to set up all the writing styles
		this user is entitled to use with WhiteSmoke.
		
		The function doesn't recieve any input , but it uses the window.external object
		inorder to recieve the user available writing styles and the active style.
	*/
	var obj = $("writingStyles");
	var availableStyles = new VBArray(window.external.AvailableProfiles).toArray();
	
	//new Array("General","Business","Legal","Medical","Creative Writing");
	
	var i,aRef,j;
	var aStr = "<ul>";
	j=0;
	
	for (i=0;i<availableStyles.length;i++){
		aStr += "<li>"+availableStyles[i]+"</li>";
		j++;
		if (j==3){
			aStr += "</ul><ul class=\"secondUL\">";
			j=0;
		}
	}
	
	aStr += "</ul>";
	
	obj.innerHTML = aStr;
	return;
};

hide = function(o){
	/* Hides the tab content */
	$(o.id).style.backgroundImage = "url(img/Buttons/tab_"+o.id+"_off.png)";
	$(o.id + "Content").style.display = "none";
	return true;
};

show = function(o){
	/* Shows the tab content */
	$(o.id).style.backgroundImage = "url(img/Buttons/tab_"+o.id+"_on.png)";
	$(o.id + "Content").style.display = "block";
	return true;
};
