///////////////////////////////////////////////////////////////
//	
//	ws_functions.js 
//	
// 	javascript code to handle display for the ws service
//
///////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////
//
//  utility function to detect if the char is alphanumeric
//
//
//
///////////////////////////////////////////////////////////////
function is_alpha_numeric(the_char) {

	if ((the_char < 48) || (the_char > 122) || 
	   ((the_char > 57) && (the_char < 65)) || 
	   ((the_char > 90) && (the_char < 97))   ) {
		return false;
	} else {
		return true;
	}
}
 

///////////////////////////////////////////////////////////////
//
// ws_dialog - to manage and control events to the exit dialog which is displayed when a change has been made in the text area.
// 	
// 	public functions :
// 		init
// 		get_display_status
// 		set_display_status
// 		move_focus
//
//
///////////////////////////////////////////////////////////////
var ws_dialog = new function(){

	this.active = false;
	// initialize the dialog box for showing 
	this.init = function(){

		// initilization for confirmation dialog

		jQuery('#ws_dialog').hide();
		jQuery("#wsArea").contentEditable = true; 

		this.setYesNo = function(){
			jQuery('#ws_dialog .noButton').show();
			jQuery('#ws_dialog .yesButton').show();
			jQuery('#ws_dialog .okButton').hide();
			jQuery('#ws_dialog .okButton').unbind();
		}
		this.setOK = function(){
			jQuery('#ws_dialog .noButton').hide();
			jQuery('#ws_dialog .noButton').unbind();
			jQuery('#ws_dialog .yesButton').hide();
			jQuery('#ws_dialog .yesButton').unbind();
			jQuery('#ws_dialog .okButton').show();
		}

		// make buttons larger and center the dialog
	//	jQuery('#ws_dialog .close').css({'width' : '23px','height' : '16px'});
		jQuery('#ws_dialog .okButton').css({'width' : '71px','height' : '30px'});
		jQuery('#ws_dialog .noButton').css({'width' : '50px','height' : '30px'});
		jQuery('#ws_dialog .yesButton').css({'width' : '50px','height' : '30px'});
		jQuery('#ws_dialog').css({'display' : 'block',position:'absolute','left': "25%" , 'top' :"25%" , 'margin':'0','padding':'0'});
		//jQuery('#ws_dialog').css({'display' : 'block',position:'absolute','left': jQuery("#wsArea").width()/2 - 150 , 'top' :jQuery("#wsArea").height()/2 , 'margin':'0','padding':'0'});
		
		
		jQuery('#ws_dialog').dblclick(function (event) { 
				event.preventDefault();
				event.stopPropagation();
		    });
	
		// handle open dialog event	
		var myOpen=function(hash) {  			
			dialogOn = 1;
			ypSlideOutMenuContext.hideCurrentMenu();
			ypSlideOutMenuDictionary.hideCurrentMenu();

			window.external.EnableHotkeyRecheck(false);
			ws_dialog.active = true;
			ws_dialog.set_display_status(true);
			jQuery('#ws_dialog').css({'display' : 'block',position:'absolute','left': jQuery("#wsArea").width()/2 - 150 , 'top' :jQuery("#wsArea").height()/2 , 'margin':'0','padding':'0'});
			jQuery("#wsArea").contentEditable = false; 
			jQuery('#ws_dialog .yesButton').focus(); 
			ws_dialog._button_currently_focused = 'y';
			g_pop_up_visible = true;
			document.getElementById("rightlowerSizeAdjuster").onmousedown = null;
		};

		// handle open dialog event	
		var myClose=function(hash) { 
			window.external.EnableHotkeyRecheck(true);
			ws_dialog.active = false;
			ws_dialog.set_display_status(false);
			//var x = ws_dialog.get_display_status();

			hash.w.fadeOut('10',function(){ 
					hash.o.remove();
					jQuery("#wsArea").contentEditable = true; 
					jQuery("#wsArea").focus(); 
			}); 
			g_pop_up_visible = false;
			document.getElementById("rightlowerSizeAdjuster").onmousedown = function(){
				if (event.button == 1){
					window.external.ResizeMouseDown();
				}
			};
		}; 
	
		// prepare the dialog for showing
		jQuery('#ws_dialog').jqm({overlay: 40, modal: true, trigger: false,onHide:myClose,onShow:myOpen}).jqmAddClose('#ws_dialog .close');
		
		// handle yes - no buttons
		//jQuery('#ws_dialog .noButton').click(function() { jQuery('#ws_dialog').jqmHide();window.external.Close(); });
		//jQuery('#ws_dialog .yesButton').focus().click(function() { jQuery('#ws_dialog').jqmHide(); cleanSuggestionsApply(); });
		
		// tab jumps for focus 
		jQuery('#ws_dialog .yesButton').keypress(function (e) {
				if (e.which == 9) {
					jQuery('#ws_dialog .noButton').focus();
					ws_dialog._button_currently_focused = 'n';
				}
				window.external.SetTransparentColor(0xffff00);
			});
		
		jQuery('#ws_dialog .noButton').keypress(function (e) {
				if (e.which == 9) {
					jQuery('#ws_dialog .close').focus();
					ws_dialog._button_currently_focused = 'x';
				}
				window.external.SetTransparentColor(0xffff00);
			});
		
		jQuery('#ws_dialog .close').keypress(function (e) {
				if (e.which == 9) {
					jQuery('#ws_dialog .yesButton').focus();
					ws_dialog._button_currently_focused = 'y';
				}
				window.external.SetTransparentColor(0xffff00);
			});
		
		/************AH***********************/
		
		jQuery('#ws_dialog .close').mouseenter( function(e){
			this.style.backgroundImage = "url(img/screens/caption_bar_close_over.gif)";
		});
		jQuery('#ws_dialog .close').mouseleave( function(e){
			this.style.backgroundImage = "url(img/screens/screen_captionbar_up.gif)";
		});
		jQuery('#ws_dialog .close').mousedown( function(e){
			this.style.backgroundImage = "url(img/screens/screen_captionbar_press.gif)";
			//jQuery('#ws_dialog').jqmHide();
			//window.external.SetTransparentColor(0xffff00);
			jQuery('#ws_dialog').css({'display' : 'none'});
			jQuery("#wsArea").get(0).contentEditable = true; 
			jQuery("#wsArea").focus();
			dialogOn = 0;
			
		});
		jQuery('#ws_dialog .close').mouseup( function(e){
			jQuery('#ws_dialog').css({'display' : 'none'});
			jQuery("#wsArea").get(0).contentEditable = true; 
			jQuery("#wsArea").focus();
			dialogOn = 0;
			//jQuery('#ws_dialog').jqmHide();
			//window.external.SetTransparentColor(0xffff00);
		});
		
		/* // for the esc key (currently client captures and doesn't send it to the js so we can't handle it)
		jQuery('#ws_dialog').keyup(function (e) { if (e.which == 27) alert('keyup escaped!');	});				
		jQuery('#ws_dialog .yesButton').keyup(function(event){   if (event.keyCode == 27) alert('keyup yes escaped!');});
		$(document).keyup(function(event){   if (event.keyCode == 27) alert('keyup document escaped!');	});*/
		
		jQuery("#wsArea").focus(); 

	}	

	this._display_status 		= false;

	this._button_currently_focused 	= 'y'; // y (yes),n(n),x(top right)
	
	// display flags to be aware if the display is open or closed (visible?)
	this.get_display_status = function()		{ return ws_dialog._display_status; 		}
	this.set_display_status = function(is_displayed){ ws_dialog._display_status = is_displayed; 	}
	
	// for arrow key movement
	this.move_focus = function(in_direction){
		if (ws_dialog.get_display_status()){ 
			if (in_direction == "left"){// handle button focus for left arrow click s
				switch(ws_dialog._button_currently_focused){
				case 'y':	jQuery('#ws_dialog .close').focus(); ws_dialog._button_currently_focused = 'x'; break;
				case 'n':	jQuery('#ws_dialog .yesButton').focus(); ws_dialog._button_currently_focused = 'y'; break;
				case 'x':	jQuery('#ws_dialog .noButton').focus(); ws_dialog._button_currently_focused = 'n'; break;
				}
			}else
			if (in_direction == "right"){ // handle button focus for righ arrow clicks
				switch(ws_dialog._button_currently_focused){
				case 'y':	jQuery('#ws_dialog .noButton').focus(); ws_dialog._button_currently_focused = 'n'; break;
				case 'n':	jQuery('#ws_dialog .close').focus(); ws_dialog._button_currently_focused = 'x'; break;
				case 'x':	jQuery('#ws_dialog .yesButton').focus(); ws_dialog._button_currently_focused = 'y'; break;
				}	
			}else
			if (in_direction == "top"){//currently not handled
			}else
			if (in_direction == "bottom"){// currently not handled
			}
		}
	}
}

function alert_object(in_object){
	var temp = "";
	for (x in in_object){
		temp += x + ": " + in_object[x] + "\n";
		//alert(x + ": " + in_object[x]);
	}
	alert (temp);	
}


function log_object(in_object){
	var temp = "";
	for (x in in_object){
		temp += x + ": " + in_object[x] + "\r";
		//alert(x + ": " + in_object[x]);
	}
	//alert (temp);
	console.log(temp);
}

var ws_characters = new function(){ 

/* // a good way to print out the object
ret = prompt ("Enter object", "document");
obj = eval(ret);
var temp = "";
for (x in obj)
        temp += x + ": " + obj[x] + "\n";
alert (temp);
 */ 	

	this.get_element_at_selection 	= function (in_offset){
		if (jQuery.browser.mozilla) {
			// firefox /mozilla
			//textarea.setSelectionRange(start, end);
			alert('not implemented for offsets!!!');
		     	return jQuery(window.getSelection().anchorNode);
		} else  if (jQuery.browser.msie) {
			// non standard -> IE
		     	var range 	= document.selection.createRange();
			var tmp_range	= range.duplicate();
			if (in_offset!=0) tmp_range.move("character", in_offset);
			return jQuery(document.elementFromPoint(tmp_range.offsetLeft , tmp_range.offsetTop));		
		 }; 
	}
	this.move_cursor_to_start= function (){
		    range 	= document.selection.createRange();
			range.moveToElementText(document.getElementById("wsArea"));
			range.collapse(true);
			range.select();
	}
	this.move_cursor_to_end= function (){
		    range 	= document.selection.createRange();
			range.moveToElementText(document.getElementById("wsArea"));
			range.collapse(true);
			range.select();
	}
	this.move_cursor 	= function (in_offset){
		    range 	= document.selection.createRange();
			range.collapse(true);
			range.moveStart('character', in_offset);
			range.moveEnd('character', 0);
			range.select();
	}

	this.handle_none_alphanumeric 	= function(in_char_code){
		if (!is_alpha_numeric(in_char_code)){
			
			var manage_placement = false;
			var character	 = String.fromCharCode(in_char_code);
			switch(in_char_code){
				case 32: manage_placement = true; break;
				case 13: {
						character	 = "<br cr='r'/>";
						manage_placement = true;
						return true;
						break;
					 }
			}
			// current 	:  wsArea,id
			// left 	:  centralArea,wsArea,id
			// right 	:  "" | centralArea,wsArea,id

			var current_element 	= this.get_element_at_selection(0);
			var left_element 	= this.get_element_at_selection(-1);
			var right_element 	= this.get_element_at_selection(1);
			if (current_element.parent().parent().attr('id') == 'wsArea') 	current_element =  current_element.parent();
			if (left_element.parent().parent().attr('id') == 'wsArea')	left_element 	=  left_element.parent() ;
			if (right_element.parent().parent().attr('id') == 'wsArea') 	right_element 	=  right_element.parent() ;
			var current_id		= current_element.attr('id');
			var left_id 		= left_element.attr('id');
			var right_id 		= right_element.attr('id');

			if (manage_placement){
				// helper function
				var is_ws 	= function(id){ return ((id != "wsArea") && (id != "wsAreaHolder") && (id!="centralArea") && (id!="")); };
				// insert &nbsp instead of the regular space
				if (character == " ") character	 = String.fromCharCode(160);

				window.external.AddLog(0,left_id + " | " + current_id + " | " + right_id);
				
				//alert(is_ws(left_id) +" | "+ is_ws(current_id) +" | "+ is_ws(right_id)) ;
				if (is_ws(left_id) && is_ws(current_id) && is_ws(right_id) && ((left_id==current_id) && (right_id==current_id) && (left_id == right_id))) {
					//alert('ws/ws/ws');
				}else
				if ((left_id=="wsAreaHolder") && is_ws(current_id) && is_ws(right_id)) {
					current_element.before(character);
					return false;
				}else
				if (is_ws(left_id) && is_ws(current_id) && is_ws(right_id) && ((left_id!=current_id) || (right_id!=current_id) || (left_id != right_id))) {
					// removed below to fix bug 662, need the actual scenerio that will require the code (don't remember it).
					//current_element.after(character);
					//this.move_cursor(1);
					//return false;
				}else
				if (is_ws(left_id) && is_ws(current_id) && (right_id=="wsArea")) {
					return true;
					//current_element.after(character);
					//this.move_cursor(1);
					//return false;
					//alert('ws/ws/wsArea');
				}else
				if ((left_id=="wsArea") && is_ws(current_id) && is_ws(right_id)) {
					current_element.before(character);
					//current_element.before(character);
					//alert('wsArea/ws/ws');
					return false;
				}else
				if (is_ws(left_id) && (current_id=="wsArea") && (right_id=="wsArea")) {
					left_element.after(character);
					this.move_cursor(1);
					return false;
					//alert('ws/wsArea/wsArea');
				}else
				if ((left_id=="wsAreaHolder") && (current_id='wsArea') && (right_id='wsAreaHolder')) {
					//alert('wsAreaHolder/wsArea/wsAreaHolder');
					//if (in_char_code == 32) alert('space !@');
					return true;
				}else
				if (is_ws(left_id) && (current_id='wsArea') && (right_id='wsAreaHolder')) {
					//alert('wsAreaHolder/wsArea/wsAreaHolder');
					left_element.after(character);
					this.move_cursor(1);
					return false;
				}else
				if (is_ws(left_id) && (current_id=="wsArea") && is_ws(right_id)) {
					left_element.after(character);
					this.move_cursor(1);
					return false;
					//alert('ws/wsArea/ws');
				}else
				if ((left_id=="wsArea") && is_ws(current_id) && (right_id=="wsArea")) {
					current_element.before(character);
					return false;
					//alert('wsArea/ws/wsArea');
				}else
				if ((left_id=="wsArea") && (current_id=="wsArea") && (right_id=="wsArea")) {
					//alert('wsArea/wsArea/wsArea');
				}else
				if (is_ws(left_id) && (current_id=="wsArea") && (right_id=="centralArea")) {
					left_element.after(character);
					this.move_cursor(1);
					return false;
					//alert('ws/wsArea/centralArea');
				}else
				if (is_ws(left_id) && (current_id=="wsArea") && (right_id=="")) {
					left_element.after(character);
					return false;
					//alert('ws/wsArea/""');
				}else
				if ((left_id=="") && is_ws(current_id) && is_ws(right_id)) {
					current_element.before(character);
					return false;
					//alert('""/ws/ws');
				}else
				if (is_ws(left_id) && (current_id=="") && is_ws(right_id)) {
					current_element.after(character);
					return false;
					//alert('ws/""/ws');
				}else
				if ((left_id=="centralArea") && is_ws(current_id) && (right_id=="wsArea")) {
					current_element.before(character);
					return false;
					//alert('centralArea/""/wsArea');
				}else
				if ((left_id=="centralArea") && is_ws(current_id) && is_ws(right_id)) {
					current_element.before(character);
					return false;
					//alert('centralArea/ws/ws');
				}
				//alert(jQuery('#wsArea').html());	
					// check if the left 
				// the different combination  
				//ws,ws,ws		- ws / internal
				//ws,ws,wsArea  	- ws / internal
				//wsArea,ws,ws  	- area / before
				//wsArea,ws,wsArea  	- area / after 
				//ws,wsArea,ws  	- area / after 
				//ws,wsArea,wsArea  	- area / after
				//wsArea,wsArea,wsArea  - area / none
				//ws,wsArea,centralArea	- area / after
				//ws,wsArea,""		- area / after
				//"",ws,ws		- area / before (cr)
				//ws,"",ws		- area / after (cr)
				//centralArea,ws,wsArea - area / before
				//centralArea,ws,ws	- area / before

				//alert(element.attr('id')=="");
			}
		
	
			return true;
			//String.fromCharCode(keyCode)
			//if (jQuery.browser.mozilla) preventDefault();
		}
	}
	// replace whitespace with nbsp if there are consecutive whitespaces
	this.set_nbsp	= function (in_text){
		//var reg = new RegExp("([\w]*) (( )+)", "g");

		var text= in_text.replace(/ ( +)/g, function(str) {
			var s = arguments[1].length;
			var a = new Array();
			for(var i = 0; i<s; i++){
				 a.push("&nbsp;");				
			}
			return ' '+a.join('');
		});

		text =	text.replace(/\r\n /g, '\r\n&nbsp;');
		text =	text.replace(/\7 /g, '\7&nbsp;');
		text =	text.replace(/\r /g, '\r&nbsp;');
		text =	text.replace(/\n /g, '\n&nbsp;');
		text =	text.replace(/\t /g, '\t&nbsp;');
		text =  text.replace(eval('/'+String.fromCharCode(11)+' /g'), String.fromCharCode(11)+"&nbsp;");

		return text;

		/* researching a new function to replace the above replaces 
		var x = in_text.replace(/ ((\r\n)*)(\r*)(\n*)(\7*)/g, function(str) {
			alert(arguments.length);
			for(var i = 0 ; i<arguments.length ; i++){
				alert(i + ' , ' + arguments[i]);
			}
			return 'x';
		});*/

	}
}

	// set ellipsis [...] if the word is longer then the allowed bounds of the original word
	// arguments
	//	visible_div 	= the visible div that holds a text div and includes ...
	//	text_div	= the actual div that holds the text 
	function set_ellipsis(visible_div,text_div,ellipsis_id){
		return;
		visible_div 	= "#"+visible_div;
		text_div	= "#"+text_div;
		ellipsis_id	= "#"+ellipsis_id;
		//alert(visible_div + ' , ' + text_div +  ' , ' +ellipsis_id);

		jQuery(visible_div).css('overflow','hidden');
		jQuery(visible_div).css('whiteSpace','nowrap');

		jQuery(text_div).css('overflow','hidden');
		jQuery(text_div).css('float','left');
		jQuery(text_div).css('textAlign','left');
		jQuery(text_div).css('whiteSpace','nowrap');


		var text_width	= get_pixel_width(jQuery(text_div).text(),'Comic Sans MS','14px'); 
		var ellipsis 	= get_pixel_width('...','Comic Sans MS','14px'); 

		var visible_width = jQuery(visible_div).width();

		//jQuery(visible_div).css('background-color','green');
		//jQuery(text_div).css('background-color','yellow');
		//alert(visible_width+"<="+text_width);
		if (visible_width<=text_width){
			var delta = visible_width-ellipsis;
			if (ellipsis > visible_width ) delta = ellipsis;
			jQuery(ellipsis_id).text('...');
			jQuery(ellipsis_id)[0].hidden= false;
			jQuery(text_div).width(delta);
		}else{
			jQuery(visible_div).width(visible_width+3);
			jQuery(text_div).width(visible_width+3);
			jQuery(ellipsis_id).text('');
			jQuery(ellipsis_id)[0].hidden= true;
		}
		
	}


	var ellipsesSpans = new function(){
		
		this.spanVerdanaElement 	= null;
		this.spanComicElement 		= null;
		this.init = function(){
			this.spanVerdanaElement = document.createElement("span");

			this.spanComicElement = document.createElement("span");
			
			this.spanVerdanaElement.style.whiteSpace = "nowrap";
			this.spanComicElement.style.whiteSpace = "nowrap";
			
			this.spanVerdanaElement.style.fontFamily = "Verdana";
			this.spanVerdanaElement.style.fontSize= "15px";
				
			this.spanComicElement.style.fontFamily = "Comic Sans MS";
			this.spanComicElement.style.fontSize= "14px";

		// set for ellipses handling
			var ell = document.getElementById('ellipses_handling');
			ell.appendChild(this.spanVerdanaElement);
			ell.appendChild(this.spanComicElement);
		}
	}

	// get the exact pixel width of a text in a div/span
	function get_pixel_width(text,font_family,font_size)	{
		alert('deprecated'); // see the above 
		//spanElement.innerHTML = text;
		//return spanElement.offsetWidth;
	}

// todo: improve performance !!!!!
	function set_floating_max_width(element){
		var parent_obj 		= element.parent().get(0).childNodes;
		var parent_length 	= parent_obj.length;
		var current_obj 	= element.get(0);
		var sug 		= g_floating_corrections_objects[current_obj.id];
		var length 		= sug.length;
		//alert(current_obj.id);
		for (var j = 0 ; j<length;j++){ 
			var os = sug[j].overlapped_suggestion;
			//alert(os.suggestion.innerHTML);
			//os.suggestion.max_width = 'auto';
			if (os.suggestion.onmouseout == undefined){
				os.suggestion.onmouseover = function(){
					jQuery(this).css({'width':'auto'});	
					if (this.has_remark==undefined)
						jQuery(this).css({'background-color' : '#FFFFFF','z-index':10, 'font-weight' : 'bold'});	
					else
						jQuery(this).css({'background-color' : '#FFFFFF','z-index':10, 'font-weight' : 'regular'});	
					//jQuery(this).css({'background-color' : 'red','z-index':10, 'font-weight' : 'normal'});	
					//highlightSuggestion(this,"'+types[type]+'",1); $("wsArea").contentEditable = false;
				};
				os.suggestion.onmouseout =   function(){	
					//alert(this.max_width);
					//this.style.width 	= this.width;
					//window.external.AddLog(0, " | " + this.max_width+ " | "  );
					var el = document.getElementById(this.phraseID);
					//alert(el.outerHTML);
					jQuery(this).css({'width': this.max_width});	
					jQuery(this).css({'background-color' : '#FFFFFF','z-index':0, 'font-weight' : 'normal'});	
					//'highlightSuggestion(this,"'+types[type]+'",0); $("wsArea").contentEditable = true; ');
				};
			}else{
			}
		}
		if (	(current_obj.className.indexOf("redClass")!=-1) || 
			(current_obj.className.indexOf("greenClass")!=-1) ||
			(current_obj.className.indexOf("blueClass")!=-1)){
				var prev_obj = 0 ;
				var prev_obj_idx =0;
				
				//alert(current_obj.getAttribute('prev'));
				//alert(current_obj.outerHTML);
				var next_obj = current_obj.getAttribute('next');
				if ((next_obj!=undefined) && ( next_obj!= "")){
					//alert(current_obj.id + ' , ' + next_obj);
					var next = g_floating_corrections_objects[next_obj];
					if (next == undefined) return;
					next = next[0];
				
					var current = g_floating_corrections_objects[current_obj.id];
					for (var i = 0 ; i < current.length ; i ++) {
						//alert(next.length);
						//alert( next_obj+ ' = ' + current.innerHTML);
					//	alert(co.style.top + ' != '+ ldx.style.top + ' = ' + ldx.innerHTML);
						
						var width			= 5;
						var os				= current[i].overlapped_suggestion;
						ellipsesSpans.spanComicElement.innerHTML 	= os.suggestion.innerHTML;
						var max_width 			= ellipsesSpans.spanComicElement.offsetWidth;
						if (current[0].style.top != next.style.top) {
							width 			= jQuery('#wsArea').width()-parseInt(current[0].style.left)+25;
							//alert(current[i].innerHTML + " , " + width + " , " + max_width);
						}else{
							width 			= parseInt(next.style.left) - parseInt(current[i].style.left);
						}
						if (max_width < width) 		width = max_width; 
						//alert(os.suggestion.innerHTML);	
						os.suggestion.style.width 	= width;
						os.suggestion.max_width 	= width;
					}
				}else{
					var current = g_floating_corrections_objects[current_obj.id];
					for(var i = 0  ; i < current.length ; i ++){
						var os				= current[i].overlapped_suggestion;
						ellipsesSpans.spanComicElement.innerHTML 	= os.suggestion.innerHTML;
						var width 			= jQuery('#wsArea').width()-parseInt(current[i].style.left)+25;
						var max_width 			= ellipsesSpans.spanComicElement.offsetWidth;
						if (max_width < width) 		width = max_width; 
						os.suggestion.style.width 	= width;
						os.suggestion.max_width 	= width;
					}
				}
		}
	}

var selection_handler= new function(){
	this.sel= "";
	this.set_selection = function(){
		var tmp = "";
		if (window.getSelection){
			tmp = window.getSelection();
		}else if (document.getSelection){
			tmp = document.getSelection();
		}else if (document.selection){
			tmp = document.selection.createRange().text;
		};
		selection_handler.sel = new String(tmp);
		//if (selection_handler.sel=="")  // take care of elements that we don't expect. note - need to find a more effecient way to handle this.
		//	selection_handler.sel= "can't retrieve the selection";
	}
	this.selection_replacement = function(){
		selection_handler.set_selection(); // check if a selection has been made
		if (selection_handler.sel!= "") {
			var r = document.selection.createRange();
			var rd = r.duplicate();
			//alert_object(r);
			r.collapse();
			var el1= document.elementFromPoint(r.offsetLeft , r.offsetTop);	
			while ((el1.id == 'wsAreaHolder') || (el1.id == 'wsArea')){
				var m =  r.move('word');
				el1= document.elementFromPoint(r.offsetLeft , r.offsetTop);	
				if (m==0) break;
			}
			if (el1.id == "" ) el1 = el1.parentNode;
			rd.collapse(false);
			var el2= document.elementFromPoint(rd.offsetLeft , rd.offsetTop);	
			if (el2.id == "" ) {
				if (el2.parentNode.id == "top_correction"){
					var rm = rd.move('word',-1);
					el2= document.elementFromPoint(rd.offsetLeft , rd.offsetTop);	
				}
				el2 = el2.parentNode;
			}

			while ((el2.id == 'wsAreaHolder') || (el2.id == 'wsArea')){
				var rm = rd.move('word',-1);
				el2= document.elementFromPoint(rd.offsetLeft , rd.offsetTop);	
				if (rm==0) break;
			}
			//alert(el1.id + ' - ' +el2.id);
			//alert(jQuery('#wsArea').html());
			do{
				var el1= document.elementFromPoint(r.offsetLeft , r.offsetTop);	
				if (el1.id == "" ) el1 = el1.parentNode;
				if ((el1.id == "" ) || (el1.id == 'wsAreaHolder')) break;
				if ((el1.className == 'word') || (el1.originalWord!=undefined)){
					handle_keypressed_event(el1);
				//	ws_content_manager.remove_word_from_cache(el1);	
				}
				var m =  r.move('word');
			       	if (m==0) break;
			}while(el1.id!=el2.id)
			handle_char_offsets();
			

			// bug 583
			var l1 = el1;
			var l2 = el2;
			if (l1.id == 'centralAreaInnerContainer') return true;
			if (l1.id == 'logo') return true;
			if (l1.id == '') return true;
			var i = 0;
			while(l1.parentNode.id != 'wsArea') {
				l1 = el1.parentNode;
				if (i > 10) return true; // undless loop freezing of app insurance.
				i++;
			}
			if (l2.id == 'logo') return true;
			var i = 0;
			while(l2.parentNode.id != 'wsArea'){
			       	l2 = el2.parentNode;
				if (i > 10) return true; // undless loop freezing of app insurance.
				i++;
			}
			do{
				var tmp_l1 = l1;	
				if (l1.id==l2.id) {
					handle_keypressed_event(tmp_l1);
					// need to check if we are deleting the whole word or partial.
					//jQuery(tmp_l1).remove(); // bug 630 & 639
					break;
				}
				l1 = l1.nextSibling;
				if (l1==null) break;
				if (tmp_l1.id == undefined) continue;
				handle_keypressed_event(tmp_l1);
				//alert(tmp_l1.outerHTML);
				jQuery(tmp_l1).remove();
			}while(l1!=null)	
			handle_char_offsets();

			return true;
		}
		selection_handler.sel= "";
		return false;
	}


}

//Correction -  it should include just the following characters: ')','(' and -'
function ws_remove_punctuation(original_text){
	var t = jQuery(original_text).text();
	if (t != "") original_text = t;
	t = original_text.replace(eval("/(^\\(|\\($|^\\)|\\)$)|^\\-|\\-$/g"),'');
	//alert(t);
	return;
	if (original_text.length >0){
		var mark = new Array();
		var c = original_text.charAt(0);
		for (var i=0; i < 2 ; i++){
			mark[i] = 0;
			switch(c){
				case ')':
					mark[i] =4; //lets use rarely used ascii char to mark replacements to use for top correction
					break;
				case '(':
					mark[i] =5; //lets use rarely used ascii char to mark replacements to use for top correction
					break;
				case '-': 
					mark[i] =6; //lets use rarely used ascii char to mark replacements to use for top correction
					break;
			}	
			c = original_text.charAt(original_text.length-1);
		}
	}
	//alert(mark[1]);
	var temp_text = original_text;
	if (mark[0] != 0 )
		temp_text = mark[0]+temp_text.substring(1); //lets use rarely used ascii char to mark replacements to use for top correction
	if (mark[1] != 0 )
		temp_text=temp_text.substring(0,temp_text.length-1) ; //lets use rarely used ascii char to mark replacements to use for top correction
	//alert(temp_text);

	if ((mark[0] ==0) && (mark[0]==0)) return 0;
	else return temp_text 
}
function ws_apply_punctuation(original_text,new_text){

	// if the word is in a span
	var t = jQuery(original_text);
	if (t != undefined) { 
		t = t.text();
		if (t != "") original_text = t;
	}
	if (original_text.length >0){
		var c = original_text.charAt(original_text.length-1);
		switch(c){
			case '.':
			case ',':
			case '?': new_text+= c;
		}	
	}

	return new_text;
}

function ws_set_thesaurus_click(context){
	log_object(context);
	
	jQuery(".thesaurus_word").hover(
		function(){
			jQuery(this).css("color","blue");
			jQuery(this).css("text-decoration","underline");
		},
		function(){
			jQuery(this).css("text-decoration","none");
			jQuery(this).css("color","black");
		});
	jQuery(".thesaurus_word").click(function(e) {  
		window.external.NotifyLinkContext(jQuery(context).attr("id"));
		window.external.UpdatePhraseText(jQuery(this).text());
		jQuery(context).text(jQuery(this).text());
		jQuery("#_context_menu").hide();
		jQuery(document).unbind('.jeegoocontext');   
		//jQuery("#_context_menu").hide();
		jQuery(context).attr("class","blackClass");
		//cleanupTopCorrections();
		cleanTopCorrectionsForWord(jQuery(context).attr("id"));
		cleanUpMarkedPhrase(jQuery(context).attr("id"));
	});
}
/***********context menu*************/
function ws_retrieve_context_menu_data(in_word,context){
	var _word=/([\w\s]*)/g.exec(in_word);
	
	if (_word[0] == null) _word = in_word;
		else _word = _word[0];

	if (jQuery('#enrichment').data(_word)!=undefined){
		//alert("cached ->" +jQuery('#enrichment').data(_word));
		jQuery('#thesaurus  .content').html(jQuery('#thesaurus').data(_word));
		jQuery('#enrichment  .content').html(jQuery('#enrichment').data(_word));
		jQuery('#explainationTop  .content').html(jQuery('#explainationTop').data(_word));
		jQuery('#howtouse  .content').html(jQuery('#howtouse').data(_word));
		
		jQuery('#define  .content').html(jQuery('#define').data(_word));		
		ws_set_thesaurus_click(context);
	}else{
		jQuery.getScript( "http://www.whitesmoke.com/writer/context_menu.php?id=thesaurus&word="+_word+"&uid="+getUserId(),function(){
			ws_set_thesaurus_click(context);
			jQuery('#thesaurus').data(_word,jQuery('#thesaurus .content').html());
			}
		);
		jQuery.getScript( "http://www.whitesmoke.com/writer/context_menu.php?id=enrichment&word="+_word+"&uid="+getUserId(),
				function(){ 
					jQuery('#enrichment').data(_word,jQuery('#enrichment .content').html());
				}
		);
		/************AH*******************/
		jQuery.getScript( "http://www.whitesmoke.com/writer/context_menu_2011.php?id=explainationTop&word="	+_word+"&uid="+getUserId()+"&client=pearson",
				function(){ 
					//var grammerOptions = new VBArray(window.external.PhraseGrammerOptions).toArray();
					//alert(grammerOptions);
					//console.log(context);
					//alert_object(context);
					//alert(jQuery(context).attr("id").val());
					//myQuery = '.floatingSuggestion '+jQuery(context).attr("id");
					//alert_object(myQuery);
					//alert(jQuery(myQuery).val());
					//alert(jQuery(context).attr("innerText"));															
					jQuery('#explainationTop').data(_word,jQuery('#explainationTop .content').html());
				}
		);	
		
		jQuery.getScript( "http://www.whitesmoke.com/writer/context_menu.php?id=howtouse&word="	+_word+"&uid="+getUserId(),
				function(){ 
					jQuery('#howtouse').data(_word,jQuery('#howtouse .content').html());
				}
		);			
		jQuery.getScript( "http://www.whitesmoke.com/writer/context_menu.php?id=define&word="	+_word+"&uid="+getUserId(),
				function(){ 
					jQuery('#define').data(_word,jQuery('#define .content').html());
				}
		);
	}

}
function ws_apply_context_menu(){
	//we commented it because we couldnt disable the old context menu so we call new one 
	/*jQuery('#context_close_button').click(function(e){ 
			jQuery("#_context_menu").hide();
			jQuery(document).unbind('.jeegoocontext');   
		});
		
	jQuery('.context_menu').jeegoocontext('_context_menu',{
		heightOverflowOffset: 40,
		submenuLeftOffset:5,
		fadeIn: 500,
		onShow : function(e, context){
			//alert_object(context);
			_word = jQuery(context).text();
		 	//jQuery('#menu_title').text("Writing Tools");
			jQuery('#_context_menu .content').text("Retrieving ...");
			jQuery('#_context_menu .content').css("margin-left","10px");
			jQuery('#_context_menu .content').css("margin-right","10px");
			setTimeout(function(){ ws_retrieve_context_menu_data(_word,context);},5);	

		},
		onSelect: function(e, context){

			if (jQuery(e.target).attr("id") =="web_search"){
				_word = jQuery(context).text();
				window.open("http://search.whitesmoke.com/?q="+_word,"_blank");
			}
		}
	
	});*/
};
