/*
	contextMenu class for all the context menus you'll ever need ;-)
*/

g_lastIid = null;

spellingContextMenu = function(id){
	this.id 				= id;
	this.o  				= $(this.id);
	this.ibody				= $(id+"InBody");
	this.body				= $(id+"Body");
	this.captionBar 		= $(id+"CaptionBar");
	this.addToWordBody		= $(id+"AddToWordBody");
	this.addToWord			= $(id+"AddToWord");
	this.footer				= $(id+"Footer");
	this.footer.onmouseup = $(this.id+"FooterButton").onmouseup = new Function("cleanSuggestionsAddToDict(); ypSlideOutMenuContext.hideMenu('"+this.id+"');");	
	g_activeContextID = this.id;
	blockIEContextMenus($(this.id));
 	$(this.id+"Container").oncontextmenu = function(){ event.returnValue = false; };
	$(this.id+"Content").oncontextmenu = function(){ event.returnValue = false; };
};

spellingContextMenu.prototype.fixDimensions = function(){
	/*
		This method should calculate all the correct new distances according to the characters inside.
	*/

	var len = this.getLongestWordLength();
	var words = this.getMaxWords();
			
	//this.originalWidth  = 122;
	//this.originalHeight = 110;
	this.originalWidth  = 104;
	this.originalHeight = 210;
	
	var minCharSafeWidth  = 7;
	var minCharSafeHeight = 14;
			
	var calculatedWidth  = (minCharSafeWidth*len) + 12;
	var calculatedHeight = (minCharSafeHeight*words+5);

	if (len > 18 || calculatedWidth > this.originalWidth){
		//Adjust to new width.
		this.o.style.width 					= calculatedWidth + "px";
		this.captionBar.style.width 		= calculatedWidth + "px";
		this.footer.style.width				= calculatedWidth + "px";
		this.widthComplete = calculatedWidth;
	} else {
		//Revert back to old width.
		this.o.style.width 					= this.originalWidth + "px";
		this.captionBar.style.width 		= this.originalWidth + "px";
		this.footer.style.width				= this.originalWidth + "px";
		this.widthComplete = this.originalWidth;
	}
	
	if (words > 1 || calculatedHeight > this.originalHeight){
		this.addToWord.style.height = calculatedHeight + "px";
		this.heightComplete = calculatedHeight + 210;
	} else {
		this.addToWord.style.height = "18px";
		this.heightComplete = this.originalHeight;
	}
	
	var newWidth  = this.widthComplete;
	var newHeight = this.heightComplete;
	
	this.captionBar.getElementsByTagName("div").item(1).style.width = parseInt(newWidth)-6 + "px";
	this.footer.getElementsByTagName("div").item(1).style.width		= parseInt(newWidth)-6 + "px";
	return true;
};

spellingContextMenu.prototype.getLongestWordLength = function(){
	/*
		This method scans the entire table structure of the context-menu and gets back with the longest word that one
		of the divs should be able to accomodate.
	*/
	var len = 0;
	var i;
	for (i=0;i<this.addToWordBody.rows.length;i++){
		if (this.addToWordBody.rows[i].cells[0].firstChild.nodeValue.length > len)
			len = this.addToWordBody.rows[i].cells[0].firstChild.nodeValue.length;
	}
	
	if ($(this.id+"Word").innerHTML.length > len) len = $(this.id+"Word").innerHTML.length;
	
	return len;
};

spellingContextMenu.prototype.getWidth = function(){
	return this.widthComplete;
};

spellingContextMenu.prototype.getHeight = function(){
	return this.heightComplete;
};

spellingContextMenu.prototype.getMaxWords = function(){
	return this.addToWordBody.rows.length;
};

spellingContextMenu.prototype.createOption = function(aStr){

	var fl = aStr.charCodeAt(0);
	var ll = aStr.charCodeAt(aStr.length-1);
	var beginning = "";
	var ending= "";
	if (!is_alpha_numeric(fl)) aStr=aStr.substr(1);
	if (!is_alpha_numeric(ll)) aStr=aStr.substr(0,aStr.length-1);

	d = document;
	var o  = d.createElement("tr");
	var o2 = d.createElement("td");
	var o4 = d.createElement("td");
	o4.innerHTML = "<img width=\"14\" height=\"13\" src=\"img/spacer.gif\" border=\"0\" />";
	o4.style.textAlign = "right";
	o4.style.paddingRight = "4px";
	
	if (aStr.substr(0,7) == "remark:"){
		// This is the remark mode.
		var o3 = d.createTextNode(aStr.substr(7));
	} else if (aStr.indexOf("(FORGOT A WORD?)") != -1){
		// Another remark mode.
		var o3 = d.createTextNode(aStr);
	} else {
		// Regular grammar suggestion mode.
		var o3 = d.createTextNode(aStr);
	}

	o.appendChild(o2);
	o2.appendChild(o3);
	
	o4.setAttribute("originalWord",aStr);
	o.appendChild(o2);
	o2.appendChild(o3);
	o.appendChild(o4);
	
	//set event handlers
	if (aStr.indexOf("remark:") != -1){
		// This is the remark mode.
		o2.style.cursor = "default";
		o2.style.color = "#666666";
		o2.style.fontStyle = "italic";
	} else if (aStr.indexOf("(FORGOT A WORD?)") != -1){
		// Another remark mode
		o2.style.cursor = "default";
		o2.style.color = "#666666";
		o2.style.fontStyle = "italic";
    } else {
		// Regular spelling suggestion mode.
		o2.style.cursor = "pointer";
		
		o.onmouseover = function(){
			var obj = this.cells[1].getElementsByTagName("img").item(0);
			obj.src = "img/enrichment/qmark.png";
			obj.style.cursor = "pointer";
			obj.onclick = function(){
				showClickDictionary(this.parentNode.parentNode.cells[0].innerText);
			};
			obj.alt = "Show word definition";
		};
		
		o.onmouseout = function(){
			var obj = this.cells[1].getElementsByTagName("img").item(0);
			obj.src = "img/spacer.gif";
			obj.style.cursor = "default";
			obj.onclick = function(){};
			obj.alt = "";
		};

		o2.onmouseover = function(){this.style.color = "#ba0202";};
		o2.onmouseout  = function(){this.style.color = "#000000";};
		
		o2.phrase_id= this.phrase_id;
	
		o2.onclick	   = new Function(" g_is_dirty = true; g_lastIid = null; window.external.UpdatePhraseText(this.innerHTML);  handle_keypressed_event($("+this.phrase_id+")); if (g_cdOpened){ypSlideOutMenuDictionary.hideMenu(g_dictionaryInstance.id);} g_summaryObj.decrementSpelling(); ypSlideOutMenuContext.hideMenu('"+this.id+"');");
	
	}
	return o;
};


spellingContextMenu.prototype.setId	= function(phrase_id){
	this.phrase_id = phrase_id;
}
spellingContextMenu.prototype.setWord = function(aWord){
	$(this.id+"Word").innerHTML = "word";
};

spellingContextMenu.prototype.clearUp = function(o){
	while (o.firstChild)
		o.removeChild(o.firstChild);
	return;
};

spellingContextMenu.prototype.addWords = function(options){
	var i;
	this.clearUp(this.addToWordBody);
	
	for (i=0;i<options.length;i++){
		this.addToWordBody.appendChild(this.createOption(options[i]));
	}
};
