function monitor(){
	this.x = 0;
	this.y = 0;
	this.triggerLength = 0.5;
	this.inc = 0.2;
	this.stack = 0;
	this.hot = false;
	this.pid = null;
}

monitor.prototype.startMonitoring = function(o){
	this.o = o;
	this.hot = true;
	
	if (this.o.tagName.toLowerCase() == "span"){
		this.word = this.o.innerHTML;
	} else if (this.o.tagName.toLowerCase() == "img"){
		this.word = this.o.parentNode.parentNode.cells[0].innerHTML;
	} else {
		this.word = this.o.getElementsByTagName("td").item(0).firstChild.nodeValue;
	}
	
	this.o.onmousemove = function(){
		var o = g_monitorObj;
		o.x = event.clientX;
		o.y = event.clientY;
		o.emptyStack();
		o.detectNonMovement();
	};
	
	return;
};

monitor.prototype.detectNonMovement = function(){
	/*
		This method will run every 0.2 seconds
		(0.2 is the default value to increment by -- can be changed from the value monitor::inc
	*/
	if (!this.hot) return;

	if (this.stack > 0.5){
		setEarlyDictionaryPreloader();
	}	
	
	if (this.stack < this.triggerLength)
		this.incrementStack();
	else
		this.displayDictionary();
	
	if (this.pid){
		clearInterval(this.pid);
		this.pid = setTimeout("g_monitorObj.detectNonMovement();",this.inc*1000);
		return;
	}
	this.pid = setTimeout("g_monitorObj.detectNonMovement();",this.inc*1000);
	return;
};

monitor.prototype.displayDictionary = function(){
	this.hot = false;
	clearInterval(this.pid);
	displayDictionaryHover(this.word);
};

monitor.prototype.incrementStack = function(){
	this.stack = this.stack + this.inc;
	return;
};

monitor.prototype.emptyStack = function(){
	this.stack = 0;
};

monitor.prototype.stopMonitoring = function(o){
	this.hot = false;
	if (g_dictionaryInstance != null){
		obj = g_dictionaryInstance;
		obj.hidePreloader();
	}
	clearInterval(this.pid);
	return;
};