// JavaScript Document

function grammarCache(){
	this.cachedArray = new Array();
}

grammarCache.prototype.cache = function(expId, expStr){
	/*
		This method creates an array and inserts it into the array that holds all the explanations used so far.
		We'll first check if this is already cached.
	*/		
	
	if (!this.exists(expId)){
		/*
			Insert the explanation to the cache.
		*/
		
		this.cachedArray.push({expId:expId,expStr:expStr});
	}
	return true;
};

grammarCache.prototype.exists = function(anExpId){
	/*
		Checks whether the given expId is available already in the cache.
	*/
	var i;
	
	for (i=0;i<this.cachedArray.length;i++)
		if (this.cachedArray[i].expId == anExpId)
			return true;
	return false;
};

grammarCache.prototype.getExplanation = function(expId){	
	if (this.exists(expId)){
		return this.getExplanationByExpId(expId);
	}
	this.lastFailedExpId = expId;
	return false;
};

grammarCache.prototype.getExplanationByExpId = function(expId){
	for (i=0;i<this.cachedArray.length;i++)
		if (this.cachedArray[i].expId == expId)
			return this.cachedArray[i].expStr;
	return false;
};