function gmonitor(){
	this.x = 0;
	this.y = 0;
	this.triggerLength = 2;
	this.inc = 0.2;
	this.stack = 0;
	this.hot = false;
	this.pid = null;
}

gmonitor.prototype.startMonitoring = function(o){
	this.o = o;
	this.hot = true;
	this.word = this.o.getElementsByTagName("td").item(0).firstChild.nodeValue;
	this.o.onmousemove = function(){
		var o = g_gmonitorObj;
		o.x = event.clientX;
		o.y = event.clientY;
		o.emptyStack();
		o.detectNonMovement();
	};
	
	return;
};

gmonitor.prototype.detectNonMovement = function(){
	/*
		This method will run every 0.2 seconds
		(0.2 is the default value to increment by -- can be changed from the value monitor::inc
	*/
	if (!this.hot) return;	
	
	if (this.stack < this.triggerLength)
		this.incrementStack();
	else
		return this.displayDictionary();
	
	if (this.pid){
		clearInterval(this.pid);
		this.pid = setTimeout("g_gmonitorObj.detectNonMovement();",this.inc*1000);
		return;
	}
	this.pid = setTimeout("g_gmonitorObj.detectNonMovement();",this.inc*1000);
	return;
};

gmonitor.prototype.displayDictionary = function(){
	this.hot = false;
	clearInterval(this.pid);
	displayGrammarExplanation(g_phraseId,this.word);
};

gmonitor.prototype.incrementStack = function(){
	this.stack = this.stack + this.inc;
	return;
};

gmonitor.prototype.emptyStack = function(){
	this.stack = 0;
};

gmonitor.prototype.stopMonitoring = function(o){
	this.hot = false;
	clearInterval(this.pid);
	return;
};