/*
	contextMenu class for all the context menus you'll ever need ;-)
*/

enrichmentContextMenu = function(id){
	this.id 				= id;
	this.o  				= $(this.id);
	this.body				= $(id+"Body");
	this.captionBar 		= $(id+"CaptionBar");
	this.addToWordBody		= $(id+"AddToWordBody");
	this.replaceWordBody	= $(id+"ReplaceWordBody");
	this.addToWord			= $(id+"AddToWord");
	this.replaceWord		= $(id+"ReplaceWord");
	this.footer				= $(id+"Footer");
	this.onDemand			= false;

	$("CM_enrichmentFooterButton").onclick = function(){
		t = jQuery("#CM_enrichmentInBody TD[phrase_id='"+g_phraseId+"']:first").text();
		displayGrammarExplanation(g_phraseId,t);
	};

	g_activeContextID = this.id;
	blockIEContextMenus($(this.id));
 	$(this.id+"Container").oncontextmenu = function(){ event.returnValue = false; };
	$(this.id+"Content").oncontextmenu = function(){ event.returnValue = false; };
};

enrichmentContextMenu.prototype.fixDimensions = function(){
	/*
		This method should calculate all the correct new distances according to the characters inside.
	*/
	
	var len = this.getLongestWordLength();
	var words = this.getMaxWords();

	if (!this.addToWordBody.rows.length){
		this.originalWidth  = 130;
	} else {
		this.originalWidth  = 223;
	}
	this.originalHeight = 54;
	
	var minCharSafeWidth  = 5;
	var minCharSafeHeight = 14;
	
	var calculatedWidth  	  = (minCharSafeWidth*len);
	var calculatedTotalWidth  = (minCharSafeWidth*len*2) + 20;
	if (!this.addToWordBody.rows.length){
		calculatedTotalWidth  = Math.round((minCharSafeWidth*len*1.400));
	}
	var calculatedHeight 	  = (minCharSafeHeight*words) + 20;
	
	if (len > 20 || calculatedWidth > this.originalWidth){
		//Adjust to new width.		
		this.o.style.width 					= calculatedTotalWidth + "px";
		this.captionBar.style.width 		= calculatedTotalWidth + "px";
		this.footer.style.width				= calculatedTotalWidth + "px";
		
		if (!this.addToWordBody.rows.length){
			// Only replace a word mode..
			if (window.XMLHttpRequest){
				// IE 7, mozilla, safari, opera 9
				this.replaceWord.style.width 		= (calculatedTotalWidth-2) + "px";
			} else {
				// IE6
				this.replaceWord.style.width 		= (calculatedTotalWidth-2) + "px";
			}
		} else {
			if (window.XMLHttpRequest){
				// IE 7, mozilla, safari, opera 9
				this.addToWord.style.width   		= (calculatedWidth+6) + "px";
				this.replaceWord.style.width 		= (calculatedWidth+6) + "px";
			} else {
				// IE6
				this.addToWord.style.width   		= calculatedWidth + "px";
				this.replaceWord.style.width 		= calculatedWidth + "px";
			}
		}
		
		this.widthComplete = calculatedTotalWidth;
	} else {
		//Revert back to old width.
		this.o.style.width 					= this.originalWidth + "px";
		this.captionBar.style.width 		= this.originalWidth + "px";
		this.footer.style.width				= this.originalWidth + "px";
		
		if (!this.addToWordBody.rows.length){
			// We're inside the only replace a word mode.
			if (window.XMLHttpRequest){
				// IE 7, mozilla, safari, opera 9
				this.replaceWord.style.width 		= (this.originalWidth-2) + "px";
			} else {
				// IE6
				this.replaceWord.style.width 		= (this.originalWidth-2) + "px";
			}
		} else {
			// Obviously we're not in it now ain't we ? :-)
			if (window.XMLHttpRequest) {
				// IE 7, mozilla, safari, opera 9
				this.addToWord.style.width = "108px";
				this.replaceWord.style.width = "112px";
			} else {
				// IE6, older browsers
				this.addToWord.style.width = "109px";
				this.replaceWord.style.width = "100px";
			}
		}
		
		this.widthComplete = this.originalWidth;
	}

	if (words > 1 || calculatedHeight > this.originalHeight){
		this.addToWord.style.height   = calculatedHeight + "px";
		this.replaceWord.style.height = calculatedHeight + "px";
		this.heightComplete = calculatedHeight + 20;
	} else {		
		if (!this.addToWordBody.rows.length){
			// if this condition evaluates , it means
			// that we are in the ONLY replace a word mode.
			this.replaceWord.style.height = "34px";
		}
		
		if (window.XMLHttpRequest) {
			// IE 7, mozilla, safari, opera 9
			this.addToWord.style.height = "34px";
		} else {
			//IE6
			this.addToWord.style.height = "18px";
		}
		
		
		this.heightComplete = this.originalHeight;
	}
	
	var newWidth  = this.widthComplete;
	var newHeight = this.heightComplete;
	
	this.captionBar.getElementsByTagName("div").item(1).style.width = parseInt(newWidth)-6 + "px";
	this.footer.getElementsByTagName("div").item(1).style.width		= parseInt(newWidth)-6 + "px";
	return true;
};

enrichmentContextMenu.prototype.getLongestWordLength = function(){
	/*
		This method scans the entire table structure of the context-menu and gets back with the longest word that one
		of the divs should be able to accomodate.
	*/
	var len = 0;
	var i;
	for (i=0;i<this.addToWordBody.rows.length;i++){		
		if (this.addToWordBody.rows[i].cells[0].firstChild.nodeValue.length > len)
			len = this.addToWordBody.rows[i].cells[0].firstChild.nodeValue.length;
	}
	
	for (i=0;i<this.replaceWordBody.rows.length;i++){		
		if (this.replaceWordBody.rows[i].cells[0].firstChild.nodeValue.length > len)
			len = this.replaceWordBody.rows[i].cells[0].firstChild.nodeValue.length;
	}
	
	if ($(this.id+"Word").innerHTML.length > len) len = $(this.id+"Word").innerHTML.length;
	
	return len;
};

enrichmentContextMenu.prototype.getWidth = function(){
	return this.widthComplete+2;
};

enrichmentContextMenu.prototype.getHeight = function(){
	return this.heightComplete+67;
};

enrichmentContextMenu.prototype.getMaxWords = function(){
	return ( this.addToWordBody.rows.length > this.replaceWordBody.rows.length ) ? this.addToWordBody.rows.length : this.replaceWordBody.rows.length;
};

enrichmentContextMenu.prototype.createOption = function(aStr,aType){
	d = document;
	var o  = d.createElement("tr");
	var o2 = d.createElement("td");
	var o4 = d.createElement("td");
	o4.innerHTML = "<img width=\"14\" height=\"13\" src=\"img/spacer.gif\" border=\"0\" />";
	o4.style.textAlign = "right";
	
	if (aStr.substr(0,7) == "remark:"){
		// This is the remark mode.
		var o3 = d.createTextNode(aStr.substr(7));
	} else if (aStr.indexOf("(FORGOT A WORD?)") != -1){
		// Another remark mode.
		var o3 = d.createTextNode(aStr);
	} else {
		// Regular enrichment suggestion mode.
		var o3 = d.createTextNode(aStr);
	}

	o.appendChild(o2);
	o2.appendChild(o3);
	
	o4.setAttribute("originalWord",aStr);
	o.appendChild(o2);
	o2.appendChild(o3);
	o.appendChild(o4);
	
	//set event handlers
	if (aStr.indexOf("remark:") != -1){
		// This is the remark mode.
		o2.style.cursor = "default";
		o2.style.color = "#666666";
		o2.style.fontStyle = "italic";
		o.removeChild(o4);
	} else if (aStr.indexOf("(FORGOT A WORD?)") != -1){
		// Another remark mode
		o2.style.cursor = "default";
		o2.style.color = "#666666";
		o2.style.fontStyle = "italic";
    } else {
		// Regular enrichment suggestion mode.
		o2.style.cursor = "pointer";		
		
		o.onmouseover = function(){
			var obj = this.cells[1].getElementsByTagName("img").item(0);			
			obj.src = "img/enrichment/qmark.png";
			obj.style.cursor = "pointer";
			obj.onclick = function(){
				showClickDictionary(this.parentNode.parentNode.cells[0].innerText);
			};
			obj.alt = "Show word definition";			
		};
		
		o.onmouseout = function(){
			var obj = this.cells[1].getElementsByTagName("img").item(0);
			obj.src = "img/spacer.gif";
			obj.style.cursor = "default";
			obj.onclick = function(){};
			obj.alt = "";
		};
		
		o2.phrase_id= this.phrase_id;
		o2.onmouseover = function(){this.style.color = "#0293b8";};
		o2.onmouseout  = function(){this.style.color = "#000000";};
		if (aType == "add"){
			o2.onclick	   = new Function("g_is_dirty=true; g_lastIid = null; window.external.AddEnrichmentWord(this.innerHTML); handle_keypressed_event($("+this.phrase_id+")); if (g_cdOpened){ypSlideOutMenuDictionary.hideMenu(g_dictionaryInstance.id);} window.external.UpdatePhraseText(ws_apply_punctuation(g_plainRef.innerHTML, this.innerHTML)); ypSlideOutMenuContext.hideMenu('"+this.id+"');");
		} else {
			if (this.onDemand){	// ZIV: The NotifyPlainPhraseClicked below adds the enrichment on demand change to the undo stack
				o2.onclick	   = new Function("g_is_dirty=true; ypSlideOutMenuContext.hideMenu('"+this.id+"'); window.external.AddStatistics(\"Enrichment:\"+this.innerHTML); window.external.NotifyPlainPhraseClicked(g_plainRef.innerHTML, this.innerHTML); g_lastIid = null; /****g_plainRef.innerHTML = g_leftSide + this.innerHTML + g_rightSide; ***/ if (g_cdOpened){ypSlideOutMenuDictionary.hideMenu(g_dictionaryInstance.id);} window.external.UpdatePhraseText(ws_apply_punctuation(g_plainRef.innerHTML, this.innerHTML)); handle_keypressed_event($("+this.phrase_id+")); g_summaryObj.decrementEnrichment(); ");
			} else {
				//o2.onclick	   = new Function("ypSlideOutMenuContext.hideMenu('"+this.id+"'); window.external.AddStatistics(\"Enrichment:\"+this.innerHTML); window.external.NotifyPlainPhraseClicked(g_plainRef.innerHTML, this.innerHTML); g_lastIid = null; if (g_cdOpened){ypSlideOutMenuDictionary.hideMenu(g_dictionaryInstance.id);} window.external.UpdatePhraseText(ws_apply_punctuation(g_plainRef.innerHTML, this.innerHTML)); handle_keypressed_event($("+this.phrase_id+")); g_summaryObj.decrementEnrichment(); ");
				o2.onclick	   = new Function("g_is_dirty=true; g_lastIid = null; ypSlideOutMenuContext.hideMenu('"+this.id+"');handle_keypressed_event($(this.phrase_id)); window.external.UpdatePhraseText( this.innerHTML); g_summaryObj.decrementEnrichment(); ");
			}		
		}
	}
	return o;
};


enrichmentContextMenu.prototype.setId	= function(phrase_id){
	this.phrase_id = phrase_id;
}

enrichmentContextMenu.prototype.setWord = function(aWord){
	$(this.id+"Word").innerHTML = "word";
};

enrichmentContextMenu.prototype.clearUp = function(o){
	this.addToWord.style.height = "";
	this.replaceWord.style.height = "";
	while (o.firstChild)
		o.removeChild(o.firstChild);
	return;
};

enrichmentContextMenu.prototype.addWordOptions = function(options){	
	this.clearUp(this.addToWordBody);
	if (!options) return;
	var i;	
	
	for (i=0;i<options.length;i++){		
		this.addToWordBody.appendChild(this.createOption(options[i],"add"));
	}
};

enrichmentContextMenu.prototype.replaceWordOptions = function(options){	
	this.clearUp(this.replaceWordBody);
	if (!options) return;
	var i;
	
	for (i=0;i<options.length;i++){
		this.replaceWordBody.appendChild(this.createOption(options[i],"replace"));
	}
};
