/*
	contextMenu class for all the context menus you'll ever need ;-)
*/


dictionaryContextMenu = function(id){
	this.id 				= id;
	this.o  				= $(this.id);
	this.ibody				= $(id+"InBody");
	this.body				= $(id+"Body");
	this.captionBar			= $(id+"CaptionBar");
	this.addToWordBody		= $(id+"AddToWordBody");
	this.addToWord			= $(id+"AddToWord");
	this.footer				= $(id+"Footer");
	this.loader				= $(id+"TblContainer");	
	g_dictionaryInstance = this;
	blockIEContextMenus($(this.id));
 	$(this.id+"Container").oncontextmenu = function(){ event.returnValue = false; };
	$(this.id+"Content").oncontextmenu = function(){ event.returnValue = false; };
};

dictionaryContextMenu.prototype.fixDimensions = function(){
	/*
		This method should calculate all the correct new distances according to the characters inside.
	*/

	var len = this.getLongestWordLength();
	var words = this.getMaxWords();
	var widthAdjusted   	= (len * 7) + 20;
	var widthComplete 		= widthAdjusted + 20;
	var heightAdjusted  	= (words * 15) + 24;
	var heightComplete 		= heightAdjusted + 43;
	
	this.addToWord.style.height = "";
	this.addToWord.style.overflowY = "";
	$("CM_dictionaryInBody").style.width = "100%";
	
	if (widthComplete > this.o.offsetWidth){
		// Adjust main table cells to accomdate this size !
		this.o.style.width 					= widthComplete + "px";
		this.captionBar.style.width			= widthComplete + "px";
		this.footer.style.width				= widthComplete + "px";
		this.addToWord.style.width 			= widthAdjusted+3 + "px";
		$("CM_dictionaryInBody").style.width		= widthComplete-3 +"px";
		this.widthComplete  = widthComplete;
	}
	
	if (this.addToWord.offsetHeight > 150){
		this.addToWord.style.height = "150px";
		this.addToWord.style.overflowY = "auto";
		$("CM_dictionaryInBody").style.width = "";
	}
	
	this.widthComplete  = this.o.offsetWidth;
	this.heightComplete = this.o.offsetHeight;
	
	if (heightComplete > this.o.offsetHeight){
		this.heightComplete = heightComplete;
	}
	
	var newWidth  = this.o.offsetWidth;
	var newHeight = this.o.offsetHeight;
	this.captionBar.getElementsByTagName("div").item(1).style.width = parseInt(newWidth)-6 + "px";
	this.footer.getElementsByTagName("div").item(1).style.width		= parseInt(newWidth)-6 + "px";
	return true;
};

dictionaryContextMenu.prototype.getLongestWordLength = function(){
	/*
		This method scans the entire table structure of the context-menu and gets back with the longest word that one
		of the divs should be able to accomodate.
	*/
	var len = 0;
	var i;
	
	if ($(this.id+"Word").innerHTML.length > len) len = $(this.id+"Word").innerHTML.length;
	
	return len;
};

dictionaryContextMenu.prototype.getWidth = function(){
	return this.widthComplete;
};

dictionaryContextMenu.prototype.getHeight = function(){
	return this.heightComplete;
};

dictionaryContextMenu.prototype.getMaxWords = function(){
	return 0;
};

dictionaryContextMenu.prototype.setLoading = function(aBool){
	/*
		Set the loading wheel to the appropriate mode inorder to let time for the screen to load.
	*/
	switch (aBool){
		case true:
			// Show the loading wheel
			$("CM_dictionaryLoadingTblContainer").style.height	= $("CM_dictionaryAddToWord").offsetHeight;
			$("CM_dictionaryLoadingTblContainer").style.width	=$("CM_dictionaryAddToWord").offsetWidth - 4;
			
			$("CM_dictionaryAddToWord").style.display = "none";
			$("CM_dictionaryLoadingTblContainer").style.display = "block";
		break;
		
		case false:
			// Hide the loading wheel
			$("CM_dictionaryAddToWord").style.display = "block";
			$("CM_dictionaryLoadingTblContainer").style.display = "none";
			this.adjustAndCheckDimensions();
		break;
	}
	return true;
};

dictionaryContextMenu.prototype.adjustAndCheckDimensions = function(){
	$(this.id+"Container").style.height = this.o.offsetHeight;
	$(this.id+"Container").style.width = this.o.offsetWidth;
	$(this.id+"Content").style.height = this.o.offsetHeight;
	$(this.id+"Content").style.width = this.o.offsetHeight;
	
	window.status = this.o.offsetX + " : " + this.o.offsetY;
	
	//eval("$('"+this.id+"Container').style."+cord1direction+" = '"+cord1+"px';");
	//eval("$('"+this.id+"Container').style."+cord2direction+" = '"+cord2+"px';");
};

dictionaryContextMenu.prototype.createOption = function(aStr){
	d = document;
	var o  = d.createElement("tr");
	var o2 = d.createElement("td");
	var o3 = d.createTextNode(aStr);
	o.appendChild(o2);
	o2.appendChild(o3);
	
	//set event handlers
	o2.style.cursor = "pointer";
	o2.onmouseover = function(){ this.style.color = "#009345"; };
	o2.onmouseout  = function(){ this.style.color = "#000000"; };
	o2.onclick	   = new Function("ypSlideOutMenuDictionary.hideMenu('"+this.id+"');");
	return o;
};

dictionaryContextMenu.prototype.getNewTranslation = function(){
	if (g_dictionaryStatus == 0 && g_dictionaryLanguageState != 1){
		displayYouHaveToPurchaseDictionary(true);
		setDefaultLanguage(1);
		ypSlideOutMenuDictionary.hideMenu(this.id);
		eval(g_cDonMouseUp);
		$("CM_dictionaryLangSelect").selectedIndex = 0;
		$("wsArea").onmouseup = function(){};
		$("wsArea").onmousedown = function(){};
		return;
	}
	
	this.setLoading(true);
	$("CM_dictionaryLangSelect").disabled = "disabled";
	new Ajax.Request(dictionaryGetActionLink(),{
		method:"post",
		asynchronous: false,
		parameters:{
			action:"dictionaryContextTranslation",
			text:this.currentWord,
			langId:g_dictionaryLanguageState
		},
		onComplete: function(transport){
			if (typeof(g_dictionaryInstance) == "object"){
				obj = g_dictionaryInstance;
			} else {
				return;
			}
			$("CM_dictionaryAddToWord").innerHTML = transport.responseText;
			obj.setLoading(false);
			$("CM_dictionaryLangSelect").disabled = "";
		}
	});
};

dictionaryContextMenu.prototype.hidePreloader = function(){
	$("dictionaryPreloaderlefttop").style.display = "none";
	$("dictionaryPreloaderleftbottom").style.display = "none";
	$("dictionaryPreloaderrighttop").style.display = "none";
	$("dictionaryPreloaderrightbottom").style.display = "none";
	return;
};

dictionaryContextMenu.prototype.setCoords = function(x,y){
	this.x = x;
	this.y = y;
	return true;
};

dictionaryContextMenu.prototype.showPreloader = function(){	
	var evt = new Object();
	evt.clientX = this.x;
	evt.clientY = this.y;
	var obj = $("wsArea");
	var wsWidth = obj.offsetWidth;
	var wsHeight = obj.offsetHeight;
	var docWidth  = document.documentElement.clientWidth;
	var docHeight = document.documentElement.clientHeight;
	var CM_width = 160;
	var CM_height = 48;
	
	var xSub = Math.abs(wsWidth-(evt.clientX-18));
	var ySub = Math.abs(wsHeight-(evt.clientY-100));
	var xDirection = (xSub > CM_width)  ? "left" : "right";
	var yDirection = (ySub > CM_height) ? "top" : "bottom";
	var dDirection = (yDirection == "top") ? "down" : "up";
	var openX	   = (xDirection == "left") ? evt.clientX-29 : Math.abs(docWidth - evt.clientX)-33;
	var openY	   = (yDirection == "top")  ? evt.clientY : Math.abs(docHeight - evt.clientY);
	eval("$('dictionaryPreloader" + xDirection+yDirection + "').style." + xDirection + " = '" + openX + "px';");
	eval("$('dictionaryPreloader" + xDirection+yDirection + "').style." + yDirection + " = '" + openY + "px';");	
	$("dictionaryPreloader"+xDirection+yDirection).style.display 	= "block";
	return;
};

dictionaryContextMenu.prototype.setWord = function(aWord,x,y){
	this.currentWord = aWord;
	this.x = x;
	this.y = y;
	//this.showPreloader();
	
	new Ajax.Request(dictionaryGetActionLink(),{
		method:"post",
		asynchronous: false,
		parameters:{
			action:"dictionaryContextTranslation",
			text:this.currentWord,
			langId:g_dictionaryLanguageState
		},
		onComplete: function(transport){
			$("CM_dictionaryAddToWord").innerHTML = transport.responseText;
			if (typeof(g_dictionaryInstance) == "object"){
				obj = g_dictionaryInstance;
			} else {
				return;
			}
			obj.hidePreloader();
			obj.slide();
		}
	});
};

dictionaryContextMenu.prototype.slide = function(){
		var evt = new Object();
		evt.clientX = this.x;
		evt.clientY = this.y;
		

		var obj = $("wsArea");
		var wsWidth = obj.offsetWidth;
		var wsHeight = obj.offsetHeight;
		var contextMenuID = "CM_dictionary";
		var docWidth  = document.documentElement.clientWidth;
		var docHeight = document.documentElement.clientHeight;
	
		this.fixDimensions();
		var CM_height = this.getHeight();
		var CM_width  = this.getWidth();
				
		var xSub = Math.abs(wsWidth-(evt.clientX-18));
		var ySub = Math.abs(wsHeight-(evt.clientY-100));
		var xDirection = (xSub > CM_width)  ? "left" : "right";
		var yDirection = (ySub > CM_height) ? "top" : "bottom";
		var dDirection = (yDirection == "top") ? "down" : "up";
		var openX	   = (xDirection == "left") ? evt.clientX : Math.abs(docWidth - evt.clientX);
		var openY	   = (yDirection == "top")  ? evt.clientY : Math.abs(docHeight - evt.clientY);
		
		if (typeof(g_activeContextObj) == "object" && g_ddOpened){
			/*
				This means a context menu has been opened , and we should adjust to not hide it with our cm dictionary !
				Hint: this is the place where we do it ...
			*/
					
			var availableWidthFromRight = (g_activeContextObj.xDirection == "left") ? (docWidth - g_activeContextObj.openX - g_activeContextObj.width-13) : (g_activeContextObj.openX-13);
			var availableWidthFromLeft	 = (g_activeContextObj.xDirection == "left") ? (g_activeContextObj.openX-13) : (docWidth - g_activeContextObj.openX - g_activeContextObj.width - 13);
			if (availableWidthFromRight > 273 || availableWidthFromLeft > 273){
				xDirection  = (availableWidthFromRight > CM_width+3) ? "left" : "right";

				if (xDirection == "left"){
					openX = (g_activeContextObj.xDirection == "left") ? (g_activeContextObj.openX + g_activeContextObj.width + 3) : (docWidth - g_activeContextObj.openX + 3);
				} else {
					openX = (g_activeContextObj.xDirection == "left") ? (docWidth-g_activeContextObj.openX+3) : (g_activeContextObj.width+g_activeContextObj.openX+3);
				}
			}
		}

		/* Phase 4 :: Create the ypSlideOutMenu instance */
		if ($(this.id+"Word").innerHTML == this.currentWord && g_cdOpened){
			/*
				This termination of the method , is placed inorder to prevent the dictioary from being shown twice
				if it's already opened on the same word and still moused out of tracking..!
			*/
			return;
		}
		
		new ypSlideOutMenuDictionary(contextMenuID, dDirection, openX, openY-37, CM_width, CM_height, xDirection, yDirection);
		$(this.id+"Word").innerHTML = this.currentWord;
		ypSlideOutMenuDictionary.showMenu(contextMenuID);
};

dictionaryContextMenu.prototype.clearUp = function(o){
	while (o.firstChild)
		o.removeChild(o.firstChild);
	return;
};

dictionaryContextMenu.prototype.addWords = function(options){
	var i;
	this.clearUp(this.addToWordBody);
	
	for (i=0;i<options.length;i++){
		this.addToWordBody.appendChild(this.createOption(options[i]));
	}
};

/*****************************************************
 * ypSlideOutMenu
 * 3/04/2001
 * 
 * a nice little script to create exclusive, slide-out
 * menus for ns4, ns6, mozilla, opera, ie4, ie5 on 
 * mac and win32. I've got no linux or unix to test on but 
 * it should(?) work... 
 *
 * --youngpup--
 *****************************************************/

ypSlideOutMenuDictionary.Registry = [];
ypSlideOutMenuDictionary.aniLen = 250;
ypSlideOutMenuDictionary.hideDelay = 100;
ypSlideOutMenuDictionary.minCPUResolution = 10;

ypSlideOutMenuDictionary.current_id = 0;

// constructor
function ypSlideOutMenuDictionary(id, dir, cord1, cord2, width, height,cord1direction,cord2direction){
	$("wsArea").onmouseup = function(){};
	this.ie  = document.all ? 1 : 0;
	this.ns4 = document.layers ? 1 : 0;
	this.dom = document.getElementById ? 1 : 0;

	if (this.ie || this.ns4 || this.dom){
		this.id			 = id;
		this.dir		 = dir;
		this.orientation = dir == "left" || dir == "right" ? "h" : "v";
		this.dirType	 = dir == "right" || dir == "down" ? "-" : "+";
		this.dim		 = this.orientation == "h" ? width : height;
		this.hideTimer	 = false;
		this.aniTimer	 = false;
		this.open		 = false;
		this.over		 = false;
		this.startTime	 = 0;

		// global reference to this object
		this.gRef = "ypSlideOutMenuDictionary_"+id;
		eval(this.gRef+"=this");

		// add this menu object to an internal list of all menus
		ypSlideOutMenuDictionary.Registry[id] = this;
		g_dictionaryObj = this;
				
				// Get the DOM object reference
				var oC  = $(this.id+"Container");
				var oC2 = $(this.id+"Content");
				
				oC.style.visibility = "hidden";
				// clear up old coordinates (incase it was used before, and now we're using a different direction)
				oC.style.left = "";
				oC.style.right = "";
				oC.style.top = "";
				oC.style.bottom = "";
				
				oC2.style.left = "";
				oC2.style.right = "";
				oC2.style.top = "";
				oC2.style.bottom = "";
				
				eval("$('"+this.id+"Container').style."+cord1direction+" = '"+cord1+"px';");
				eval("$('"+this.id+"Container').style."+cord2direction+" = '"+cord2+"px';");
				oC.style.overflow = "hidden";
				oC.style.zIndex = "10000";
				oC.style.position = "absolute";
				oC.style.width = width + "px";
				oC.style.height = height+4 + "px";
				
				oC2.style.position = "absolute";
				oC2.style.width = width + "px";
				oC2.style.height = height + "px";
				
 		this.load();
	}
}

ypSlideOutMenuDictionary.prototype.load = function(){
	var d = document;
	var lyrId1 = this.id + "Container";
	var lyrId2 = this.id + "Content";
	
	var obj1 = this.dom ? d.getElementById(lyrId1) : this.ie ? d.all[lyrId1] : d.layers[lyrId1]
	if (obj1) var obj2 = this.ns4 ? obj1.layers[lyrId2] : this.ie ? d.all[lyrId2] : d.getElementById(lyrId2)
	var temp

	if (!obj1 || !obj2) window.setTimeout(this.gRef + ".load()", 100);
	else {
		this.container	= obj1;
		this.menu		= obj2;
		this.style		= this.ns4 ? this.menu : this.menu.style;
		this.homePos	= eval("0" + this.dirType + this.dim);
		this.outPos		= 0;
		this.accelConst	= (this.outPos - this.homePos) / ypSlideOutMenuDictionary.aniLen / ypSlideOutMenuDictionary.aniLen;
	
		//set initial state
		this.endSlide();
	}
};
	
ypSlideOutMenuDictionary.showMenu = function(id){
	ypSlideOutMenuDictionary.current_id = id;
	var reg = ypSlideOutMenuDictionary.Registry;
	var obj = ypSlideOutMenuDictionary.Registry[id];
	
	if (obj.container){
		obj.over = true;

		// close other menus.
		for (menu in reg) if (id != menu) ypSlideOutMenuDictionary.hide(menu);
		
		// if this menu is scheduled to close, cancel it.
		if (obj.hideTimer) { reg[id].hideTimer = window.clearTimeout(reg[id].hideTimer) }

		// if this menu is closed, open it.
		if (!obj.open && !obj.aniTimer) reg[id].startSlide(true);
		ypSlideOutMenuDictionary.setState(id,true);

		$("wsArea").onmouseup = new Function("ypSlideOutMenuDictionary.hideMenu('"+id+"'); ypSlideOutMenuDictionary.revertOldEventHandlers();");
		$("wsArea").onmousedown = new Function("if (ypSlideOutMenuDictionary.getState('"+id+"') && event.button == 2){ $('wsArea').onmouseup = function(){}; } ");
		g_cdOpened = true;
	}
};

ypSlideOutMenuDictionary.revertOldEventHandlers = function(){
	/*
		Reverting back to the old events of onmouseup and onmousedown
		of the already opened context menu incase there is one open...
		They are located in the global variables called
		g_cDonMouseUp
		g_cDonMouseDown
	*/
	if (!g_ddOpened) return;
	$("wsArea").onmouseup = new Function(g_cDonMouseUp);
	$("wsArea").onmousedown = new Function(g_cDonMouseDown);
	return true;
};
ypSlideOutMenuDictionary.hideCurrentMenu = function(){
	if (ypSlideOutMenuDictionary.current_id!=0)
		ypSlideOutMenuDictionary.hideMenu(ypSlideOutMenuDictionary.current_id);
}

ypSlideOutMenuDictionary.hideMenu = function(id){	
	ypSlideOutMenuDictionary.current_id = 0;
	// schedules the menu to close after <hideDelay> ms, which
	// gives the user time to cancel the action if they accidentally moused out
	$("wsArea").onmouseup = function(){};
	$("wsArea").onmousedown = function(){};
	var obj = ypSlideOutMenuDictionary.Registry[id];
	if (obj.container && obj.open) {
		if (obj.hideTimer) window.clearTimeout(obj.hideTimer);
		obj.hideTimer = window.setTimeout("ypSlideOutMenuDictionary.hide('" + id + "')", ypSlideOutMenuDictionary.hideDelay);
		g_cdOpened = false;
	}
};

ypSlideOutMenuDictionary.hide = function(id){
	var obj = ypSlideOutMenuDictionary.Registry[id];
	obj.over = false;

	if (obj.hideTimer) window.clearTimeout(obj.hideTimer);
	
	// flag that this scheduled event has occured.
	obj.hideTimer = 0;

	// if this menu is open, close it.
	if (obj.open && !obj.aniTimer) obj.startSlide(false);
};

ypSlideOutMenuDictionary.prototype.startSlide = function(open){
	this[open ? "onactivate" : "ondeactivate"]();
	this.open = open;
	if (open) this.setVisibility(true);
	this.startTime = (new Date()).getTime();
	this.aniTimer = window.setInterval(this.gRef + ".slide()", ypSlideOutMenuDictionary.minCPUResolution);
};

ypSlideOutMenuDictionary.prototype.slide = function(){
	var elapsed = (new Date()).getTime() - this.startTime
	if (elapsed > ypSlideOutMenuDictionary.aniLen) this.endSlide()
	else {
		var d = Math.round(Math.pow(ypSlideOutMenuDictionary.aniLen-elapsed, 2) * this.accelConst)
		if (this.open && this.dirType == "-")		d = -d
		else if (this.open && this.dirType == "+")	d = -d
		else if (!this.open && this.dirType == "-")	d = -this.dim + d
		else										d = this.dim + d

		this.moveTo(d);
	}
}

ypSlideOutMenuDictionary.prototype.endSlide = function(){
	this.aniTimer = window.clearTimeout(this.aniTimer)
	this.moveTo(this.open ? this.outPos : this.homePos)
	if (!this.open) this.setVisibility(false)
	if ((this.open && !this.over) || (!this.open && this.over)) {
		this.startSlide(this.over);
	}
};

ypSlideOutMenuDictionary.prototype.setVisibility = function(bShow) { 
	var s = this.ns4 ? this.container : this.container.style
	s.visibility = bShow ? "visible" : "hidden"
};
ypSlideOutMenuDictionary.prototype.moveTo = function(p) { 
	this.style[this.orientation == "h" ? "left" : "top"] = this.ns4 ? p : p + "px"
};
ypSlideOutMenuDictionary.prototype.getPos = function(c){
	return parseInt(this.style[c]);
};

ypSlideOutMenuDictionary.setState = function(id,aState){	
	g_openRegistry[id]=aState;
	return;
};

ypSlideOutMenuDictionary.getState = function(id){
	return g_openRegistry[id];
};

// events
ypSlideOutMenuDictionary.prototype.onactivate		= function() { }
ypSlideOutMenuDictionary.prototype.ondeactivate	= function() { }
