/***************************************
*	transInterface.js
*	initialize and handle translator actions
*
****************************************/
window.onload = function(){	
	goButton();
	humanButton();
	getFullTextLanguages();	
	
	
	var link = ''+window.location;
	if(link.indexOf('?text=') != -1){
		transToLang = window.external.GetRegistryValue("transToLang",'');
		if(transToLang =='')
			transToLang = 'English';
		index = link.indexOf('=');		
		text = String(link).substring(index+1);
		$('#translation_text').attr('value',text);
		jQuery('#translate_fromLangId').attr('value','English');
		getTranslationKeyPressed(transToLang);		
		
	} // here when we press enter
	else
		setDefaultLanguage();
		
	$('#translation_text').focus();	
	window.external.SetTransparentColor(0xffff00);
	
	$('#translate_from_lang_field').mousedown(function() {	//fix select bug	
		jQuery('#translator_form').css('height','160px');
	});	
	$('#translate_to_lang_field').mousedown(function() {	//fix select bug	
		jQuery('#translator_form').css('height','160px');
	});	
	
};
/*************************************************************/
goButton = function(){
	$("#translate_button").mouseover(function() {
		$(this).attr('src','img/Buttons/go_over.gif');
	});
	$("#translate_button").mousedown(function() {
		$(this).attr('src','img/Buttons/go_press.gif');
		window.external.AddStatistics("translator:translatorGoButton");
		getTranslationResult();
	});
	$("#translate_button").mouseout(function() {
		$(this).attr('src','img/Buttons/go_up.gif');
	});
	$("#translate_button").mouseup(function() {
		$(this).attr('src','img/Buttons/go_up.gif');
	});
};
/*************************************************************/
humanButton = function(){
	$("#humanTranslation").mouseover(function() {
		$(this).attr('src','img/Buttons/humanTranslation_roll.gif');
	});
	$("#humanTranslation").mousedown(function() {
		$(this).attr('src','img/Buttons/humanTranslation_press.gif');
		window.external.AddStatistics("translator:humanTranslationButton");
		openHumanTranslation();
	});
	$("#humanTranslation").mouseout(function() {
		$(this).attr('src','img/Buttons/humanTranslation_up.gif');
	});
	$("#humanTranslation").mouseup(function() {
		$(this).attr('src','img/Buttons/humanTranslation_up.gif');
	});
};
/*************************************************************/
openHumanTranslation = function(){		
	var text = jQuery('#translation_text').text();
	source_text = urlEncode(text);
	if(source_text == "Enter your text here ...")
		source_text="";
	var source = jQuery('#translate_fromLangId').attr('value');
	var target = jQuery('#translate_toLangId').attr('value');
	
	window.external.OpenDefaultBrowser("http://www.onehourtranslation.com/affiliate/whitesmokeaff/?source_text="+source_text+"&source="+source+"&target="+target);
}
/*************************************************************/
getFullTextLanguages = function(){	
	//the data parameters didnt work in post so i added them to the url
	$.ajax({  
        method: 'post',
        url: "http://www.whitesmoke.com/translator/ajax_actions.php",
		data: {action: "full_text_languages" , version : "2011" ,userID: getUserId(),distID: getDistId() },
        error: function(){
            setDefaultLanguages();//if the server is down
			//setComboxFullText();
        },
        success: function(data){
			//if(data != 'google')
				eval(data);
			//setComboxFullText();			
		}  
    });
};
/*************************************************************/
function setDefaultLanguages(){
	jQuery('#translate_from_lang_field').html("<select name='translate_fromLangId' id='translate_fromLangId'>\
<option value='English'>English</option><option value='Arabic'>Arabic</option>\
<option value='French' >French</option><option value='German'>German</option>\
<option value='Italian'>Italian</option><option value='Portuguese'>Portuguese</option>\
<option value='Russian' >Russian</option><option value='Spanish'>Spanish</option>\
<option value='Chinese'>Chinese</option></select>");

	jQuery('#translate_to_lang_field').html("<select name='translate_toLangId' id='translate_toLangId'>\
<option value='English'>English</option>\
<option value='Arabic'>Arabic</option>\
<option value='French' >French</option>\
<option value='German'>German</option>\
<option value='Italian'>Italian</option>\
<option value='Portuguese'>Portuguese</option>\
<option value='Russian' >Russian</option>\
<option value='Spanish'>Spanish</option>\
<option value='Chinese'>Chinese</option>\
</select>");
	
}
/*************************************************************/
getUserId = function(){
    return window.external.GetUserID;
};
/*************************************************************/
getDistId = function(){
	return window.external.GetDist();
};
/*************************************************************/
function setComboxFullText(){

	jQuery("#translate_fromLangId").combobox({
        maxVisibleOptions: 6,
        callbackSelectOption: function(value){
		//jQuery('#combobox_container_translate_toLangId .combobox_input').attr('value',value);
        }
    });
    jQuery("#translate_toLangId").combobox({
        maxVisibleOptions: 6,
        callbackSelectOption: function(value){		
		//jQuery('#combobox_container_translate_fromLangId .combobox_input').attr('value',value);
        }
    });

	 jQuery('#combobox_container_translate_fromLangId').mousedown(function(e){
        jQuery('#combobox_container_translate_fromLangId a.combobox_button').click();
    });
    jQuery('#combobox_container_translate_toLangId').mousedown(function(e){
        jQuery('#combobox_container_translate_toLangId a.combobox_button').click();
    });
    	
	
    jQuery("ul.combobox_summary li").hover(function(){
        jQuery('a', this).css({
            "font-weight": "bold"
        });
        jQuery(this).css({
            "background-color": "lightgrey"
        });
    }, function(){
        jQuery('a', this).css({
            "font-weight": "normal"
        });
        jQuery(this).css({
            "background-color": "white"
        });
    });

}
/*************************************************************/
resetTranslationArea = function(){
	var text = jQuery('#translation_text').text();
	if(text == "Enter your text here ..."){
		jQuery('#translation_text').html("");
		jQuery('#translation_text').select();
	}
	else{
		 if(text == "")
			jQuery('#translation_text').select();
		}
}
/*************************************************************/
setDefaultLanguage = function(){	
	var transToLang = window.external.GetRegistryValue("transToLang",'');	
		
	if(transToLang =='')
		transToLang = 'English';
	
	var To = new String(transToLang);
	//jQuery('#translate_toLangId').attr('value',To.valueOf());	
	jQuery('#combobox_container_translate_toLangId .combobox_input').attr('value',To.valueOf());
};
/*************************************************************/
getTranslationResult = function()
{
	closeLanguageDropDown();
	this.wait('true','ajaxWait');	
	var text = jQuery('#translation_text').text();	
	text = urlEncode(text);
	
	var from = jQuery('#translate_fromLangId').attr('value');
	var to = jQuery('#translate_toLangId').attr('value');
	
	window.external.SetRegistryValue('transToLang',to); // default
	
	uid =window.external.GetUserID;
    distId = window.external.GetDist();
	   
	jQuery('#translation_result').attr('src', "http://www.whitesmoke.com/translator/alphabetic_full_text_client_google.php?uid=" + uid +"&distId="+distId+ "&text=" + text + "&from=" + from + "&to=" + to);	
	
}
/*************************************************************/
getTranslationKeyPressed = function(transToLang)
{
	closeLanguageDropDown();
	this.wait('true','ajaxWait','translator');	
	var text = jQuery('#translation_text').text();
	
	text = urlEncode(text);
	
	var from = jQuery('#translate_fromLangId').attr('value');	
	var to = transToLang;
	window.external.SetRegistryValue('transToLang',transToLang); // default	
	uid =window.external.GetUserID;
    distId = window.external.GetDist();
		
	jQuery('#translate_toLangId').attr('value',transToLang);
	jQuery('#translation_result').attr('src', "http://www.whitesmoke.com/translator/alphabetic_full_text_client_google.php?uid=" + uid +"&distId="+distId+ "&text=" + text + "&from=" + from + "&to=" + to);	
	//alert_object(jQuery('#combobox_container_translate_toLangId .combobox_input'));
	//jQuery('#combobox_container_translate_toLangId .combobox_input').attr('value',transToLang);
	//setDefaultLanguage();	
};
/*************************************************************/
function urlEncode(str){
	return encodeURI(str);	
/*	
    str = escape(str);
    str = str.replace(new RegExp('\\+', 'g'), '%2B');
    return str.replace(new RegExp('%20', 'g'), '+');
    */
}
/*************************************************************/
wait = function(state, id , source){		
    switch (state) {
        case "true":{
           jQuery('#ajaxWait').css('display', 'block');
			
        }
	break;
        case "false":{
           jQuery('#ajaxWait').css('display', 'none');
			if(source == 'translator')
			  setDefaultLanguage();
        }
	break;
    }
};
/*************************************************************/
function closeLanguageDropDown(){	
    jQuery('ul.combobox_summary').hide();
    jQuery('#combobox_overlay').hide();
    jQuery('#translator_form').css('height','31px');
}
/*************************************************************/
function alert_object(in_object){
	var temp = "";
	for (x in in_object){
		temp += x + ": " + in_object[x] + "\n";
		//alert(x + ": " + in_object[x]);
	}
	alert (temp);	
}
/*************************************************************/